/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AcccurrentData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractSaveDataHandler;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;

public class SaveAcccurrentDataHandler
extends AbstractSaveDataHandler {
    private static final String ACCOUNT_MASTERID = "account.masterid";
    private static final String ENDINITPERIOD = "endinitperiod";
    private static final String ISENDINIT = "isendinit";
    private static final String MODIFYDATE = "modifydate";
    private static final String MODIFIER_ID = "modifier_id";
    private static final String T_GL_ACCCURRENT = "T_GL_ACCCURRENT";
    protected static final int SPLIT_EXECUTE_COUNT = 5000;
    private static final String INSERT_BAL_SQL = "INSERT INTO T_GL_ACCCURRENT(FID,FORGID,FBOOKTYPEID,FPERIODID,FACCTABLEID,FACCOUNTID,FASSGRPID,FCURRENCYID,FAMOUNTFOR,FAMOUNTBALFOR,FLOCALCURRENCYID,FAMOUNT,FAMOUNTBAL,FBIZDATE,FEXPIREDATE,FBIZNUM,FDESCRIPTION,FSTATUS,FVCHENTRYID,FSOURCETYPE,FVOUCHERID,FMODIFYTIME,FCREATETIME, FMASTERID, FEFFECTIVEDATE, FUNEFFECTIVEDATE, FENTRYDC, FCREATORID, FWRITEOFFPERSONID, FBOOKEDDATE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    protected static final String UPDATE_OLDACCT_SQL = "UPDATE T_GL_ACCCURRENT SET FMODIFYTIME=?, FUNEFFECTIVEDATE=? WHERE FID=?";

    @Override
    public void handle(SingleAccountRefContext context) {
        this.updateOldBalData(context);
        this.insertBalData(context);
        Collection newAcctIds = context.getAcctTblRef().getAccountRef().getOldAndNewAccountRef().values();
        for (Long newAcctId : newAcctIds) {
            UnAcccurrentUpdateUtil.asyncReCalUnAcccurrent(context.getOrgId(), context.getBookTypeId(), context.getAcctTblRef().getNewAccountTableId(), newAcctId);
        }
    }

    private void updateOldBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        Collection<AbstractBalData> oldBalDatas = context.getOldBalDatas();
        Date date = TimeServiceHelper.now();
        for (AbstractBalData oldBalData : oldBalDatas) {
            AcccurrentData balData = (AcccurrentData)oldBalData;
            Object[] updateParam = new Object[]{date, balData.getUneffectivedate(), balData.getId()};
            updateParams.add(updateParam);
            if (updateParams.size() < 5000) continue;
            this.patchExecute(UPDATE_OLDACCT_SQL, updateParams);
            updateParams.clear();
        }
        if (updateParams.size() > 0) {
            this.patchExecute(UPDATE_OLDACCT_SQL, updateParams);
        }
    }

    private void insertBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(1024);
        List<AbstractBalData> newBalDatas = context.getInsertBalDatas();
        long[] pkIds = DB.genLongIds((String)T_GL_ACCCURRENT, (int)newBalDatas.size());
        int pkIdx = 0;
        Long orgId = context.getOrgId();
        Long bookTypeId = context.getBookTypeId();
        Long acctTblId = context.getAcctTblRef().getNewAccountTableId();
        Date date = TimeServiceHelper.now();
        for (AbstractBalData newBalData : newBalDatas) {
            AcccurrentData balData = (AcccurrentData)newBalData;
            Object[] insertParam = new Object[]{pkIds[pkIdx], orgId, bookTypeId, balData.getPeriodId(), acctTblId, balData.getAcctMasterId(), balData.getAssgrpId(), balData.getCurrencyId(), balData.getAmountFor(), balData.getAmountBalFor(), balData.getLocalCurrency(), balData.getAmount(), balData.getAmountBal(), balData.getBizDate(), balData.getExpireDate(), balData.getBizNum(), balData.getDescription(), balData.getStatus(), balData.getVchEntryId(), balData.getSourceType(), balData.getVoucherId(), date, date, balData.getMasterId(), balData.getEffectivedate(), balData.getUneffectivedate(), balData.getEntryDc(), balData.getCreator(), balData.getWriteOffPerson(), balData.getBookedDate()};
            insertParams.add(insertParam);
            ++pkIdx;
            if (insertParams.size() < 5000) continue;
            this.patchExecute(INSERT_BAL_SQL, insertParams);
            insertParams.clear();
        }
        if (insertParams.size() > 0) {
            this.patchExecute(INSERT_BAL_SQL, insertParams);
        }
        this.rewriteInitState(context, orgId, bookTypeId, acctTblId, date);
    }

    private void rewriteInitState(SingleAccountRefContext context, Long orgId, Long bookTypeId, Long acctTblId, Date date) {
        AccountTableRef accountTableRef = context.getAcctTblRef();
        Map<Long, Long> oldAcctMasterIdAndIdMap = this.queryMasterAndIdMap(context);
        Map<Long, Long> newAcctAndInitPeriodMap = this.buildNewAcctInitPeriod(context, orgId, bookTypeId, accountTableRef, oldAcctMasterIdAndIdMap);
        this.removeExistsStateAccount(context, orgId, bookTypeId, newAcctAndInitPeriodMap);
        this.saveInitState(orgId, bookTypeId, acctTblId, date, newAcctAndInitPeriodMap);
    }

    private void saveInitState(Long orgId, Long bookTypeId, Long acctTblId, Date date, Map<Long, Long> newAcctAndInitPeriodMap) {
        ArrayList<DynamicObject> reciprocalStates = new ArrayList<DynamicObject>(newAcctAndInitPeriodMap.size());
        String userId = RequestContext.get().getUserId();
        for (Map.Entry<Long, Long> entry : newAcctAndInitPeriodMap.entrySet()) {
            DynamicObject reciprocalInitState = BusinessDataServiceHelper.newDynamicObject((String)"gl_reci_init_state");
            reciprocalInitState.set("org", (Object)orgId);
            reciprocalInitState.set("booktype", (Object)bookTypeId);
            reciprocalInitState.set("accounttable", (Object)acctTblId);
            reciprocalInitState.set("account", (Object)entry.getKey());
            reciprocalInitState.set(ENDINITPERIOD, (Object)entry.getValue());
            reciprocalInitState.set(ISENDINIT, (Object)true);
            reciprocalInitState.set(MODIFIER_ID, (Object)Long.valueOf(userId));
            reciprocalInitState.set(MODIFYDATE, (Object)date);
            reciprocalStates.add(reciprocalInitState);
        }
        if (!reciprocalStates.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])reciprocalStates.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, Long> buildNewAcctInitPeriod(SingleAccountRefContext context, Long orgId, Long bookTypeId, AccountTableRef accountTableRef, Map<Long, Long> oldAcctMasterIdAndIdMap) {
        HashMap<Long, Long> newAcctAndInitPeriodMap = new HashMap<Long, Long>(1024);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter acctTblFilter = new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getOldAccountTableId());
        QFilter accountFilter = new QFilter(ACCOUNT_MASTERID, "in", oldAcctMasterIdAndIdMap.keySet());
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reci_init_state", (String)"account.masterid masterid, endinitperiod", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, acctTblFilter, accountFilter}, null);){
            for (Row row : dSet) {
                Long newId;
                Long oldMasterId = row.getLong("masterid");
                Long oldId = oldAcctMasterIdAndIdMap.get(oldMasterId);
                if (oldId == null || (newId = accountTableRef.getNewAccountId(oldId)) == null) continue;
                Long maxPeriod = (Long)newAcctAndInitPeriodMap.get(newId);
                Long oldPeriod = row.getLong(ENDINITPERIOD);
                maxPeriod = maxPeriod != null ? (maxPeriod.compareTo(oldPeriod) > 0 ? maxPeriod : oldPeriod) : oldPeriod;
                newAcctAndInitPeriodMap.put(newId, maxPeriod);
            }
        }
        return newAcctAndInitPeriodMap;
    }

    private Map<Long, Long> queryMasterAndIdMap(SingleAccountRefContext context) {
        HashMap<Long, Long> oldAcctMasterIdAndIdMap = new HashMap<Long, Long>(1024);
        try (DataSet acctSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", context.getOldAccountIds())}, null);){
            for (Row row : acctSet) {
                oldAcctMasterIdAndIdMap.put(row.getLong("masterid"), row.getLong("id"));
            }
        }
        return oldAcctMasterIdAndIdMap;
    }

    private void removeExistsStateAccount(SingleAccountRefContext context, Long orgId, Long bookTypeId, Map<Long, Long> newAcctAndInitPeriodMap) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter acctTblFilter = new QFilter("accounttable", "=", (Object)context.getAcctTblRef().getNewAccountTableId());
        QFilter accountFilter = new QFilter("account", "in", newAcctAndInitPeriodMap.keySet());
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reci_init_state", (String)"account", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, acctTblFilter, accountFilter}, null);){
            for (Row row : dSet) {
                newAcctAndInitPeriodMap.remove(row.getLong("account"));
            }
        }
    }
}

