/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractSaveDataHandler;
import kd.fi.gl.balcal.log.ChangeType;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;

public class SaveAcctSumBalDataHandler
extends AbstractSaveDataHandler {
    protected static final String T_GL_ACCTBALANCE = "T_GL_ACCTBALANCE";
    private static final String INSERT_BAL_SQL = "INSERT INTO T_GL_ACCTBALANCE(FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FACCOUNTTABLEID,FACCOUNTID,FCURRENCYID,FMEASUREUNITID,FBEGINFOR,FBEGINLOCAL,FBEGINQTY,FYEARDEBITFOR,FYEARDEBITLOCAL,FYEARDEBITQTY,FYEARCREDITFOR,FYEARCREDITLOCAL,FYEARCREDITQTY,FENDFOR,FENDLOCAL,FENDQTY,FMODIFYTIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_BAL_SQL = "UPDATE T_GL_ACCTBALANCE SET FBEGINFOR=?,FBEGINLOCAL=?,FBEGINQTY=?,FYEARDEBITFOR=?,FYEARDEBITLOCAL=?,FYEARDEBITQTY=?,FYEARCREDITFOR=?,FYEARCREDITLOCAL=?,FYEARCREDITQTY=?,FENDFOR=?,FENDLOCAL=?,FENDQTY=?,FMODIFYTIME=? WHERE FID=?";
    protected final BalChangeLogger balLogger = BalChangeLogger.create();

    @Override
    public void handle(SingleAccountRefContext context) {
        this.insertBalData(context);
        this.updateBalData(context);
        List<AbstractBalData> deleteBalDatas = context.getAcctSumBalCtx().getDeleteBalDatas();
        this.balLogger.recordBalTransData(context, T_GL_ACCTBALANCE, deleteBalDatas, ChangeType.delete, new long[0]);
        this.deleteBalData(deleteBalDatas, T_GL_ACCTBALANCE);
    }

    protected void updateBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        List<AbstractBalData> updateBalDatas = context.getAcctSumBalCtx().getUpdateBalDatas();
        this.balLogger.recordBalTransData(context, T_GL_ACCTBALANCE, updateBalDatas, ChangeType.updateBal, new long[0]);
        for (AbstractBalData updateBalData : updateBalDatas) {
            BalData balData = (BalData)updateBalData;
            Object[] updateParam = new Object[]{balData.getBeginFor(), balData.getBeginLocal(), balData.getBeginQty(), balData.getYearDebitFor(), balData.getYearDebitLocal(), balData.getYearDebitQty(), balData.getYearCreditFor(), balData.getYearCreditLocal(), balData.getYearCreditQty(), balData.getEndFor(), balData.getEndLocal(), balData.getEndQty(), new Date(), balData.getId()};
            updateParams.add(updateParam);
            if (updateParams.size() < 5000) continue;
            this.patchExecute(UPDATE_BAL_SQL, updateParams);
            updateParams.clear();
        }
        if (!updateParams.isEmpty()) {
            this.patchExecute(UPDATE_BAL_SQL, updateParams);
        }
    }

    private void insertBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(1024);
        List<AbstractBalData> newBalDatas = context.getAcctSumBalCtx().getInsertBalDatas();
        long[] pkIds = DB.genLongIds((String)T_GL_ACCTBALANCE, (int)newBalDatas.size());
        this.balLogger.recordBalTransData(context, T_GL_ACCTBALANCE, newBalDatas, ChangeType.insert, pkIds);
        int pkIdx = 0;
        Long orgId = context.getOrgId();
        Long bookTypeId = context.getBookTypeId();
        Long acctTblId = context.getAcctTblRef().getNewAccountTableId();
        Long periodId = context.getPeriodId();
        for (AbstractBalData newBalData : newBalDatas) {
            BalData balData = (BalData)newBalData;
            Object[] insertParam = new Object[]{pkIds[pkIdx], orgId, bookTypeId, periodId, balData.getEndPeriodId(), acctTblId, balData.getAcctMasterId(), balData.getCurrencyId(), balData.getMeasureUnitId(), balData.getBeginFor(), balData.getBeginLocal(), balData.getBeginQty(), balData.getYearDebitFor(), balData.getYearDebitLocal(), balData.getYearDebitQty(), balData.getYearCreditFor(), balData.getYearCreditLocal(), balData.getYearCreditQty(), balData.getEndFor(), balData.getEndLocal(), balData.getEndQty(), new Date()};
            insertParams.add(insertParam);
            ++pkIdx;
            if (insertParams.size() < 5000) continue;
            this.patchExecute(INSERT_BAL_SQL, insertParams);
            insertParams.clear();
        }
        if (!insertParams.isEmpty()) {
            this.patchExecute(INSERT_BAL_SQL, insertParams);
        }
    }
}

