/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AcctSumBalContext;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public class UpdateNoRefFutureBalHandler
extends AbstractBalDataHandler {
    @Override
    public void handle(SingleAccountRefContext context) {
        this.dealDetailBal(context);
        this.dealAcctSumBal(context);
    }

    private void dealAcctSumBal(SingleAccountRefContext context) {
        AcctSumBalContext acctSumBalCtx = context.getAcctSumBalCtx();
        Map<String, List<AbstractBalData>> existNewAcctDatas = acctSumBalCtx.getExistNewAcctBalDatas();
        Set<String> existRefBalKeys = acctSumBalCtx.getExistsFutureBalKeys();
        for (Map.Entry<String, List<AbstractBalData>> entry : existNewAcctDatas.entrySet()) {
            String balKey = entry.getKey();
            if (existRefBalKeys.contains(balKey)) continue;
            List<AbstractBalData> existBalDatas = entry.getValue();
            if (existBalDatas.size() == 1) {
                BalData existBalData = (BalData)existBalDatas.get(0);
                if (existBalData.getCount() == 0 && this.isBalZero(existBalData)) {
                    context.addDeleteBalData(existBalData);
                    continue;
                }
                this.addUpdateBalDatas(context, existBalDatas);
                continue;
            }
            this.addUpdateBalDatas(context, existBalDatas);
        }
    }

    private void dealDetailBal(SingleAccountRefContext context) {
        Map<String, List<AbstractBalData>> existNewAcctDatas = context.getAllExistNewAcctBalDatas();
        Set<String> existRefBalKeys = context.getExistsFutureBalKeys();
        for (Map.Entry<String, List<AbstractBalData>> entry : existNewAcctDatas.entrySet()) {
            String balKey = entry.getKey();
            if (existRefBalKeys.contains(balKey)) continue;
            List<AbstractBalData> existBalDatas = entry.getValue();
            if (existBalDatas.size() == 1) {
                BalData existBalData = (BalData)existBalDatas.get(0);
                if (existBalData.getCount() == 0 && this.isBalZero(existBalData)) {
                    context.addDeleteBalData(existBalData);
                    continue;
                }
                this.addUpdateBalDatas(context, existBalDatas);
                continue;
            }
            this.addUpdateBalDatas(context, existBalDatas);
        }
    }

    protected void addUpdateBalDatas(SingleAccountRefContext context, List<AbstractBalData> existBalDatas) {
        List<AbstractBalData> updateBalDatas = this.updateNoRefFutureBalDatas(existBalDatas);
        for (AbstractBalData updateBalData : updateBalDatas) {
            context.addUpdateBalData(updateBalData);
        }
    }

    protected boolean isBalZero(BalData balData) {
        return balData.getCreditFor().compareTo(BigDecimal.ZERO) == 0 && balData.getCreditLocal().compareTo(BigDecimal.ZERO) == 0 && balData.getCreditQty().compareTo(BigDecimal.ZERO) == 0 && balData.getDebitFor().compareTo(BigDecimal.ZERO) == 0 && balData.getDebitLocal().compareTo(BigDecimal.ZERO) == 0 && balData.getDebitQty().compareTo(BigDecimal.ZERO) == 0;
    }

    protected List<AbstractBalData> updateNoRefFutureBalDatas(List<AbstractBalData> updateBalDatas) {
        BigDecimal prePeriodEndAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodEndAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodEndQty = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodYearDebitQty = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditAmtFor = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditAmtLocal = BigDecimal.ZERO;
        BigDecimal prePeriodYearCreditQty = BigDecimal.ZERO;
        int prePeriodYear = 0;
        for (int i = 0; i < updateBalDatas.size(); ++i) {
            BalData updateBalData = (BalData)updateBalDatas.get(i);
            if (i == 0) {
                updateBalData.setBeginFor(prePeriodEndAmtFor);
                updateBalData.setBeginLocal(prePeriodEndAmtLocal);
                updateBalData.setBeginQty(prePeriodEndQty);
                prePeriodYearDebitAmtFor = updateBalData.getDebitFor();
                prePeriodYearDebitAmtLocal = updateBalData.getDebitLocal();
                prePeriodYearDebitQty = updateBalData.getDebitQty();
                updateBalData.setYearDebitFor(prePeriodYearDebitAmtFor);
                updateBalData.setYearDebitLocal(prePeriodYearDebitAmtLocal);
                updateBalData.setYearDebitQty(prePeriodYearDebitQty);
                prePeriodYearCreditAmtFor = updateBalData.getCreditFor();
                prePeriodYearCreditAmtLocal = updateBalData.getCreditLocal();
                prePeriodYearCreditQty = updateBalData.getCreditQty();
                updateBalData.setYearCreditFor(prePeriodYearCreditAmtFor);
                updateBalData.setYearCreditLocal(prePeriodYearCreditAmtLocal);
                updateBalData.setYearCreditQty(prePeriodYearCreditQty);
            } else {
                updateBalData.setBeginFor(prePeriodEndAmtFor);
                updateBalData.setBeginLocal(prePeriodEndAmtLocal);
                updateBalData.setBeginQty(prePeriodEndQty);
                if (updateBalData.getPeriodYear() == prePeriodYear) {
                    prePeriodYearDebitAmtFor = prePeriodYearDebitAmtFor.add(updateBalData.getDebitFor());
                    prePeriodYearDebitAmtLocal = prePeriodYearDebitAmtLocal.add(updateBalData.getDebitLocal());
                    prePeriodYearDebitQty = prePeriodYearDebitQty.add(updateBalData.getDebitQty());
                    updateBalData.setYearDebitFor(prePeriodYearDebitAmtFor);
                    updateBalData.setYearDebitLocal(prePeriodYearDebitAmtLocal);
                    updateBalData.setYearDebitQty(prePeriodYearDebitQty);
                    prePeriodYearCreditAmtFor = prePeriodYearCreditAmtFor.add(updateBalData.getCreditFor());
                    prePeriodYearCreditAmtLocal = prePeriodYearCreditAmtLocal.add(updateBalData.getCreditLocal());
                    prePeriodYearCreditQty = prePeriodYearCreditQty.add(updateBalData.getCreditQty());
                    updateBalData.setYearCreditFor(prePeriodYearCreditAmtFor);
                    updateBalData.setYearCreditLocal(prePeriodYearCreditAmtLocal);
                    updateBalData.setYearCreditQty(prePeriodYearCreditQty);
                } else {
                    prePeriodYearDebitAmtFor = updateBalData.getDebitFor();
                    prePeriodYearDebitAmtLocal = updateBalData.getDebitLocal();
                    prePeriodYearDebitQty = updateBalData.getDebitQty();
                    prePeriodYearCreditAmtFor = updateBalData.getCreditFor();
                    prePeriodYearCreditAmtLocal = updateBalData.getCreditLocal();
                    prePeriodYearCreditQty = updateBalData.getCreditQty();
                }
            }
            prePeriodYear = updateBalData.getPeriodYear();
            prePeriodEndAmtFor = updateBalData.getBeginFor().add(updateBalData.getDebitFor()).subtract(updateBalData.getCreditFor());
            prePeriodEndAmtLocal = updateBalData.getBeginLocal().add(updateBalData.getDebitLocal()).subtract(updateBalData.getCreditLocal());
            prePeriodEndQty = updateBalData.getBeginQty().add(updateBalData.getDebitQty()).subtract(updateBalData.getCreditQty());
            updateBalData.setEndFor(prePeriodEndAmtFor);
            updateBalData.setEndLocal(prePeriodEndAmtLocal);
            updateBalData.setEndQty(prePeriodEndQty);
        }
        return updateBalDatas;
    }
}

