/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler.untrans;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public class RestoreFutureVoucherUpdateHandler
extends AbstractBalDataHandler {
    private static final String UpdateVoucherParam = "accversionupdatevoucher";
    private static Log logger = LogFactory.getLog(RestoreFutureVoucherUpdateHandler.class);
    private static int sqlBatchSize = 2000;

    @Override
    public void handle(SingleAccountRefContext context) {
        block35: {
            boolean accversionupdatevoucher = this.getBooleanParam(UpdateVoucherParam, context.getOrgId(), false);
            if (!accversionupdatevoucher) {
                return;
            }
            AccountTableRef acctTblRef = context.getAcctTblRef();
            if (acctTblRef.getNewAccountTableId() == acctTblRef.getOldAccountTableId()) {
                try (TXHandle handle = TX.required((String)"kd.fi.gl.accountref.handler.untrans.RestoreFutureVoucherUpdateHandler");){
                    try {
                        Set newAccountIdSet = context.getAcctTblRef().getNewAccountIdSet();
                        int i = 0;
                        HashSet<Long> tmpIdSet = new HashSet<Long>(sqlBatchSize);
                        int size = newAccountIdSet.size();
                        ArrayList<Object[]> params = new ArrayList<Object[]>(sqlBatchSize);
                        for (Long nid : newAccountIdSet) {
                            List realOldIds;
                            ++i;
                            tmpIdSet.add(nid);
                            Set oldIds = context.getAcctTblRef().getOldAccountIds(nid);
                            Long oldId = oldIds.toArray(new Long[0])[0];
                            if (oldIds.size() > 1 && (realOldIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)context.getAccountCache().getNewAccountDetails(nid).getMasterId()), new QFilter("id", "in", (Object)oldIds)}, null, (int)1)) != null && realOldIds.size() > 0) {
                                oldId = (Long)realOldIds.get(0);
                            }
                            params.add(new Object[]{oldId, context.getDate(), context.getOrgId(), nid});
                            if (i % sqlBatchSize != 0 && i != size) continue;
                            StringJoiner newStr = new StringJoiner(",");
                            for (Long newAcctId : tmpIdSet) {
                                newStr.add(newAcctId.toString());
                            }
                            String accstr = newStr.toString();
                            this.accountVsDb(context, params, accstr);
                            params.clear();
                        }
                        logger.info("\u5220\u9664\u79d1\u76ee\u7248\u672c\u5316\u8bb0\u5f55\u6062\u590d\u51ed\u8bc1\u5206\u5f55\u6570\u636e\u6210\u529f");
                        break block35;
                    }
                    catch (Exception e) {
                        logger.info(this.printError(e));
                        handle.markRollback();
                        throw e;
                    }
                }
            }
            try (TXHandle handle = TX.required((String)"kd.fi.gl.accountref.handler.untrans.RestoreFutureVoucherUpdateHandler");){
                try {
                    Set<Long> oldAccountIdSet = context.getOldAccountIds();
                    int i = 0;
                    HashSet<Long> tmpIdSet = new HashSet<Long>(sqlBatchSize);
                    int size = oldAccountIdSet.size();
                    for (Long oid : oldAccountIdSet) {
                        tmpIdSet.add(oid);
                        if (++i % sqlBatchSize != 0 && i != size) continue;
                        StringJoiner oldStr = new StringJoiner(",");
                        for (Long oldAcctId : tmpIdSet) {
                            oldStr.add(oldAcctId.toString());
                        }
                        String accstr = oldStr.toString();
                        this.accountTbVsDb(context, accstr);
                        tmpIdSet.clear();
                    }
                    logger.info("\u53cd\u542f\u7528\u6062\u590d\u51ed\u8bc1\u5206\u5f55\u6570\u636e\u6210\u529f");
                }
                catch (Exception e) {
                    logger.info(this.printError(e));
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }

    private void accountTbVsDb(SingleAccountRefContext context, String accstr) {
        DB.update((DBRoute)DBRoute.of((String)"gl"), (String)("update t_gl_voucherentry set faccountid=(select freaccountid from t_gl_voucheracctversion where fvoucherentryid = t_gl_voucherentry.fentryid ),fassgrpid=(select fbefasstvalue from t_gl_voucheracctversion where fvoucherentryid = t_gl_voucherentry.fentryid ) where t_gl_voucherentry.fentryid in ( select fvoucherentryid from t_gl_voucheracctversion where fversiondate= ? and forgid=? and freaccountid in (" + accstr + ") ) "), (Object[])new Object[]{context.getDate(), context.getOrgId()});
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_gl_voucheracctversion where fversiondate= ? and forgid=? and freaccountid in (" + accstr + ") "), (Object[])new Object[]{context.getDate(), context.getOrgId()});
    }

    private void accountVsDb(SingleAccountRefContext context, List<Object[]> params, String accstr) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set faccountid=?,fassgrpid=(select fbefasstvalue from t_gl_voucheracctversion where fvoucherentryid = t_gl_voucherentry.fentryid ) where t_gl_voucherentry.fentryid in ( select fvoucherentryid from t_gl_voucheracctversion where fversiondate= ? and forgid=? and fafaccountid =? ) ", params);
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_gl_voucheracctversion where fversiondate= ? and forgid=? and fafaccountid in (" + accstr + ") "), (Object[])new Object[]{context.getDate(), context.getOrgId()});
    }

    public boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        Boolean result = defVal;
        if (null != params) {
            result = Boolean.parseBoolean(params.toString());
        }
        return result;
    }

    protected String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(this.printError(t.getCause())).append('\n');
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW).toString();
    }
}

