/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler.untrans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.AcccurrentData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.SaveAcccurrentDataHandler;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;

public class UntransAcccurrentSaveHandler
extends SaveAcccurrentDataHandler {
    private static final String T_GL_ACCCURRENT = "T_GL_ACCCURRENT";

    @Override
    public void handle(SingleAccountRefContext context) {
        this.deleteBalData(context.getDeleteBalDatas(), T_GL_ACCCURRENT);
        this.updateOldBalData(context);
        this.deleteInitState(context);
    }

    private void deleteInitState(SingleAccountRefContext context) {
        AccountTableRef accountTableRef = context.getAcctTblRef();
        Set<Long> oldAccts = context.getOldAccountIds();
        HashSet<Long> newAccts = new HashSet<Long>(oldAccts.size());
        for (Long oldAcct : oldAccts) {
            newAccts.add(accountTableRef.getNewAccountId(oldAcct));
        }
        Long orgId = context.getOrgId();
        Long bookTypeId = context.getBookTypeId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter accountFilter = new QFilter("account", "in", newAccts);
        DeleteServiceHelper.delete((String)"gl_reci_init_state", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter});
    }

    private void updateOldBalData(SingleAccountRefContext context) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        Collection<AbstractBalData> oldBalDatas = context.getOldBalDatas();
        Date date = TimeServiceHelper.now();
        Date endDate = BalanceTransferUtils.getEndDate();
        for (AbstractBalData oldBalData : oldBalDatas) {
            AcccurrentData balData = (AcccurrentData)oldBalData;
            Object[] updateParam = new Object[]{date, endDate, balData.getId()};
            updateParams.add(updateParam);
            if (updateParams.size() < 5000) continue;
            this.patchExecute("UPDATE T_GL_ACCCURRENT SET FMODIFYTIME=?, FUNEFFECTIVEDATE=? WHERE FID=?", updateParams);
            updateParams.clear();
        }
        if (updateParams.size() > 0) {
            this.patchExecute("UPDATE T_GL_ACCCURRENT SET FMODIFYTIME=?, FUNEFFECTIVEDATE=? WHERE FID=?", updateParams);
        }
    }
}

