/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.transferbal;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public class FutureVoucherUpdateHandler
extends AbstractBalDataHandler {
    private static final String UpdateVoucherParam = "accversionupdatevoucher";
    private static Log logger = LogFactory.getLog(FutureVoucherUpdateHandler.class);
    private static int sqlBatchSize = 2000;

    @Override
    public void handle(SingleAccountRefContext context) {
        boolean accversionupdatevoucher = this.getBooleanParam(UpdateVoucherParam, context.getOrgId(), false);
        if (!accversionupdatevoucher) {
            return;
        }
        try (TXHandle handle = TX.required((String)"kd.bos.ext.fi.accountref.impl.VoucherImpl.enable");){
            try {
                this.enableGLVoucher(context.getOrgId(), context.getBookTypeId(), context.getPeriodId(), context.getDate(), context.getAcctTblRef());
                logger.info("\u542f\u7528\u66f4\u65b0\u672a\u6765\u51ed\u8bc1\u5206\u5f55\u6570\u636e\u6210\u529f");
            }
            catch (Exception e) {
                logger.error(this.printError(e));
                handle.markRollback();
                throw e;
            }
        }
    }

    private void enableGLVoucher(long orgId, long bookTypeId, long periodId, Date enableDate, AccountTableRef accountIdRef) {
        Set oldAcctIds = accountIdRef.getOldAccountIdSet();
        StringJoiner oldStr = new StringJoiner(",");
        for (Long oldAcctId : oldAcctIds) {
            oldStr.add(oldAcctId.toString());
        }
        List<Long> allEntryIdList = this.queryAllEntryIds(orgId, bookTypeId, periodId, enableDate, oldStr);
        HashMap acctFlexFieldMap = new HashMap(accountIdRef.getNewAccountIdSet().size());
        Map accountviewsMap = BusinessDataServiceHelper.loadFromCache((Object[])accountIdRef.getNewAccountIdSet().toArray(), (String)"bd_accountview");
        for (Map.Entry me : accountviewsMap.entrySet()) {
            HashSet<String> flexFields = new HashSet<String>();
            DynamicObjectCollection checkitementry = ((DynamicObject)me.getValue()).getDynamicObjectCollection("checkitementry");
            Iterator iterator = checkitementry.iterator();
            while (iterator.hasNext()) {
                DynamicObject assitem = (DynamicObject)iterator.next();
                DynamicObject asstactitem = (DynamicObject)assitem.get("asstactitem");
                if (asstactitem == null) continue;
                String flexField = asstactitem.getString("flexfield");
                flexFields.add(flexField);
            }
            acctFlexFieldMap.put(((DynamicObject)me.getValue()).getLong("id"), flexFields);
        }
        List batchList = Lists.partition(allEntryIdList, (int)sqlBatchSize);
        CountDownLatch countDownLatch = new CountDownLatch(batchList.size());
        ConcurrentHashMap datas = new ConcurrentHashMap(allEntryIdList.size());
        for (List entryIdListOne : batchList) {
            ThreadService.execute(() -> {
                try {
                    StringJoiner entryIdStr = new StringJoiner(",");
                    for (Long entryId : entryIdListOne) {
                        entryIdStr.add(entryId.toString());
                    }
                    List<VoucherEntryData> entryList = this.getEntryList(datas, entryIdListOne, entryIdStr);
                    ArrayList<FlexEntireData> flexEntireDataList = new ArrayList<FlexEntireData>(16);
                    HashMap<String, String> assgrpIdToConcatStr = new HashMap<String, String>(16);
                    for (VoucherEntryData entryData : entryList) {
                        Long newAccountId = accountIdRef.getNewAccountId(Long.valueOf(entryData.getAccountId()));
                        entryData.setNewAccountId(newAccountId);
                        Set flexFields = (Set)acctFlexFieldMap.get(newAccountId);
                        if (entryData.getAssgrpId() == 0L) continue;
                        String value = entryData.getAssValue();
                        long oriFlexId = entryData.getAssgrpId();
                        Map flexValue = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                        Iterator flexValueIter = flexValue.entrySet().iterator();
                        boolean needRebuild = false;
                        while (flexValueIter.hasNext()) {
                            Map.Entry et = flexValueIter.next();
                            String flexField = (String)et.getKey();
                            if (flexFields.contains(flexField)) continue;
                            needRebuild = true;
                            flexValueIter.remove();
                        }
                        Set<String> flexFieldsCopy = flexFields.stream().collect(Collectors.toSet());
                        flexFieldsCopy.removeAll(flexValue.keySet());
                        if (flexFieldsCopy.size() > 0) {
                            needRebuild = true;
                            DynamicObject newAccount = (DynamicObject)accountviewsMap.get(newAccountId);
                            flexFieldsCopy.forEach(fc -> {
                                DynamicObjectCollection checkitementry = newAccount.getDynamicObjectCollection("checkitementry");
                                Object defaultValue = null;
                                for (DynamicObject assitem : checkitementry) {
                                    String valuetype;
                                    String flexField;
                                    DynamicObject asstactitem = (DynamicObject)assitem.get("asstactitem");
                                    if (asstactitem == null || !fc.equalsIgnoreCase(flexField = asstactitem.getString("flexfield"))) continue;
                                    defaultValue = assitem.getString("defaulid");
                                    if (!StringUtils.isNotEmpty((String)defaultValue) || !"1".equalsIgnoreCase(valuetype = asstactitem.getString("valuetype"))) break;
                                    try {
                                        defaultValue = Long.parseLong((String)defaultValue);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    break;
                                }
                                flexValue.put(fc, defaultValue);
                            });
                        }
                        if (!needRebuild) continue;
                        String assgrpKey = newAccountId + "-" + oriFlexId;
                        FlexEntireData flexEntireData = FutureVoucherUpdateHandler.buildFlexEntireData(flexValue);
                        String concatData = flexEntireData.concatFlexData();
                        assgrpIdToConcatStr.put(assgrpKey, concatData);
                        flexEntireDataList.add(flexEntireData);
                    }
                    Map<String, Long> flexSaveResult = FutureVoucherUpdateHandler.saveNewAssgrpVal(flexEntireDataList);
                    for (VoucherEntryData entryData : entryList) {
                        if (entryData.getAssgrpId() == 0L) continue;
                        long oriFlexId = entryData.getAssgrpId();
                        String assgrpKey = entryData.getNewAccountId() + "-" + oriFlexId;
                        String concatStr = (String)assgrpIdToConcatStr.get(assgrpKey);
                        if (concatStr == null) continue;
                        Long rebuildAssgrpId = flexSaveResult.get(concatStr);
                        if (rebuildAssgrpId != null) {
                            entryData.setNewAssgrpId(rebuildAssgrpId);
                            continue;
                        }
                        entryData.setNewAssgrpId(entryData.getAssgrpId());
                    }
                }
                catch (Exception e) {
                    logger.error(this.printError(e));
                    throw e;
                }
                finally {
                    countDownLatch.countDown();
                }
            }, (TaskType)TaskType.GL_FUTURE_VCH_BATCH_UPDATE);
        }
        try {
            countDownLatch.await();
            ORM orm = ORM.create();
            long userid = Long.parseLong(RequestContext.get().getUserId());
            Date createDate = new Date();
            long[] avids = orm.genLongIds("gl_voucher_acctversion", datas.size());
            int i = 0;
            ArrayList allEntries = new ArrayList(datas.values());
            datas.clear();
            ArrayList allEntryTasks = new ArrayList(8);
            allEntryTasks.addAll(Lists.partition(allEntries, (int)sqlBatchSize));
            allEntries = null;
            Iterator allIt = allEntryTasks.iterator();
            while (allIt.hasNext()) {
                List entries = (List)allIt.next();
                ArrayList<Object[]> voucherEntryParams = new ArrayList<Object[]>(entries.size());
                ArrayList<Object[]> voucherEntryBakParams = new ArrayList<Object[]>(entries.size());
                for (VoucherEntryData edata : entries) {
                    voucherEntryParams.add(new Object[]{edata.getNewAccountId(), edata.getNewAssgrpId(), edata.getEntryId()});
                    voucherEntryBakParams.add(new Object[]{avids[i++], edata.getId(), edata.getEntryId(), orgId, enableDate, edata.getAccountId(), edata.getNewAccountId(), userid, createDate, edata.getAssgrpId()});
                }
                this.dbUpdate(voucherEntryParams, voucherEntryBakParams);
                allIt.remove();
            }
        }
        catch (InterruptedException e) {
            logger.error(this.printError(e));
        }
    }

    private void dbUpdate(List<Object[]> voucherEntryParams, List<Object[]> voucherEntryBakParams) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set faccountid= ? , fassgrpid= ? where fentryid = ?;", voucherEntryParams);
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_gl_voucheracctversion(fid,fvoucherid,fvoucherentryid,forgid,fversiondate,freaccountid,fafaccountid,fcreatorid,fcreatedate,fbefasstvalue) values(?,?,?,?,?,?,?,?,?,?);", voucherEntryBakParams);
    }

    private List<VoucherEntryData> getEntryList(Map<Long, VoucherEntryData> datas, List<Long> entryIdListOne, StringJoiner entryIdStr) {
        List entryList = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select e.fid as fid, e.fentryid as fentryid, e.faccountid as faccountid, e.fassgrpid as fassgrpid,a.fvalue as fvalue from t_gl_voucherentry as e left join t_gl_assist as a on e.fassgrpid = a.fid where e.fentryid in (" + entryIdStr + ")"), r -> {
            ArrayList<VoucherEntryData> vedatalist = new ArrayList<VoucherEntryData>(entryIdListOne.size());
            while (r.next()) {
                VoucherEntryData voucherEntryData = new VoucherEntryData(r.getLong("fid"), r.getLong("fentryid"), r.getLong("faccountid"), r.getLong("fassgrpid"), r.getString("fvalue"));
                vedatalist.add(voucherEntryData);
                datas.put(voucherEntryData.getEntryId(), voucherEntryData);
            }
            return vedatalist;
        });
        return entryList;
    }

    private List<Long> queryAllEntryIds(long orgId, long bookTypeId, long periodId, Date enableDate, StringJoiner oldStr) {
        ArrayList<Long> allEntryIdList = new ArrayList<Long>(128);
        List entryIdList = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select e.fentryid as fentryid from t_gl_voucherentry as e inner join t_gl_voucher v on e.fid=v.fid where v.forgid = ? and v.fbooktypeid = ? and v.fperiodid >= ? and e.faccountid in (" + oldStr + ")"), (Object[])new Object[]{orgId, bookTypeId, periodId}, r -> {
            ArrayList<Long> ids = new ArrayList<Long>(128);
            while (r.next()) {
                ids.add(r.getLong("fentryid"));
            }
            return ids;
        });
        allEntryIdList.addAll(entryIdList);
        return allEntryIdList;
    }

    protected static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldValueMap) {
        FlexEntireData flexEntireData = new FlexEntireData();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData flexEntireData2 = flexEntireData;
            flexEntireData2.getClass();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData2, flexField, value);
            if (value instanceof Long) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        return flexEntireData;
    }

    protected static Map<String, Long> saveNewAssgrpVal(List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        HashMap<String, Long> valAndIdMap = new HashMap<String, Long>(flexEntireDatas.size());
        FlexService.batchSaveFlexData((MainEntityType)mainEntity, flexEntireDatas);
        for (FlexEntireData flexEntireData : flexEntireDatas) {
            valAndIdMap.put(flexEntireData.concatFlexData(), flexEntireData.getId());
        }
        return valAndIdMap;
    }

    protected String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(this.printError(t.getCause())).append('\n');
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW).toString();
    }

    public boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        Boolean result = defVal;
        if (null != params) {
            result = Boolean.parseBoolean(params.toString());
        }
        return result;
    }

    private static class VoucherEntryData {
        private long id;
        private long entryId;
        private long accountId;
        private long assgrpId;
        private long newAccountId;
        private long newAssgrpId;
        private String assValue;

        public VoucherEntryData(long id, long entryId, long accountId, long assgrpId, String assValue) {
            this.id = id;
            this.entryId = entryId;
            this.accountId = accountId;
            this.assgrpId = assgrpId;
            this.assValue = assValue;
        }

        public long getId() {
            return this.id;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getAssgrpId() {
            return this.assgrpId;
        }

        public long getNewAccountId() {
            return this.newAccountId;
        }

        public void setNewAccountId(long newAccountId) {
            this.newAccountId = newAccountId;
        }

        public long getNewAssgrpId() {
            return this.newAssgrpId;
        }

        public void setNewAssgrpId(long newAssgrpId) {
            this.newAssgrpId = newAssgrpId;
        }

        public String getAssValue() {
            return this.assValue;
        }
    }
}

