/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accsys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BdBusinessDataServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class AccSysUtil {
    private AccSysUtil() {
    }

    public static long getCurPeriodAccountTableId(long orgId, long bookTypeId, long periodId) {
        return AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
    }

    public static long getCurDateAccountTableId(long orgId, long bookTypeId, Date date) {
        return AccountRefUtils.getCurDateAccountTableId((long)orgId, (long)bookTypeId, (Date)date);
    }

    public static void clearAccountBookVersionsFromCache(long orgId, long bookTypeId) {
        CacheKey cacheKey = CacheKey.getCacheKey(CacheKeyPrefix.ACCOUNT_BOOK_VERSION, orgId, bookTypeId);
        LocalCacheHelper.remove(cacheKey);
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.bookVersion);
        cache.remove(cacheKey.toString());
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(org, bookType);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookFromAccSys(long orgView, long org, long bookType) {
        if (orgView == 0L) {
            return AccSysUtil.getBookFromAccSys(org, bookType);
        }
        long acctSys = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"accountingsys", (QFilter[])new QFilter("id", "=", (Object)orgView).toArray()).getLong("accountingsys");
        QFilter acctSysF = new QFilter("accountingsys", "=", (Object)acctSys);
        QFilter orgF = new QFilter("org", "=", (Object)org);
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"gl_accountbook", (QFilter[])new QFilter[]{acctSysF, orgF, bookTypeF}, null, (int)-1);
        return CollectionUtils.isNotEmpty((Collection)pks) ? new AccountBookInfo((Long)pks.get(0)) : null;
    }

    public static AccountBookInfo getBookFromAccSys(String orgNumber, String bookTypeNumber) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(orgNumber, bookTypeNumber), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(orgNumber, bookTypeNumber);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static List<AccountBookInfo> getBookFromAccSys(Set<Long> orgSet, long bookType) {
        ArrayList<AccountBookInfo> result = new ArrayList<AccountBookInfo>();
        String selectFields = "id,org,bookstype,bookstype.number,basecurrency,periodtype,startperiod,curperiod,exratetable,accounttable,cashinitperiod,isendinit,enable,isbizunit,accountingsys,yearprofitacct,isbudget";
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
        try (DataSet ds = BatchProcessUtil.batchQueryDataSet(orgSet, batchData -> {
            QFilter orgF = new QFilter("org", "in", batchData);
            return QueryServiceHelper.queryDataSet((String)"AccsysUtil.getAccountbooks", (String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{orgF, bookTypeF}, null);
        });){
            for (Row row : ds) {
                AccountBookInfo book = new AccountBookInfo();
                book.setId(row.getLong("id"));
                book.setOrg(row.getLong("org"));
                book.setBookstype(row.getLong("bookstype"));
                book.setBookstypeNum(row.getString("bookstype.number"));
                book.setAccounttable(row.getLong("accounttable"));
                book.setBasecurrency(row.getLong("basecurrency"));
                book.setPeriodtype(row.getLong("periodtype"));
                book.setStartperiod(row.getLong("startperiod"));
                book.setCurPeriodId(row.getLong("curperiod"));
                book.setExratetable(row.getLong("exratetable"));
                book.setCashinitperiod(row.getLong("cashinitperiod"));
                book.setAccountingsys(row.getLong("accountingsys"));
                book.setIsbizunit(row.getBoolean("isbizunit"));
                book.setIsendinit(row.getBoolean("isendinit"));
                book.setEnable(row.getString("enable"));
                book.setYearprofitacct(row.getLong("yearprofitacct"));
                book.setIsBudget(row.getBoolean("isbudget"));
                result.add(book);
            }
        }
        return result;
    }

    public static AccountBookInfo getDefaultBookFromAccSys(Long orgId) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getDefAccountBookIdKey(orgId), () -> {
            Long bookId = AccSysUtil.getDefBookIdFromCache(orgId);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookByDataPermission(Long orgId) {
        DynamicObjectCollection bookColl;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List<Long> btIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        if (btIds != null) {
            qf.and(new QFilter("bookstype", "in", btIds));
        }
        return (bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)1)) == null || bookColl.isEmpty() ? null : new AccountBookInfo(((DynamicObject)bookColl.get(0)).getLong("id"));
    }

    public static List<Long> getAllBookFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("id"));
            }
            return idList;
        });
    }

    public static List<AccountBookInfo> getAllBookInfoFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,periodtype,bookstype,accounttable,number", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            ArrayList<AccountBookInfo> accList = new ArrayList<AccountBookInfo>();
            for (DynamicObject obj : coll) {
                AccountBookInfo accountBookInfo = new AccountBookInfo();
                accountBookInfo.setId(obj.getLong("id"));
                accountBookInfo.setPeriodtype(obj.getLong("periodtype"));
                accountBookInfo.setBookstype(obj.getLong("bookstype"));
                accountBookInfo.setAccounttable(obj.getLong("accounttable"));
                accountBookInfo.setBookstypeNum(obj.getString("number"));
                accList.add(accountBookInfo);
            }
            return accList;
        });
    }

    public static List<DynamicObject> getAllBookDynFromAccSys(long orgId, String selectField) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)selectField, (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            return new ArrayList(coll);
        });
    }

    public static Set<Long> getAllBookTypeFromAccSys(long orgId) {
        return (Set)ThreadCache.get((Object)ThreadCacheKey.getAllBookTypeIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject obj : coll) {
                idSet.add(obj.getLong("id"));
            }
            return idSet;
        });
    }

    public static DynamicObject loadSingleBook(Object orgId, Object bookTypeId, String sel) {
        Long bookId = AccSysUtil.getBookIdFromCache((Long)orgId, (Long)bookTypeId);
        return bookId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (String)"gl_accountbook", (String)sel);
    }

    private static Long getBookIdFromCache(long org, long bookType) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(org, bookType), () -> {
            long result;
            String key = org + "-" + bookType;
            DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org", "=", (Object)org);
                QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
                DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book == null) {
                    return null;
                }
                result = book.getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    public static void disabledBookIDCache(long org, long bookType, String orgNumber, String booksType) {
        ThreadCache.remove((Object)ThreadCacheKey.getBookIdKey(org, bookType));
        String distributeKey = org + "-" + bookType;
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
        cache.remove(distributeKey);
        String distributeNumberKey = orgNumber + "-" + booksType;
        cache.remove(distributeNumberKey);
    }

    public static int getAllBookTypeCount() {
        DynamicObjectCollection book = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", null);
        return book == null ? 0 : book.size();
    }

    private static Long getBookIdFromCache(String orgNumber, String bookTypeNumber) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(orgNumber, bookTypeNumber), () -> {
            long result;
            String key = orgNumber + "-" + bookTypeNumber;
            DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org.number", "=", (Object)orgNumber);
                QFilter bookTypeF = new QFilter("bookstype.number", "=", (Object)bookTypeNumber);
                DynamicObjectCollection book = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book.isEmpty()) {
                    return null;
                }
                result = ((DynamicObject)book.get(0)).getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    private static Long getDefBookIdFromCache(Long orgId) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getDefBookIdKey(orgId), () -> {
            QFilter qf = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)1);
            return bookColl == null || bookColl.isEmpty() ? null : Long.valueOf(((DynamicObject)bookColl.get(0)).getLong("id"));
        });
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static List<ComboItem> getAcctOrgComboItem(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> acctOrgPkList = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        List resultList = BatchProcessUtil.batchProcess(acctOrgPkList, batchData -> {
            QFilter orgFilter = new QFilter("org", "in", batchData);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            try (DataSet orgCol = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.GLUtil.initFilter", (String)"gl_accountbook", (String)"org.id orgId,org.number,org.name orgname", (QFilter[])new QFilter[]{orgFilter}, (String)"org.number");){
                String old = null;
                for (Row r : orgCol) {
                    ComboItem c = new ComboItem();
                    String orgPk = r.getString("orgId");
                    if (old == null) {
                        old = orgPk;
                    } else {
                        if (old.equals(orgPk)) continue;
                        old = orgPk;
                    }
                    c.setCaption(new LocaleString(r.getString("orgname")));
                    c.setValue(orgPk);
                    comboItems.add(c);
                }
            }
            return comboItems;
        });
        ArrayList<ComboItem> allComboItems = new ArrayList<ComboItem>(8);
        for (List result : resultList) {
            allComboItems.addAll(result);
        }
        return allComboItems;
    }

    public static List<ComboItem> getBookTypeComboByOrg(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        return AccSysUtil.getBookTypeCombo(orgIds);
    }

    public static List<Long> getBookTypeDataPermission(List<Long> orgIdList) {
        QFilter dataPermissionFilter = orgIdList == null || orgIdList.isEmpty() ? PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype") : PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype", orgIdList);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbookstype", (QFilter[])new QFilter[]{dataPermissionFilter}, (String)"accounttype", (int)-1).stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
    }

    public static List<ComboItem> getBookTypeCombo(List<Long> orgIdList) {
        List<Long> bookTypeIdList = AccSysUtil.getBookTypeDataPermission(orgIdList);
        if (orgIdList == null || orgIdList.isEmpty()) {
            return BusinessDataServiceHelper.loadFromCache((Object[])bookTypeIdList.toArray(new Object[0]), (String)"bd_accountbookstype").values().stream().map(x -> {
                ComboItem item = new ComboItem();
                item.setValue(x.getString("id"));
                item.setCaption(new LocaleString(x.getString("name")));
                return item;
            }).collect(Collectors.toList());
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(orgIdList);
        if (orgIdSet.size() <= 1000) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("bookstype", "in", bookTypeIdList);
            qfBuilder.add("isbizunit", "=", Boolean.TRUE);
            qfBuilder.add("org", "in", orgIdSet);
            try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)AccSysUtil.class.getName(), (String)"gl_accountbook", (String)String.join((CharSequence)",", "bookstype", "bookstype.name"), (QFilter[])qfBuilder.toArray(), (String)"bookstype.accounttype").groupBy(new String[]{"bookstype", "bookstype.name"}).finish();){
                ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(bookTypeIdList.size());
                for (Row row : bookDataSet) {
                    ComboItem item = new ComboItem();
                    item.setValue(row.getString("bookstype"));
                    item.setCaption(new LocaleString(row.getString("bookstype.name")));
                    comboItemList.add(item);
                }
                ArrayList<ComboItem> arrayList = comboItemList;
                return arrayList;
            }
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("bookstype", "in", bookTypeIdList);
        qfBuilder.add("isbizunit", "=", Boolean.TRUE);
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)AccSysUtil.class.getName(), (String)"gl_accountbook", (String)String.join((CharSequence)",", "org", "bookstype", "bookstype.name"), (QFilter[])qfBuilder.toArray(), (String)"bookstype.accounttype");){
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(bookTypeIdList.size());
            HashSet<Long> bookTypeIdSet = new HashSet<Long>(2);
            for (Row row : bookDataSet) {
                Long bookTypeId = row.getLong(1);
                if (!bookTypeIdSet.add(bookTypeId) || !orgIdSet.contains(row.getLong(0))) continue;
                ComboItem item = new ComboItem();
                item.setValue(bookTypeId.toString());
                item.setCaption(new LocaleString(row.getString("bookstype.name")));
                comboItemList.add(item);
            }
            ArrayList<ComboItem> arrayList = comboItemList;
            return arrayList;
        }
    }

    public static List<Long> getBookTypeIdList(List<Long> orgIdList) {
        List<Long> bookTypeIdList = AccSysUtil.getBookTypeDataPermission(orgIdList);
        if (orgIdList == null || orgIdList.isEmpty()) {
            return bookTypeIdList;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("bookstype", "in", bookTypeIdList);
        qfBuilder.add("isbizunit", "=", Boolean.TRUE);
        qfBuilder.add("org", "in", orgIdList);
        return BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"bookstype.id", (QFilter[])qfBuilder.toArray()).values().stream().map(x -> x.getLong("bookstype.id")).collect(Collectors.toList());
    }

    public static List<ComboItem> getAssBookTypeCombo(List<Long> orgs) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(10);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgs);
        QFilter org = new QFilter("org", "in", orgs);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds).and(new QFilter("accounttype", "=", (Object)"2")));
        }
        QFilter[] filter = new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1")};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.accsys.AccSysUtil.getBookTypeCombo", (String)"gl_accountbook", (String)"org,bookstype,bookstype.name btname", (QFilter[])filter, (String)"bookstype.accounttype").groupBy(new String[]{"bookstype", "btname"}).finish();){
            for (Row row : ds) {
                ComboItem item = new ComboItem();
                long bookstype = row.getLong("bookstype");
                String btname = row.getString("btname");
                item.setCaption(new LocaleString(btname));
                item.setValue(String.valueOf(bookstype));
                result.add(item);
            }
        }
        return result;
    }

    public static List<Long> getAllBookTypeByOrg(long orgId) {
        DataSet bookTypeSet;
        ArrayList<Long> bookTypeList = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter org = new QFilter("org", "=", (Object)orgId);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds));
        }
        if ((bookTypeSet = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getAllBookTypeByOrg", (String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")}, (String)"bookstype.accounttype")) != null) {
            for (Row row : bookTypeSet) {
                bookTypeList.add(row.getLong("bookstype"));
            }
        }
        return bookTypeList;
    }

    public static List<Long> getBookTypeByOrg(long orgId) {
        DataSet bookTypeSet;
        ArrayList<Long> bookTypeList = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter org = new QFilter("org", "=", (Object)orgId);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds));
        }
        if ((bookTypeSet = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getAllBookTypeByOrg", (String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1")}, (String)"bookstype.accounttype")) != null) {
            for (Row row : bookTypeSet) {
                bookTypeList.add(row.getLong("bookstype"));
            }
        }
        return bookTypeList;
    }

    public static QFilter getAccountingOrgFilter(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        return new QFilter("id", "in", orgIds);
    }

    @Deprecated
    public static QFilter getAcctOrgFilter(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        return new QFilter("id", "in", orgIds);
    }

    public static boolean checkDateAccountable(long orgID, long bookTypeID, Date date) {
        AccountBookInfo book = Optional.ofNullable(AccSysUtil.getBookFromAccSys(orgID, bookTypeID)).orElseThrow(() -> new KDBizException(String.format("none book found on book type %s with org %s", orgID, bookTypeID)));
        long curPeriod = book.getCurPeriodId();
        Date beginDate = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriod, (String)"bd_period").getDate("begindate");
        if (beginDate.compareTo(date) <= 0) {
            return true;
        }
        ArrayList periods = new ArrayList();
        QFBuilder qfBuilder = new QFBuilder().add("org", "=", orgID).add("booktype", "=", bookTypeID);
        QueryServiceHelper.query((String)"gl_openedperiod", (String)"period", (QFilter[])qfBuilder.toArray()).stream().mapToLong(dyo -> dyo.getLong("period")).forEach(periods::add);
        return BdBusinessDataServiceHelper.loadFromCache((Object[])periods.toArray(), (String)String.join((CharSequence)",", "begindate", "enddate"), (String)"bd_period").values().stream().anyMatch(periodDyo -> periodDyo.getDate("begindate").compareTo(date) <= 0 && periodDyo.getDate("enddate").compareTo(date) >= 0);
    }

    public static long getAccountingOrg(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        long orgId = 0L;
        if (!orgIds.isEmpty()) {
            Long curLoginOrg = RequestContext.get().getOrgId();
            orgId = orgIds.contains(curLoginOrg) ? curLoginOrg.longValue() : orgIds.get(0).longValue();
        }
        return orgId;
    }

    public static List<Long> getAcctOrgPkList(String entityId, boolean isIncludeUnit, PermissonType permType) {
        return new ArrayList<Long>(AccSysUtil.getAcctOrgPkList2(entityId, isIncludeUnit, permType));
    }

    public static Set<Long> getAcctOrgPkList2(String entityId, boolean isIncludeUnit, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = isIncludeUnit ? AccSysUtil.getViewOrgMap() : AccSysUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        HashSet permOrgs = new HashSet();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs.addAll(permOrgRs.getHasPermOrgs());
            orgSet.retainAll(permOrgs);
        }
        HashSet permChildOrg = new HashSet(orgSet);
        if (isIncludeUnit) {
            Map<Long, Set> filteredViewOrgMap = viewOrgMap.entrySet().stream().filter(x -> {
                Set value = (Set)x.getValue();
                value.retainAll(permChildOrg);
                return !value.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(filteredViewOrgMap.keySet());
            LinkedHashSet parentOrgs = new LinkedHashSet();
            for (Map.Entry<Long, Set> entry : filteredViewOrgMap.entrySet()) {
                List<Object> rs = new LinkedList();
                Set orgs = entry.getValue();
                orgs.retainAll(orgSet);
                if (!orgs.isEmpty()) {
                    try (DataSet orgDataSet = orgStructureByViews.copy().filter("view = " + entry.getKey());){
                        rs = AccSysUtil.getParentOrgId(orgDataSet, orgs, false);
                    }
                }
                parentOrgs.addAll(rs);
            }
            if (!permOrgRs.hasAllOrgPerm()) {
                parentOrgs.retainAll(permOrgs);
            }
            parentOrgs.addAll(orgSet);
            orgSet = parentOrgs;
        }
        return orgSet;
    }

    public static HasPermOrgResult getAllPermOrgs(String entityId, String permType) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        return PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"10", (String)appId, (String)entityId, (String)permType);
    }

    public static boolean isPerm(String entityId, String permType) {
        HasPermOrgResult hasPermOrg = AccSysUtil.getAllPermOrgs(entityId, permType);
        return hasPermOrg != null && (hasPermOrg.hasAllOrgPerm() || !hasPermOrg.getHasPermOrgs().isEmpty());
    }

    public static boolean isCustomPerm(String entityId, String permId) {
        HasPermOrgResult hasPermOrg = AccSysUtil.getAllPermOrgs(entityId, permId);
        return hasPermOrg != null && hasPermOrg.hasAllOrgPerm();
    }

    public static Long getMainViewByOrgAndBT(Long orgId, Long bookTypeId) {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : mainViewOrgBTMap.entrySet()) {
            Map<Long, List<Long>> orgBTMap = entry.getValue();
            for (Map.Entry<Long, List<Long>> listEntry : orgBTMap.entrySet()) {
                if (!listEntry.getKey().equals(orgId) || !listEntry.getValue().contains(bookTypeId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static Set<Long> getViewByOrg(Long orgId) {
        Set<Long> orgs;
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Map<Long, Set<Long>> statViewOrgMap = AccSysUtil.getStatViewOrgMap();
        LinkedHashSet<Long> viewList = new LinkedHashSet<Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter viewFilter = new QFilter("view", "in", viewOrgMap.keySet());
        DynamicObjectCollection orgStructure = QueryServiceHelper.query((String)"bos_org_structure", (String)"view,view.number number", (QFilter[])new QFilter[]{orgFilter, viewFilter});
        orgStructure.sort((v1, v2) -> {
            String num1 = v1.getString("number");
            if (num1 == null) {
                return -1;
            }
            String num2 = v2.getString("number");
            if (num2 == null) {
                return 1;
            }
            String[] split1 = num1.split(":");
            String[] split2 = num2.split(":");
            String splitNum1 = split1.length > 1 ? split1[1] : split1[0];
            String splitNum2 = split2.length > 1 ? split2[1] : split2[0];
            return splitNum1.compareTo(splitNum2);
        });
        for (DynamicObject dyn : orgStructure) {
            long view = dyn.getLong("view");
            orgs = statViewOrgMap.get(view);
            if (orgs != null && orgs.contains(orgId)) continue;
            viewList.add(view);
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(viewList);
        for (Long view : viewList) {
            orgs = viewOrgMap.get(view);
            List<Object> parentOrgId = new LinkedList();
            try (DataSet orgDataSet = orgStructureByViews.copy().filter("view = " + view);){
                parentOrgId = AccSysUtil.getParentOrgId(orgDataSet, orgs, true);
            }
            if (!parentOrgId.contains(orgId)) continue;
            result.add(view);
        }
        return result;
    }

    private static DataSet getOrgStructureByViews(Collection<Long> views) {
        QFilter mainViewFilter = new QFilter("view", "in", views);
        return QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent,view", (QFilter[])new QFilter[]{mainViewFilter}, null);
    }

    protected static Map<Long, Set<Long>> getViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    public static Map<Long, Map<Long, List<Long>>> getViewOrgBTMap() {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        Map<Long, Map<Long, List<Long>>> statViewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        mainViewOrgBTMap.putAll(statViewOrgBTMap);
        return mainViewOrgBTMap;
    }

    public static Set<Long> getChildOrgsByViewWithTCache(Long org, Long view, String formId) {
        return (Set)ThreadCache.get((Object)String.format("%s-%s-%s", org, view, formId), () -> AccSysUtil.getChildOrgsByView(org, view, formId), (boolean)true);
    }

    public static Set<Long> getChildOrgsByView(Long org, Long view, String formId) {
        HashSet<Long> parent = new HashSet<Long>();
        parent.add(org);
        Set<Long> childOrgList = AccSysUtil.getChildOrgId("10", view, parent, true);
        HashSet<Long> orgViewSet = new HashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Set<Long> orgSet = viewOrgMap.get(view);
        if (orgSet != null) {
            orgViewSet.addAll(orgSet);
        }
        Set<Long> permOrgList = AccSysUtil.getAcctOrgPkList2(formId, false, PermissonType.VIEW);
        childOrgList.retainAll(orgViewSet);
        childOrgList.retainAll(permOrgList);
        return childOrgList;
    }

    public static Set<Long> getChildOrgId(String ovType, Long iOrgViewId, Set<Long> parentList, boolean includeParentSelf) {
        HashSet<Long> result = new HashSet<Long>();
        if (parentList == null || parentList.isEmpty()) {
            return result;
        }
        if (includeParentSelf) {
            result.addAll(parentList);
        }
        QFilter mainViewFilter = new QFilter("view", "=", (Object)iOrgViewId);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{mainViewFilter}, null);){
            AccSysUtil.getChildOrgIdHelper(parentList, result, orgDataSet);
        }
        return result;
    }

    private static void getChildOrgIdHelper(Set<Long> parentList, Set<Long> result, DataSet orgDataSet) {
        HashSet<Long> childOrgId = new HashSet<Long>();
        String parentStr = parentList.toString().replace("[", "(").replace("]", ")");
        try (DataSet childOrgSet = orgDataSet.copy().filter("parent in " + parentStr);){
            for (Row row : childOrgSet) {
                Long org = row.getLong("org");
                if (org == null || org == 0L) continue;
                childOrgId.add(org);
            }
            if (!childOrgId.isEmpty()) {
                result.addAll(childOrgId);
                AccSysUtil.getChildOrgIdHelper(childOrgId, result, orgDataSet);
            }
        }
    }

    protected static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Set<Long>> getStatViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getMainViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(true);
    }

    private static Map<Long, Map<Long, List<Long>>> getStatViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(false);
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        String str = cache.get(isMainView ? CacheKey.ACCSYS_MAINVIEWORGBOOKTYPE.toString() : CacheKey.ACCSYS_STATVIEWORGBOOKTYPE.toString());
        if (str != null) {
            Map map = (Map)GLUtil.fromSerializedString(str);
            return map;
        }
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet orgstructure = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getOrgStructure"), (String)"bos_org_structure", (String)"org,view", (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"10"), new QFilter("isleaf", "=", (Object)true)}, null);
             DataSet structure = viewDataSet.join(orgstructure, JoinType.INNER).on("id", "view").select(new String[]{"id", "accountingsys", "org"}).finish();
             DataSet finish = bookDataSet.join(structure, JoinType.INNER).on("accountingsys", "accountingsys").on("org", "org").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                Map orgBookTypeMap;
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                if (result.containsKey(mainView)) {
                    List<Long> bookTypeList;
                    orgBookTypeMap = (Map)result.get(mainView);
                    if (orgBookTypeMap.containsKey(org)) {
                        bookTypeList = (List)orgBookTypeMap.get(org);
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        CacheHelper.getDistributeCache(CacheModule.accSys).put(isMainView ? CacheKey.ACCSYS_MAINVIEWORGBOOKTYPE.toString() : CacheKey.ACCSYS_STATVIEWORGBOOKTYPE.toString(), GLUtil.toSerializedString(result));
        return result;
    }

    private static List<Long> getParentOrgId(DataSet orgDataSet, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
        if (includeChildSelf) {
            result.addAll(childList);
        }
        return result;
    }

    private static void getParentOrgIdHelper(final Set<Long> childList, LinkedList<Long> result, DataSet orgDataSet) {
        LinkedHashSet<Long> parentOrgId = new LinkedHashSet<Long>();
        try (DataSet parentOrgSet = orgDataSet.copy().filter(new FilterFunction(){
            private static final long serialVersionUID = 5578416618246765024L;

            public boolean test(Row row) {
                return childList.contains(row.getLong("org"));
            }
        });){
            for (Row row : parentOrgSet) {
                Long parent = row.getLong("parent");
                if (parent == null || parent == 0L) continue;
                parentOrgId.add(parent);
            }
            if (!parentOrgId.isEmpty()) {
                for (Long pid : parentOrgId) {
                    if (result.contains(pid)) continue;
                    result.addFirst(pid);
                }
                AccSysUtil.getParentOrgIdHelper(parentOrgId, result, orgDataSet);
            }
        }
    }

    public static long getParentOrgByChildre(List<Long> filterOrgs) {
        return AccSysUtil.getParentOrgByChildre(filterOrgs, Long.valueOf("10"));
    }

    public static long getParentOrgByChildre(List<Long> filterOrgs, Long viewId) {
        if (filterOrgs == null || filterOrgs.isEmpty()) {
            return 0L;
        }
        if (filterOrgs.size() == 1) {
            return filterOrgs.get(0);
        }
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"TaxReportFormHelper.getParentOrg", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)viewId)}, null);){
            Map<Long, Set<Long>> orgTreeMap = AccSysUtil.getOrgTreeMap(orgDataSet);
            Set<Long> topOrgs = orgTreeMap.get(0L);
            if (topOrgs.isEmpty()) {
                long l = 0L;
                return l;
            }
            HashMap<Long, Tuple2<Integer, Integer>> orgTagMap = new HashMap<Long, Tuple2<Integer, Integer>>();
            Long topOrg = topOrgs.iterator().next();
            int[] cnt = new int[]{0};
            AccSysUtil.explore(orgTreeMap, topOrg, orgTagMap, cnt);
            Tuple2<Integer, Integer> range = AccSysUtil.getRange(filterOrgs, orgTagMap);
            if (range == null) {
                long l = topOrg;
                return l;
            }
            List collect = orgTagMap.entrySet().stream().filter(e -> (Integer)((Tuple2)e.getValue()).t1 <= (Integer)range.t1 && (Integer)((Tuple2)e.getValue()).t2 >= (Integer)range.t2).sorted(Comparator.comparing(o -> (Integer)((Tuple2)o.getValue()).t2)).collect(Collectors.toList());
            long l = (Long)((Map.Entry)collect.get(0)).getKey();
            return l;
        }
    }

    private static void explore(Map<Long, Set<Long>> orgTreeMap, Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2((Object)0, (Object)0));
        AccSysUtil.preVisit(org, orgTagMap, cnt);
        for (Long leafOrg : orgTreeMap.get(org)) {
            if (orgTagMap.get(leafOrg) != null) continue;
            AccSysUtil.explore(orgTreeMap, leafOrg, orgTagMap, cnt);
        }
        AccSysUtil.postVisit(org, orgTagMap, cnt);
    }

    private static void postVisit(Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        Tuple2<Integer, Integer> old = orgTagMap.get(org);
        int n = cnt[0];
        cnt[0] = n + 1;
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2(old.t1, (Object)n));
    }

    private static void preVisit(Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        int n = cnt[0];
        cnt[0] = n + 1;
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2((Object)n, (Object)0));
    }

    private static Map<Long, Set<Long>> getOrgTreeMap(DataSet orgDataSet) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        for (Row row : orgDataSet) {
            Long org = row.getLong("org");
            Long parent = row.getLong("parent");
            result.putIfAbsent(org, new HashSet());
            result.compute(parent, (k, v) -> {
                if (v == null) {
                    HashSet<Long> leaf = new HashSet<Long>();
                    leaf.add(org);
                    return leaf;
                }
                v.add(org);
                return v;
            });
        }
        return result;
    }

    private static Tuple2<Integer, Integer> getRange(List<Long> filterOrgs, Map<Long, Tuple2<Integer, Integer>> orgTagMap) {
        Set collect = orgTagMap.entrySet().stream().filter(e -> filterOrgs.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        Optional<Integer> min = collect.stream().map(x -> (Integer)x.t1).min(Integer::compareTo);
        Optional<Integer> max = collect.stream().map(x -> (Integer)x.t2).max(Integer::compareTo);
        return min.map(integer -> new Tuple2(integer, max.get())).orElse(null);
    }

    public static boolean existsBudgetBook(Collection<Long> orgIds, Collection<Long> bookTypeIds) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(bookTypeIds)) {
            return false;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(orgIds);
        if (orgIdSet.size() <= 1000) {
            QFilterBuilder qFilterBuilder = new QFilterBuilder().addIn("org", orgIds).addIn("bookstype", bookTypeIds).addEqual("isbudget", (Object)Boolean.TRUE);
            return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qFilterBuilder.toArray(new QFilter[0]));
        }
        QFilterBuilder qFilterBuilder = new QFilterBuilder().addIn("bookstype", bookTypeIds).addEqual("isbudget", (Object)Boolean.TRUE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccSysUtil.class.getName(), (String)"gl_accountbook", (String)"org", (QFilter[])qFilterBuilder.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                if (!orgIdSet.contains(row.getLong(0))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static long getMainBookTypeId() {
        return (Long)ThreadCache.get((Object)"getMainBookTypeId", () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("accounttype", "=", AccountBooksType.MAIN_BOOK.getValue());
            DynamicObject mainBookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])qfBuilder.toArray());
            return mainBookType == null ? 0L : mainBookType.getLong("id");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getDefaultOrgId(String entityId, boolean supportVirtual, PermissonType permType) {
        Objects.requireNonNull(permType);
        RequestContext context = RequestContext.getOrCreate();
        long curUserId = context.getCurrUserId();
        long curOrgId = context.getOrgId();
        CacheKey cacheKey = CacheKey.getCacheKey(CacheKeyPrefix.DEFAULT_ORG_ID_CACHE, String.valueOf(curUserId), String.valueOf(curOrgId), entityId, String.valueOf(supportVirtual), permType.getPermId());
        Long defaultOrgId = LocalCacheHelper.get(cacheKey, Long.class);
        if (!Objects.isNull(defaultOrgId)) return defaultOrgId;
        Class<AccSysUtil> clazz = AccSysUtil.class;
        synchronized (AccSysUtil.class) {
            Set<Long> acctOrgPkList;
            defaultOrgId = LocalCacheHelper.get(cacheKey, Long.class);
            if (!Objects.isNull(defaultOrgId)) return defaultOrgId;
            defaultOrgId = OrgUnitServiceHelper.checkOrgFunction((Long)curOrgId, (String)"10") ? (AccSysUtil.isLeafOrg(curOrgId) ? ((acctOrgPkList = AccSysUtil.getAcctOrgPkList2(entityId, false, permType)).contains(curOrgId) ? Long.valueOf(curOrgId) : Long.valueOf(AccSysUtil.getOrgIdByHasPermOrg(supportVirtual, acctOrgPkList))) : (supportVirtual && AccSysUtil.getAcctOrgPkList(entityId, true, permType).contains(curOrgId) ? Long.valueOf(curOrgId) : Long.valueOf(AccSysUtil.getOrgIdByHasPermOrg(supportVirtual, AccSysUtil.getAcctOrgPkList(entityId, supportVirtual, permType))))) : Long.valueOf(AccSysUtil.getOrgIdByHasPermOrg(supportVirtual, AccSysUtil.getAcctOrgPkList(entityId, supportVirtual, permType)));
            LocalCacheHelper.put(cacheKey, defaultOrgId);
            // ** MonitorExit[var10_8] (shouldn't be in output)
            return defaultOrgId;
        }
    }

    private static long getFirstOrgOrderByNum(Collection<Long> ids) {
        List resultList = BatchProcessUtil.batchProcess(ids, batchData -> {
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", batchData)}, (String)"number", (int)1);
            if (!orgDyns.isEmpty()) {
                DynamicObject orgDyn = (DynamicObject)orgDyns.get(0);
                return new Tuple<Long, String>(orgDyn.getLong("id"), orgDyn.getString("number"));
            }
            return null;
        });
        resultList.sort(Comparator.comparing(o -> (String)o.item2));
        if (resultList.isEmpty()) {
            return 0L;
        }
        return (Long)((Tuple)resultList.get((int)0)).item1;
    }

    private static boolean isLeafOrg(long orgId) {
        HashSet<Long> viewIdSet = new HashSet<Long>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccSysUtil.class.getName(), (String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{new QFilter("ismainview", "=", (Object)"1")}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                viewIdSet.add(row.getLong("id"));
            }
        }
        if (!viewIdSet.isEmpty()) {
            return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("view", "in", viewIdSet), new QFilter("isleaf", "=", (Object)true)});
        }
        return false;
    }

    private static long getOrgIdByHasPermOrg(boolean supportVirtual, Collection<Long> hasPermOrgIdList) {
        if (supportVirtual) {
            long orgViewTypeId = Long.parseLong("10");
            Map rootOrgIdMap = OrgUnitServiceHelper.getRootOrgId(Collections.singletonList(orgViewTypeId));
            long orgId = rootOrgIdMap.getOrDefault(orgViewTypeId, 0L);
            if (hasPermOrgIdList.contains(orgId)) {
                return orgId;
            }
            return AccSysUtil.getFirstOrgOrderByNum(hasPermOrgIdList);
        }
        return AccSysUtil.getFirstOrgOrderByNum(hasPermOrgIdList);
    }

    public static Set<Long> getAllOrgIdByComboItems(Collection<ComboItem> comboItems) {
        return comboItems.stream().filter(x -> x.getValue() != null).mapToLong(x -> Long.parseLong(x.getValue())).boxed().collect(Collectors.toSet());
    }

    public static void dealCacheOrgCustomFilter(FilterColumn orgfilterColumn, IPageCache pageCache) {
        String customFilterSer = pageCache.get("customfilter");
        if (!StringUtils.isEmpty((String)customFilterSer)) {
            List customfilters = (List)SerializationUtils.fromJsonString((String)customFilterSer, List.class);
            block0: for (Map filter : customfilters) {
                List nameFieds = (List)filter.get("FieldName");
                if (nameFieds == null) continue;
                for (Object name : nameFieds) {
                    if (!"useorg.id".equals(String.valueOf(name))) continue;
                    filter.put("Value", orgfilterColumn.getDefaultValues());
                    continue block0;
                }
            }
            pageCache.put("customfilter", SerializationUtils.toJsonString((Object)customfilters));
            pageCache.put("createOrg", String.valueOf(orgfilterColumn.getDefaultValues().get(0)));
        }
    }
}

