/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accsys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.gl.constant.Account;

public class AccountInfo {
    private long id;
    private String curType;
    private List<Long> desCurIds;
    private boolean isAssist;
    private List<Tuple2<String, Boolean>> assItems;
    private Map<String, String> assFlexToNameMap;
    private boolean isQty;
    private long unitGroup;
    private long unit;
    private String accountType;
    private Map<String, Boolean> flexToIsLeaf;

    public AccountInfo() {
    }

    public AccountInfo(long id) {
        this.id = id;
    }

    public AccountInfo(DynamicObject accDyn) {
        this.id = accDyn.getLong("id");
        this.curType = accDyn.getString("acctcurrency");
        ArrayList<Long> desCurList = new ArrayList<Long>();
        if ("descurrency".equals(this.curType)) {
            DynamicObjectCollection currencyEntry = accDyn.getDynamicObjectCollection("currencyentry");
            for (DynamicObject cur : currencyEntry) {
                desCurList.add(cur.getLong(Account.id_("currency")));
            }
        }
        this.desCurIds = desCurList;
        ArrayList<Tuple2<String, Boolean>> assList = new ArrayList<Tuple2<String, Boolean>>(10);
        this.isAssist = accDyn.getBoolean("isassist");
        this.assFlexToNameMap = new HashMap<String, String>(10);
        this.flexToIsLeaf = new HashMap<String, Boolean>(10);
        if (this.isAssist) {
            DynamicObjectCollection assEntry = accDyn.getDynamicObjectCollection("checkitementry");
            for (DynamicObject assDyn : assEntry) {
                String flexField = assDyn.getString("asstactitem.flexfield");
                String flexName = assDyn.getString("asstactitem.name");
                assList.add((Tuple2<String, Boolean>)new Tuple2((Object)flexField, (Object)assDyn.getBoolean("isrequire")));
                this.flexToIsLeaf.put(flexField, assDyn.getBoolean("isdetail"));
                this.assFlexToNameMap.put(flexField, flexName);
            }
        }
        this.assItems = assList;
        this.isQty = accDyn.getBoolean("isqty");
        if (this.isQty) {
            this.unitGroup = accDyn.getLong(Account.id_("measureunitgroup"));
            this.unit = accDyn.getLong(Account.id_("measureunit"));
        }
        this.accountType = accDyn.getString("accounttype.accounttype");
    }

    public String getCurType() {
        return this.curType;
    }

    public void setCurType(String curType) {
        this.curType = curType;
    }

    public List<Long> getDesCurIds() {
        return this.desCurIds;
    }

    public void setDesCurIds(List<Long> desCurIds) {
        this.desCurIds = desCurIds;
    }

    public boolean isAssist() {
        return this.isAssist;
    }

    public void setAssist(boolean assist) {
        this.isAssist = assist;
    }

    public List<Tuple2<String, Boolean>> getAssItems() {
        return this.assItems;
    }

    public void setAssItems(List<Tuple2<String, Boolean>> assItems) {
        this.assItems = assItems;
    }

    public long getId() {
        return this.id;
    }

    public boolean isQty() {
        return this.isQty;
    }

    public void setQty(boolean qty) {
        this.isQty = qty;
    }

    public long getUnitGroup() {
        return this.unitGroup;
    }

    public void setUnitGroup(long unitGroup) {
        this.unitGroup = unitGroup;
    }

    public long getUnit() {
        return this.unit;
    }

    public void setUnit(long unit) {
        this.unit = unit;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Map<String, String> getAssFlexToNameMap() {
        return this.assFlexToNameMap;
    }

    public Map<String, Boolean> getFlexToIsLeaf() {
        return this.flexToIsLeaf;
    }
}

