/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.assistitem.IEntityRelationValueMapper;
import kd.fi.gl.assistitem.MerchantsAssistValueQueryer;

public abstract class AbstractMerchantsValueMapper
implements IEntityRelationValueMapper {
    private static final String ENABLE = "enable";
    private static final String INTERNAL_COMPANY = "internal_company";
    private static final String BIZPARTNER = "bizpartner";

    @Override
    public Map<String, Object> getMappingValue(Object originalValue, String origianlValueEntity, long useOrgId) {
        DynamicObject fromMerchantsDO = QueryServiceHelper.queryOne((String)this.getFromMerchantsKey(), (String)String.join((CharSequence)",", BIZPARTNER, INTERNAL_COMPANY), (QFilter[])QFilterBuilder.create((String)"id", (String)"=", (Object)Long.valueOf(originalValue.toString())).toArray(new QFilter[0]));
        if (Objects.isNull(fromMerchantsDO)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        long bizPartnerId = fromMerchantsDO.getLong(BIZPARTNER);
        resultMap.put("bd_bizpartner", bizPartnerId);
        long internalCompanyId = fromMerchantsDO.getLong(INTERNAL_COMPANY);
        resultMap.put("bos_org", internalCompanyId);
        MerchantsAssistValueQueryer merchantsQueryer = new MerchantsAssistValueQueryer(this.getToMerchantsKey(), useOrgId);
        Optional<Long> valueBuf = merchantsQueryer.queryByBizPartner(bizPartnerId);
        if (valueBuf.isPresent()) {
            resultMap.put(this.getToMerchantsKey(), valueBuf.get());
        } else {
            valueBuf = merchantsQueryer.queryByInternalCompanyId(internalCompanyId);
            if (valueBuf.isPresent()) {
                resultMap.put(this.getToMerchantsKey(), valueBuf.get());
            }
        }
        return resultMap;
    }

    public abstract String getFromMerchantsKey();

    public abstract String getToMerchantsKey();
}

