/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.gl.assistitem.AccountItemValueMappingHelper;
import kd.fi.gl.assistitem.AssgrpMappingParam;
import kd.fi.gl.cache.IdDynCache;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.FlexUtils;

public class CashFLowItemFlexValueGetter {
    private static final String CASHFLOW_ITEM_ASSIST = String.join((CharSequence)".", "assistentry", "asstypeid");
    private final IdDynCache cashFlowItemCache = new IdDynCache(16, "gl_cashflowitem", CASHFLOW_ITEM_ASSIST);

    public long getFromAccountFlexValueJson(FlexValueJson accountFlexValue, long mainCfItemId, long orgId) {
        Map<String, Object> valueMap = accountFlexValue.getValueMap();
        if (valueMap.isEmpty()) {
            return 0L;
        }
        DynamicObject cashFlowItem = (DynamicObject)this.cashFlowItemCache.get(mainCfItemId);
        if (null == cashFlowItem) {
            return 0L;
        }
        DynamicObjectCollection assistEntry = cashFlowItem.getDynamicObjectCollection("assistentry");
        if (assistEntry.isEmpty()) {
            return 0L;
        }
        Set<String> flexFields = assistEntry.stream().map(x -> x.getString(String.join((CharSequence)".", "asstypeid", "flexfield"))).collect(Collectors.toSet());
        return FlexUtils.saveFlexData(AccountItemValueMappingHelper.getMappingValue(new AssgrpMappingParam(valueMap, flexFields, orgId)));
    }
}

