/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.assistitem;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.assistitem.AbstractAccountItemValueMapper;
import kd.fi.gl.assistitem.AssgrpMappingParam;
import kd.fi.gl.assistitem.EntityRelationValueMapperFactory;
import kd.fi.gl.assistitem.IEntityRelationValueMapper;
import kd.fi.gl.util.FlexUtils;

public class EntityRelationValueMapper
extends AbstractAccountItemValueMapper {
    @Override
    public int priority() {
        return 3;
    }

    @Override
    protected Map<String, Object> getMappingValue(AssgrpMappingParam assgrpMappingParam) {
        HashMap<String, Object> targetFlexToValue = new HashMap<String, Object>(assgrpMappingParam.getTargetFlexs().size());
        HashSet<String> tempFlexs = new HashSet<String>(assgrpMappingParam.getTargetFlexs());
        for (Map.Entry<String, Object> entry : assgrpMappingParam.getOriginalFlexToValue().entrySet()) {
            if (tempFlexs.isEmpty()) {
                return targetFlexToValue;
            }
            targetFlexToValue.putAll(this.getMappingValueByEntityRelation(entry.getKey(), entry.getValue(), tempFlexs, assgrpMappingParam.getUseOrgId()));
            tempFlexs.removeAll(targetFlexToValue.keySet());
        }
        return targetFlexToValue;
    }

    private Map<String, Object> getMappingValueByEntityRelation(String originalFlexField, Object originalValue, Set<String> targetFlexs, long useOrgId) {
        String entity = FlexUtils.getEntity(originalFlexField);
        if (StringUtils.isBlank((CharSequence)entity)) {
            return Collections.emptyMap();
        }
        IEntityRelationValueMapper mapper = EntityRelationValueMapperFactory.getMapper(entity);
        if (null == mapper) {
            return Collections.emptyMap();
        }
        Map<String, Object> entityToValue = mapper.getMappingValueWithCache(originalValue, entity, useOrgId);
        if (entityToValue.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> targetFlexToEntity = FlexUtils.batchGetFlexEntity(targetFlexs.toArray(new String[0]));
        HashMap<String, Object> targetFlexToValue = new HashMap<String, Object>(targetFlexs.size());
        targetFlexToEntity.forEach((targetFlexField, targetEntity) -> {
            Object value;
            if (StringUtils.isNotBlank((CharSequence)targetEntity) && null != (value = entityToValue.get(targetEntity))) {
                targetFlexToValue.put((String)targetFlexField, value);
            }
        });
        return targetFlexToValue;
    }
}

