/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.autotrans;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.finalprocess.info.AmountInfo;

public class BalanceInfo {
    private BigDecimal endForSum = BigDecimal.ZERO;
    private BigDecimal endLocalSum = BigDecimal.ZERO;
    private BigDecimal creditForSum = BigDecimal.ZERO;
    private BigDecimal creditLocalSum = BigDecimal.ZERO;
    private BigDecimal debitForSum = BigDecimal.ZERO;
    private BigDecimal debitLocalSum = BigDecimal.ZERO;
    private Map<Long, BigDecimal> assgrp2balancne;
    private Map<Long, BigDecimal> account2balance;
    private Map<Long, BigDecimal> measureunit2balancne;
    private Map<Long, Map<Long, BigDecimal>> account2assgrp2balance;
    private Map<Long, Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>> account2assgrp2measureunit2balance;

    public BigDecimal getEndForSum() {
        return this.endForSum;
    }

    public void setEndForSum(BigDecimal endForSum) {
        this.endForSum = this.endForSum.add(endForSum);
    }

    public BigDecimal getEndLocalSum() {
        return this.endLocalSum;
    }

    public void setEndLocalSum(BigDecimal endLocalSum) {
        this.endLocalSum = this.endLocalSum.add(endLocalSum);
    }

    public BigDecimal getCreditForSum() {
        return this.creditForSum;
    }

    public void setCreditForSum(BigDecimal creditForSum) {
        this.creditForSum = this.creditForSum.add(creditForSum);
    }

    public BigDecimal getCreditLocalSum() {
        return this.creditLocalSum;
    }

    public void setCreditLocalSum(BigDecimal creditLocalSum) {
        this.creditLocalSum = this.creditLocalSum.add(creditLocalSum);
    }

    public BigDecimal getDebitForSum() {
        return this.debitForSum;
    }

    public void setDebitForSum(BigDecimal debitForSum) {
        this.debitForSum = this.debitForSum.add(debitForSum);
    }

    public BigDecimal getDebitLocalSum() {
        return this.debitLocalSum;
    }

    public void setDebitLocalSum(BigDecimal debitLocalSum) {
        this.debitLocalSum = this.debitLocalSum.add(debitLocalSum);
    }

    public Map<Long, BigDecimal> getAssgrp2balancne() {
        if (this.assgrp2balancne == null) {
            this.assgrp2balancne = new HashMap<Long, BigDecimal>(0);
        }
        return this.assgrp2balancne;
    }

    public void setAssgrp2balancne(Map<Long, BigDecimal> assgrp2balancne) {
        this.assgrp2balancne = assgrp2balancne;
    }

    public Map<Long, BigDecimal> getAccount2balance() {
        if (this.account2balance == null) {
            this.account2balance = new HashMap<Long, BigDecimal>(0);
        }
        return this.account2balance;
    }

    public void setAccount2balance(Map<Long, BigDecimal> account2balance) {
        this.account2balance = account2balance;
    }

    public Map<Long, Map<Long, BigDecimal>> getAccount2assgrp2balance() {
        if (this.account2assgrp2balance == null) {
            this.account2assgrp2balance = new HashMap<Long, Map<Long, BigDecimal>>(0);
        }
        return this.account2assgrp2balance;
    }

    public void setAccount2assgrp2balance(Map<Long, Map<Long, BigDecimal>> account2assgrp2balance) {
        this.account2assgrp2balance = account2assgrp2balance;
    }

    public Map<Long, Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>> getAccount2assgrp2measureunit2balance() {
        if (this.account2assgrp2measureunit2balance == null) {
            this.account2assgrp2measureunit2balance = new HashMap<Long, Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>>(0);
        }
        return this.account2assgrp2measureunit2balance;
    }

    public void setAccount2assgrp2measureunit2balance(Map<Long, Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>> account2assgrp2measureunit2balance) {
        this.account2assgrp2measureunit2balance = account2assgrp2measureunit2balance;
    }

    public Map<Long, BigDecimal> getMeasureunit2balancne() {
        return this.measureunit2balancne;
    }

    public void setMeasureunit2balancne(Map<Long, BigDecimal> measureunit2balancne) {
        this.measureunit2balancne = measureunit2balancne;
    }

    public void update(AmountInfo amount) {
        if (amount == null) {
            return;
        }
        if ("1".equals(amount.getDc())) {
            this.setDebitLocalSum(amount.getLocAmount());
            this.setEndLocalSum(amount.getLocAmount());
            this.setDebitForSum(amount.getOriAmount());
            this.setEndForSum(amount.getOriAmount());
        } else {
            this.setCreditLocalSum(amount.getLocAmount());
            this.setEndLocalSum(amount.getLocAmount().negate());
            this.setCreditForSum(amount.getOriAmount());
            this.setEndForSum(amount.getOriAmount().negate());
        }
        this.updateAccoutAndAssgrpBalanceInfo(amount);
    }

    private void updateAccoutAndAssgrpBalanceInfo(AmountInfo amount) {
        Tuple<BigDecimal, BigDecimal> accountAssgrpMeasureunitLocAmount;
        Map<Long, Tuple<BigDecimal, BigDecimal>> measureunit2amount;
        Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>> assgrp2measureunit2amount;
        Map<Long, BigDecimal> assgrp2amount;
        Long accountId = amount.getAccountId();
        Long assgrpId = amount.getAssgrpId();
        Long measureunitId = amount.getMeasureUnitID();
        if (this.account2balance == null) {
            this.account2balance = new HashMap<Long, BigDecimal>();
        }
        if (this.assgrp2balancne == null) {
            this.assgrp2balancne = new HashMap<Long, BigDecimal>();
        }
        if (this.account2assgrp2balance == null) {
            this.account2assgrp2balance = new HashMap<Long, Map<Long, BigDecimal>>();
        }
        if ((assgrp2amount = this.account2assgrp2balance.get(accountId)) == null) {
            assgrp2amount = new HashMap<Long, BigDecimal>();
        }
        if (this.account2assgrp2measureunit2balance == null) {
            this.account2assgrp2measureunit2balance = new HashMap<Long, Map<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>>();
        }
        if (this.measureunit2balancne == null) {
            this.measureunit2balancne = new HashMap<Long, BigDecimal>();
        }
        if ((assgrp2measureunit2amount = this.account2assgrp2measureunit2balance.get(accountId)) == null) {
            assgrp2measureunit2amount = new HashMap<Long, Map<Long, Tuple<BigDecimal, BigDecimal>>>();
        }
        if ((measureunit2amount = assgrp2measureunit2amount.get(assgrpId)) == null) {
            measureunit2amount = new HashMap<Long, Tuple<BigDecimal, BigDecimal>>();
        }
        BigDecimal accountLocAmount = this.account2balance.get(accountId) == null ? BigDecimal.ZERO : this.account2balance.get(accountId);
        BigDecimal assgrpLocAmount = this.assgrp2balancne.get(assgrpId) == null ? BigDecimal.ZERO : this.assgrp2balancne.get(assgrpId);
        BigDecimal accountAssgrpLocAmount = assgrp2amount.get(assgrpId) == null ? BigDecimal.ZERO : assgrp2amount.get(assgrpId);
        Tuple<BigDecimal, BigDecimal> tuple = accountAssgrpMeasureunitLocAmount = measureunit2amount.get(measureunitId) == null ? new Tuple<BigDecimal, BigDecimal>(BigDecimal.ZERO, BigDecimal.ZERO) : measureunit2amount.get(measureunitId);
        if ("1".equals(amount.getDc())) {
            accountLocAmount = accountLocAmount.add(amount.getLocAmount());
            assgrpLocAmount = assgrpLocAmount.add(amount.getLocAmount());
            accountAssgrpLocAmount = accountAssgrpLocAmount.add(amount.getLocAmount());
            accountAssgrpMeasureunitLocAmount.item1 = ((BigDecimal)accountAssgrpMeasureunitLocAmount.item1).add(amount.getLocAmount());
            accountAssgrpMeasureunitLocAmount.item2 = ((BigDecimal)accountAssgrpMeasureunitLocAmount.item2).add(amount.getQty());
        } else {
            accountLocAmount = accountLocAmount.add(amount.getLocAmount().negate());
            assgrpLocAmount = assgrpLocAmount.add(amount.getLocAmount().negate());
            accountAssgrpLocAmount = accountAssgrpLocAmount.add(amount.getLocAmount().negate());
            accountAssgrpMeasureunitLocAmount.item1 = ((BigDecimal)accountAssgrpMeasureunitLocAmount.item1).add(amount.getLocAmount().negate());
            accountAssgrpMeasureunitLocAmount.item2 = ((BigDecimal)accountAssgrpMeasureunitLocAmount.item2).add(amount.getQty().negate());
        }
        this.account2balance.put(accountId, accountLocAmount);
        this.assgrp2balancne.put(assgrpId, assgrpLocAmount);
        assgrp2amount.put(assgrpId, accountAssgrpLocAmount);
        measureunit2amount.put(measureunitId, accountAssgrpMeasureunitLocAmount);
        assgrp2measureunit2amount.put(assgrpId, measureunit2amount);
        this.account2assgrp2measureunit2balance.put(accountId, assgrp2measureunit2amount);
    }

    public BigDecimal getLocBalanceByAccountIds(Set<Long> accountIds) {
        BigDecimal result = BigDecimal.ZERO;
        if (this.account2balance != null && !this.account2balance.isEmpty()) {
            for (Long accountId : accountIds) {
                BigDecimal locAmount = this.account2balance.get(accountId);
                if (locAmount == null) continue;
                result = result.add(locAmount);
            }
        }
        return result;
    }
}

