/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.autotrans;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.AutoTransAmountType;
import kd.fi.gl.autotrans.PercentExpObject;
import kd.fi.gl.autotrans.PercentExpRow;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;

public class PercentExpBuilder {
    private PercentExpObject expObject;
    private static final Log log = LogFactory.getLog(PercentExpBuilder.class);
    private static String[] signs = new String[]{"+", "-", "*", "/"};
    private static String[] sumFields = new String[]{"beginlocal", "endlocal", "debitlocal", "creditlocal", "yeardebitlocal", "yearcreditlocal"};

    public static PercentExpBuilder create(PercentExpObject expObject) {
        PercentExpBuilder percentExpBuilder = new PercentExpBuilder();
        percentExpBuilder.expObject = expObject;
        return percentExpBuilder;
    }

    public BigDecimal build(boolean includeResult) {
        return this.build(includeResult, 0L);
    }

    public BigDecimal build(boolean includeResult, long specifiedPeriodId) {
        List<PercentExpRow> percentRows = this.expObject.getPercentRows();
        int countOfBracket = 0;
        StringBuilder descBuilder = new StringBuilder();
        StringBuilder formulaBuilder = new StringBuilder();
        for (PercentExpRow percentExpRow : percentRows) {
            countOfBracket = this.checkBracket(percentExpRow, countOfBracket);
            descBuilder.append(percentExpRow.getDescRow());
            formulaBuilder.append(percentExpRow.getFormulaFormat());
        }
        if (countOfBracket != 0) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"PercentExpBuilder_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.expObject.setDesc(descBuilder.toString());
        this.checkFormulaFormat(formulaBuilder.toString());
        this.expObject.setFormulaFormat(formulaBuilder.toString());
        if (includeResult) {
            return this.buildResult(specifiedPeriodId);
        }
        return null;
    }

    private int checkBracket(PercentExpRow percentExpRow, int countOfBracket) {
        if (StringUtils.isNotBlank((CharSequence)percentExpRow.getLeftBracket())) {
            countOfBracket += percentExpRow.getLeftBracket().replace(" ", "").length();
        }
        if (StringUtils.isNotBlank((CharSequence)percentExpRow.getRightBracket())) {
            countOfBracket -= percentExpRow.getRightBracket().replace(" ", "").length();
        }
        if (countOfBracket < 0) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"PercentExpBuilder_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        return countOfBracket;
    }

    private void checkFormulaFormat(String formulaFormat) {
        for (String sign1 : signs) {
            if (formulaFormat.endsWith(sign1)) {
                throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4ee5\u8fd0\u7b97\u7b26\u53f7\u7ed3\u5c3e\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PercentExpBuilder_1", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            for (String sign2 : signs) {
                if (formulaFormat.indexOf(sign1 + sign2) < 0) continue;
                throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u516c\u5f0f\u8fd0\u7b97\u7b26\u4e4b\u95f4\u6ca1\u6709\u503c\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PercentExpBuilder_2", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        int errorIndex1 = formulaFormat.indexOf("%s(");
        int errorIndex2 = formulaFormat.indexOf("%s%s");
        int errorIndex3 = formulaFormat.indexOf("()");
        int errorIndex4 = formulaFormat.indexOf(")%s");
        if (errorIndex1 >= 0 || errorIndex2 >= 0 || errorIndex3 >= 0 || errorIndex4 >= 0) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u516c\u5f0f\u7f16\u8f91\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PercentExpBuilder_3", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    private BigDecimal buildResult(long specifiedPeriodId) {
        List<PercentExpRow> percentRows = this.expObject.getPercentRows();
        ArrayList<Long> accountids = new ArrayList<Long>(percentRows.size());
        ArrayList<Long> placcountids = new ArrayList<Long>(percentRows.size());
        for (PercentExpRow percentExpRow : percentRows) {
            AutoTransAmountType amounttype = percentExpRow.getAmounttype();
            if (amounttype == null) continue;
            if (amounttype.getIsPL()) {
                placcountids.add(percentExpRow.getAccount());
                continue;
            }
            accountids.add(percentExpRow.getAccount());
        }
        return this.getAmountVal(accountids, placcountids, specifiedPeriodId);
    }

    private BigDecimal getAmountVal(List<Long> accountids, List<Long> placcountids, long specifiedPeriodId) {
        long bookid = this.expObject.getBookid();
        AccountBookInfo book = null;
        if (bookid > 0L) {
            try {
                book = new AccountBookInfo(bookid);
            }
            catch (Exception e) {
                throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u53ca\u516c\u5f0f\u914d\u7f6e\u3002", (String)"PercentExpBuilder_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        if (book == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u53ca\u516c\u5f0f\u914d\u7f6e\u3002", (String)"PercentExpBuilder_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        List<PercentExpRow> percentRows = this.expObject.getPercentRows();
        HashMap<String, Map<String, BigDecimal>> valMap = new HashMap<String, Map<String, BigDecimal>>(percentRows.size());
        if (!accountids.isEmpty()) {
            this.getBalance(book, accountids, Boolean.FALSE, valMap, specifiedPeriodId);
        }
        if (!placcountids.isEmpty()) {
            this.getBalance(book, placcountids, Boolean.TRUE, valMap, specifiedPeriodId);
        }
        Object result = BigDecimal.ONE;
        ArrayList<String> vals = new ArrayList<String>();
        for (PercentExpRow percentExpRow : percentRows) {
            this.getVal(valMap, percentExpRow, vals);
            BigDecimal defVal = percentExpRow.getDefVal();
            if (defVal == null) continue;
            vals.add(defVal.toString());
        }
        String formulaFormat = this.expObject.getFormulaFormat();
        if (DebugTrace.enable()) {
            log.info("PercentExpBuilderLog: formulaFormat is " + formulaFormat);
            log.info("PercentExpBuilderLog: formulaVal is " + String.join((CharSequence)",", vals));
        }
        String formula = String.format(formulaFormat, vals.toArray());
        if (DebugTrace.enable()) {
            log.info("PercentExpBuilderLog: formula is " + formula);
        }
        try {
            result = FormulaEngine.execExcelFormula((String)formula);
            if (DebugTrace.enable()) {
                log.info("PercentExpBuilderLog: result is " + result.toString());
            }
            BigDecimal decimalResult = new BigDecimal(result.toString());
            return decimalResult;
        }
        catch (Exception e) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u6bd4\u4f8b\u516c\u5f0f\u8ba1\u7b97\u9519\u8bef\uff0c\u53ef\u80fd\u5b58\u5728\u9664\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u914d\u7f6e\u3002", (String)"PercentExpBuilder_5", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    private void getVal(Map<String, Map<String, BigDecimal>> valMap, PercentExpRow percentExpRow, List<String> vals) {
        long accountid = percentExpRow.getAccount();
        String accountStr = String.valueOf(accountid);
        long currencyid = percentExpRow.getCurrency();
        String currencyStr = String.valueOf(currencyid);
        String assgrpJsonVal = percentExpRow.getAssgrpVal();
        if (DebugTrace.enable()) {
            log.info("PercentExpBuilderLog: filter is\uff1a account\uff1a " + accountStr + " currency: " + currencyStr + " assgrpJsonVal: " + assgrpJsonVal);
        }
        List<String> hgs = this.getHgs(assgrpJsonVal);
        AutoTransAmountType amounttype = percentExpRow.getAmounttype();
        if (amounttype != null && accountid > 0L) {
            BigDecimal val = BigDecimal.ZERO;
            if (currencyid > 0L) {
                if (hgs != null) {
                    for (String hg : hgs) {
                        BigDecimal decimalVal;
                        String key = String.join((CharSequence)"-", accountStr, currencyStr, hg);
                        Map<String, BigDecimal> map = valMap.get(key);
                        if (map == null || (decimalVal = map.get(amounttype.getType())) == null) continue;
                        val = val.add(decimalVal);
                    }
                } else {
                    for (Map.Entry<String, Map<String, BigDecimal>> valMapEntry : valMap.entrySet()) {
                        Map<String, BigDecimal> map;
                        BigDecimal decimalVal;
                        String key = String.join((CharSequence)"-", accountStr, currencyStr);
                        if (!valMapEntry.getKey().startsWith(key) || (decimalVal = (map = valMapEntry.getValue()).get(amounttype.getType())) == null) continue;
                        val = val.add(decimalVal);
                    }
                }
            } else if (hgs != null) {
                for (Map.Entry<String, Map<String, BigDecimal>> valMapEntry : valMap.entrySet()) {
                    Map<String, BigDecimal> map;
                    BigDecimal decimalVal;
                    String key = valMapEntry.getKey();
                    String[] split = key.split("-");
                    if (!accountStr.equalsIgnoreCase(split[0]) || !hgs.contains(split[2]) || (decimalVal = (map = valMapEntry.getValue()).get(amounttype.getType())) == null) continue;
                    val = val.add(decimalVal);
                }
            } else {
                for (Map.Entry<String, Map<String, BigDecimal>> valMapEntry : valMap.entrySet()) {
                    Map<String, BigDecimal> map;
                    BigDecimal decimalVal;
                    if (!valMapEntry.getKey().startsWith(accountStr) || (decimalVal = (map = valMapEntry.getValue()).get(amounttype.getType())) == null) continue;
                    val = val.add(decimalVal);
                }
            }
            vals.add(val.abs().toString());
        }
    }

    private List<String> getHgs(String assgrpJsonVal) {
        if (StringUtils.isNotBlank((CharSequence)assgrpJsonVal)) {
            JSONObject valueJson = JSONObject.parseObject((String)assgrpJsonVal);
            DataSet result = null;
            for (Map.Entry map : valueJson.entrySet()) {
                String key = (String)map.getKey();
                Object value = map.getValue();
                DynamicObject assType = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuetype", (QFilter[])new QFilter("flexfield", "=", (Object)key).toArray());
                if (assType == null) continue;
                String valueType = assType.getString("valuetype");
                QFilter filter = new QFilter("asstype", "=", (Object)key);
                filter = filter.and(new QFilter("assval", "=", value));
                DataSet assSet = null;
                if ("1".equalsIgnoreCase(valueType) || "2".equalsIgnoreCase(valueType)) {
                    assSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)"hg id", (QFilter[])filter.toArray(), null);
                } else if ("3".equalsIgnoreCase(valueType)) {
                    assSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_txt", (String)"hg id", (QFilter[])filter.toArray(), null);
                }
                if (assSet == null) continue;
                result = result == null ? assSet : result.join(assSet, JoinType.INNER).on("id", "id").select(new String[]{"id"}, new String[0]).finish();
            }
            if (result != null) {
                ArrayList<String> hgs = new ArrayList<String>();
                for (Row row : result) {
                    hgs.add(row.getString("id"));
                }
                return hgs;
            }
        }
        return null;
    }

    private void getBalance(AccountBookInfo book, List<Long> accountids, boolean ispl, Map<String, Map<String, BigDecimal>> valMap, long specifiedPeriodId) {
        String selector = "beginlocal,endlocal,debitlocal,creditlocal,yeardebitlocal,yearcreditlocal,account.dc dc,account,currency,assgrp";
        QueryParam param = new QueryParam();
        QFilter accountFilter = new QFilter("id", "in", accountids);
        param.setAccountFilter(accountFilter);
        param.setSpecialAccount(Boolean.TRUE.booleanValue());
        param.setSubstractPL(ispl);
        long orgid = book.getOrgId();
        try (DataSet balance = BalanceQueryExecutor.getInstance().getBalance(selector, new Long[]{orgid}, book.getBookTypeId(), book.getAccountTableId(), book.getCurPeriodId(specifiedPeriodId), book.getCurPeriodId(specifiedPeriodId), param);){
            GroupbyDataSet groupbyDataSet = balance.groupBy(new String[]{"account", "assgrp", "currency", "dc"});
            for (String sumField : sumFields) {
                groupbyDataSet.sum(sumField);
            }
            try (DataSet ds = groupbyDataSet.finish();){
                for (Row row : ds) {
                    this.handelRow(row, valMap, ispl);
                }
            }
        }
    }

    private void handelRow(Row row, Map<String, Map<String, BigDecimal>> valMap, boolean ispl) {
        Map<String, BigDecimal> typeToAmount;
        Long accountid = row.getLong("account");
        Long assgrpid = row.getLong("assgrp");
        Long currencyid = row.getLong("currency");
        String key = String.join((CharSequence)"-", String.valueOf(accountid), String.valueOf(currencyid), String.valueOf(assgrpid));
        BigDecimal debitlocal = row.getBigDecimal("debitlocal").setScale(2, 4);
        BigDecimal creditlocal = row.getBigDecimal("creditlocal").setScale(2, 4);
        BigDecimal yearDebitLocal = row.getBigDecimal("yeardebitlocal").setScale(2, 4);
        BigDecimal yearCreditLocal = row.getBigDecimal("yearcreditlocal").setScale(2, 4);
        if (ispl) {
            typeToAmount = valMap.get(key);
            if (typeToAmount == null) {
                typeToAmount = new HashMap<String, BigDecimal>(4);
            }
            typeToAmount.put(AutoTransAmountType.PLDEBITLOCAL.getType(), debitlocal);
            typeToAmount.put(AutoTransAmountType.PLCREDITLOCAL.getType(), creditlocal);
            typeToAmount.put(AutoTransAmountType.YEARPLDEBITLOCAL.getType(), yearDebitLocal);
            typeToAmount.put(AutoTransAmountType.YEARPLCREDITLOCAL.getType(), yearCreditLocal);
        } else {
            typeToAmount = new HashMap<String, BigDecimal>(6);
            BigDecimal beginlocal = row.getBigDecimal("beginlocal").setScale(2, 4);
            BigDecimal endLocal = row.getBigDecimal("endlocal").setScale(2, 4);
            typeToAmount.put(AutoTransAmountType.BEGINLOCAL.getType(), beginlocal);
            typeToAmount.put(AutoTransAmountType.ENDLOCAL.getType(), endLocal);
            typeToAmount.put(AutoTransAmountType.DEBITLOCAL.getType(), debitlocal);
            typeToAmount.put(AutoTransAmountType.CREDITLOCAL.getType(), creditlocal);
            typeToAmount.put(AutoTransAmountType.YEARDEBITLOCAL.getType(), yearDebitLocal);
            typeToAmount.put(AutoTransAmountType.YEARCREDITLOCAL.getType(), yearCreditLocal);
        }
        valMap.put(key, typeToAmount);
    }
}

