/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.autotrans;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.autotrans.AutoTransAmountType;

public class PercentExpRow
implements Serializable {
    private static final long serialVersionUID = -1354515312642301537L;
    private String leftBracket;
    private long account;
    private Object rptProject;
    private String assgrpVal;
    private long currency;
    private AutoTransAmountType amounttype;
    private String rightBracket;
    private String sign;
    private BigDecimal defVal;
    private String formulaFormat;
    private String descRow;

    public static PercentExpRow create(DynamicObject entry) {
        PercentExpRow expRow = new PercentExpRow();
        PercentExpRow.initPercentRow(expRow, entry);
        return expRow;
    }

    public String getLeftBracket() {
        return this.leftBracket;
    }

    public long getAccount() {
        return this.account;
    }

    public Object getRptProject() {
        return this.rptProject;
    }

    public long getCurrency() {
        return this.currency;
    }

    public String getRightBracket() {
        return this.rightBracket;
    }

    public String getSign() {
        return this.sign;
    }

    public BigDecimal getDefVal() {
        return this.defVal;
    }

    public String getFormulaFormat() {
        return this.formulaFormat;
    }

    public void setFormulaFormat(String formulaFormat) {
        this.formulaFormat = formulaFormat;
    }

    public void setLeftBracket(String leftBracket) {
        this.leftBracket = leftBracket;
    }

    public void setAccount(long account) {
        this.account = account;
    }

    public void setRptProject(Object rptProject) {
        this.rptProject = rptProject;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public void setRightBracket(String rightBracket) {
        this.rightBracket = rightBracket;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setDefVal(BigDecimal defVal) {
        this.defVal = defVal;
    }

    public void setDescRow(String descRow) {
        this.descRow = descRow;
    }

    public String getDescRow() {
        return this.descRow;
    }

    public AutoTransAmountType getAmounttype() {
        return this.amounttype;
    }

    public void setAmounttype(AutoTransAmountType amounttype) {
        this.amounttype = amounttype;
    }

    public String getAssgrpVal() {
        return this.assgrpVal;
    }

    public void setAssgrpVal(String assgrpVal) {
        this.assgrpVal = assgrpVal;
    }

    private static void initPercentRow(PercentExpRow expRow, DynamicObject entry) {
        String rstr;
        StringBuilder descBuilder = new StringBuilder();
        StringBuilder formulaBuilder = new StringBuilder();
        String lstr = entry.getString("leftbracket");
        if ("1".equalsIgnoreCase(lstr) || StringUtils.isBlank((CharSequence)lstr)) {
            lstr = "";
        }
        expRow.setLeftBracket(lstr);
        descBuilder.append(lstr);
        formulaBuilder.append(lstr);
        DynamicObject accountDyn = entry.getDynamicObject("account");
        if (accountDyn != null) {
            DynamicObject assgrpDyn = entry.getDynamicObject("assgrp");
            DynamicObject curDyn = entry.getDynamicObject("currency");
            AutoTransAmountType amountType = AutoTransAmountType.getValue(entry.getString("value"));
            if (amountType != null) {
                expRow.setAccount(accountDyn.getLong("id"));
                if (assgrpDyn != null) {
                    expRow.setAssgrpVal(assgrpDyn.getString("value"));
                }
                if (curDyn != null) {
                    expRow.setCurrency(curDyn.getLong("id"));
                }
                expRow.setAmounttype(amountType);
                descBuilder.append(accountDyn.getString("name"));
                descBuilder.append(".");
                descBuilder.append(amountType.getNameLang());
                formulaBuilder.append("%s");
            }
        }
        if ("1".equalsIgnoreCase(rstr = entry.getString("rightbracket")) || StringUtils.isBlank((CharSequence)rstr)) {
            rstr = "";
        }
        expRow.setRightBracket(rstr);
        descBuilder.append(rstr);
        formulaBuilder.append(rstr);
        String signStr = entry.getString("sign");
        if ("1".equalsIgnoreCase(signStr) || StringUtils.isBlank((CharSequence)signStr)) {
            signStr = "";
        }
        expRow.setSign(signStr);
        descBuilder.append(signStr);
        formulaBuilder.append(signStr);
        BigDecimal defValue = entry.getBigDecimal("defval");
        if (defValue.signum() != 0) {
            expRow.setDefVal(defValue);
            descBuilder.append(defValue.toString());
            formulaBuilder.append("%s");
        }
        expRow.setDescRow(descBuilder.toString());
        expRow.setFormulaFormat(formulaBuilder.toString());
    }
}

