/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.balcal.AcctBalanceLog;
import kd.fi.gl.balcal.BalanceCalculator;
import kd.fi.gl.balcal.BalanceData;
import kd.fi.gl.balcal.BalanceKey;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.util.GLUtil;

public class AcctBalanceCalculator
extends BalanceCalculator {
    private static final int SIZE = 200;

    public void reCalculateAcct(long orgId, long booktypeId, long periodId) {
        this.initComassist(orgId, booktypeId);
        this.initMulLocalCurrency(orgId, booktypeId);
        DataSet dataSet = this.queryDetailBalance(orgId, booktypeId, periodId);
        LogList<BalanceKey> logList = new LogList<BalanceKey>();
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbt = new QFilter("bookstype", "=", (Object)booktypeId);
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"startperiod", (QFilter[])new QFilter[]{forg, fbt});
        long startPeriodId = book.getLong("startperiod");
        List sumBalPids = PeriodUtil.getAcctBalEndPeriodIds((String)">=", (Long)periodId, (Long[])new Long[]{orgId});
        for (Row row : dataSet) {
            BalanceKey key = this.getPK(row);
            if (logList.size() > 200) {
                this.updateBalance(orgId, booktypeId, periodId, logList, sumBalPids, startPeriodId);
            }
            logList.add(key, this.getLogData(row));
        }
        if (!logList.isEmpty()) {
            this.updateBalance(orgId, booktypeId, periodId, logList, sumBalPids, startPeriodId);
        }
    }

    @Override
    protected AcctBalanceLog getLogData(Row rs) {
        AcctBalanceLog log = new AcctBalanceLog();
        log.setDebitFor(rs.getBigDecimal("fdebitfor"));
        log.setCreditFor(rs.getBigDecimal("fcreditfor"));
        log.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
        log.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        log.setDebitQty(rs.getBigDecimal("fdebitqty"));
        log.setCreditQty(rs.getBigDecimal("fcreditqty"));
        log.setCount(rs.getInteger("fcount"));
        log.setBeginFor(rs.getBigDecimal("fbeginfor"));
        log.setBeginLocal(rs.getBigDecimal("fbeginlocal"));
        log.setBeginQty(rs.getBigDecimal("fbeginqty"));
        this.localCurList.forEach(x -> {
            Collection fields = x.getBalanceLogFields(new MCT[]{MCT.DEBIT, MCT.CREDIT, MCT.BEGIN});
            fields.forEach(field -> log.putMulLocalAmt((MetaField)field, rs.getBigDecimal(field.getDbId())));
        });
        return log;
    }

    @Override
    protected List<BigDecimal> getUpdateBalAmtParam(long periodId, BalanceLog logData, BalanceData bal, BalanceData preBal, boolean reCal, long startPeriodId) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        AcctBalanceLog acctBalanceLog = (AcctBalanceLog)logData;
        if (reCal) {
            param.add(preBal == null ? acctBalanceLog.getBeginFor() : preBal.getEndFor());
            param.add(preBal == null ? acctBalanceLog.getBeginLocal() : preBal.getEndLocal());
            param.add(preBal == null ? acctBalanceLog.getBeginQty() : preBal.getEndQty());
        }
        param.add(acctBalanceLog.getDebitFor());
        param.add(acctBalanceLog.getCreditFor());
        param.add(acctBalanceLog.getDebitLocal());
        param.add(acctBalanceLog.getCreditLocal());
        param.add(acctBalanceLog.getDebitQty());
        param.add(acctBalanceLog.getCreditQty());
        if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
            if (preBal == null) {
                if (periodId != startPeriodId) {
                    param.add(acctBalanceLog.getDebitFor());
                    param.add(acctBalanceLog.getCreditFor());
                    param.add(acctBalanceLog.getDebitLocal());
                    param.add(acctBalanceLog.getCreditLocal());
                    param.add(acctBalanceLog.getDebitQty());
                    param.add(acctBalanceLog.getCreditQty());
                } else {
                    param.add(bal.getYearDebitFor().add(acctBalanceLog.getDebitFor()).subtract(bal.getDebitFor()));
                    param.add(bal.getYearCreditFor().add(acctBalanceLog.getCreditFor()).subtract(bal.getCreditFor()));
                    param.add(bal.getYearDebitLocal().add(acctBalanceLog.getDebitLocal()).subtract(bal.getDebitLocal()));
                    param.add(bal.getYearCreditLocal().add(acctBalanceLog.getCreditLocal()).subtract(bal.getCreditLocal()));
                    param.add(bal.getYearDebitQty().add(acctBalanceLog.getDebitQty()).subtract(bal.getDebitQty()));
                    param.add(bal.getYearCreditQty().add(acctBalanceLog.getCreditQty()).subtract(bal.getCreditQty()));
                }
            } else {
                param.add(preBal.getYearDebitFor().add(acctBalanceLog.getDebitFor()));
                param.add(preBal.getYearCreditFor().add(acctBalanceLog.getCreditFor()));
                param.add(preBal.getYearDebitLocal().add(acctBalanceLog.getDebitLocal()));
                param.add(preBal.getYearCreditLocal().add(acctBalanceLog.getCreditLocal()));
                param.add(preBal.getYearDebitQty().add(acctBalanceLog.getDebitQty()));
                param.add(preBal.getYearCreditQty().add(acctBalanceLog.getCreditQty()));
            }
        } else {
            param.add(acctBalanceLog.getDebitFor());
            param.add(acctBalanceLog.getCreditFor());
            param.add(acctBalanceLog.getDebitLocal());
            param.add(acctBalanceLog.getCreditLocal());
            param.add(acctBalanceLog.getDebitQty());
            param.add(acctBalanceLog.getCreditQty());
        }
        if (reCal) {
            param.add(((BigDecimal)param.get(0)).add(acctBalanceLog.getDebitFor()).subtract(acctBalanceLog.getCreditFor()));
            param.add(((BigDecimal)param.get(1)).add(acctBalanceLog.getDebitLocal()).subtract(acctBalanceLog.getCreditLocal()));
            param.add(((BigDecimal)param.get(2)).add(acctBalanceLog.getDebitQty()).subtract(acctBalanceLog.getCreditQty()));
        } else {
            param.add(acctBalanceLog.getDebitFor().subtract(acctBalanceLog.getCreditFor()));
            param.add(acctBalanceLog.getDebitLocal().subtract(acctBalanceLog.getCreditLocal()));
            param.add(acctBalanceLog.getDebitQty().subtract(acctBalanceLog.getCreditQty()));
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            BigDecimal beginMulLocal = BigDecimal.ZERO;
            if (reCal) {
                beginMulLocal = preBal == null ? bal.getMulLoclAmt(localCur.getBalanceField(MCT.BEGIN)) : preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END));
                param.add(beginMulLocal);
            }
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
                if (preBal == null) {
                    if (periodId != startPeriodId) {
                        param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                        param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
                    } else {
                        param.add(bal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(bal.getMulLoclAmt(localCur.getBalanceField(MCT.DEBIT))));
                        param.add(bal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))).subtract(bal.getMulLoclAmt(localCur.getBalanceField(MCT.CREDIT))));
                    }
                } else {
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))));
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
                }
            } else {
                param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            }
            if (reCal) {
                param.add(beginMulLocal.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
                continue;
            }
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)).subtract(acctBalanceLog.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
        }
        return param;
    }

    @Override
    protected boolean isBalZero(BalanceData bal, BalanceLog logData) {
        boolean isZero;
        AcctBalanceLog acctBalanceLog = (AcctBalanceLog)logData;
        boolean bl = isZero = bal.getBeginFor().add(acctBalanceLog.getBeginFor()).compareTo(BigDecimal.ZERO) == 0 && bal.getBeginLocal().add(acctBalanceLog.getBeginLocal()).compareTo(BigDecimal.ZERO) == 0 && bal.getBeginQty().add(acctBalanceLog.getBeginQty()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditFor().add(logData.getCreditFor()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditLocal().add(logData.getCreditLocal()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditQty().add(logData.getCreditQty()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitFor().add(logData.getDebitFor()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitLocal().add(logData.getDebitLocal()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitQty().add(logData.getDebitQty()).compareTo(BigDecimal.ZERO) == 0;
        if (isZero) {
            for (LocalCurrencyConfigVO locaCur : this.localCurList) {
                boolean mulLocalZero = bal.getMulLoclAmt(locaCur.getBalanceField(MCT.BEGIN)).compareTo(BigDecimal.ZERO) == 0 && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(locaCur.getBalanceLogField(MCT.DEBIT))).compareTo(BigDecimal.ZERO) == 0 && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(locaCur.getBalanceLogField(MCT.CREDIT))).compareTo(BigDecimal.ZERO) == 0;
                if (mulLocalZero) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void updateBalance(long orgId, long bookTypeId, long periodId, LogList<BalanceKey> logList, List<Long> periodIdList, long startPeriodId) {
        Map sumBalData = this.getBalanceData(orgId, bookTypeId, logList, periodIdList, true, this.getSumupTab());
        Params sumParams = new Params();
        this.buildBalParams(orgId, bookTypeId, periodId, logList, true, startPeriodId, sumBalData, sumParams, false);
        Map<String, DataChangeLog> dataId2Log = this.getBalChangeLogger().getDataId2Log(this.getSumupTab(), sumBalData);
        try (TXHandle h = TX.requiresNew((String)(this.getClass().getName() + "update"));){
            try {
                this.storeSumBalData(true, sumParams, dataId2Log);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        logList.clear();
    }

    private DataSet queryDetailBalance(long orgId, long booktypeId, long periodId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid,fbooktypeid,faccountid,0 fassgrpid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id,", new Object[0]);
        sqlBuilder.append("sum(fbeginlocal) fbeginlocal,sum(fbeginfor) fbeginfor,sum(fbeginqty) fbeginqty,sum(fdebitlocal) fdebitlocal,sum(fdebitfor) fdebitfor,", new Object[0]);
        sqlBuilder.append("sum(fdebitqty) fdebitqty,sum(fcreditlocal) fcreditlocal,sum(fcreditfor) fcreditfor,sum(fcreditqty) fcreditqty,", new Object[0]);
        sqlBuilder.append("sum(fyeardebitlocal) fyeardebitlocal,sum(fyeardebitfor) fyeardebitfor,sum(fyeardebitqty) fyeardebitqty,sum(fyearcreditlocal) fyearcreditlocal,", new Object[0]);
        sqlBuilder.append("sum(fyearcreditfor) fyearcreditfor,sum(fyearcreditqty) fyearcreditqty,", new Object[0]);
        for (LocalCurrencyConfigVO configVO : this.localCurList) {
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(",", new Object[0]);
        }
        sqlBuilder.append("sum(fendlocal) fendlocal,sum(fendfor) fendfor,sum(fendqty) fendqty,sum(fcount) fcount from t_gl_balance ", new Object[0]);
        sqlBuilder.append(" where forgid=?", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid=?", new Object[]{booktypeId});
        sqlBuilder.append(" and fperiodid=?", new Object[]{periodId});
        sqlBuilder.append(" group by forgid,fbooktypeid,faccountid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        dataSet = dataSet.orderBy(new String[]{"faccountid", "fcurrencyid", "fmeasureunitid", "fcomassist1id", "fcomassist2id"});
        return dataSet;
    }
}

