/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.balcal.AbstractCalculator;
import kd.fi.gl.balcal.BalanceData;
import kd.fi.gl.balcal.BalanceKey;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.BalanceVersionBalCal;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.CarryPeriodUtil;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.AccountKey;
import kd.sdk.fi.gl.extpoint.bal.BalKey;

public class BalanceCalculator
extends AbstractCalculator<BalanceData, BalanceLog, BalanceKey> {
    private static final String LOG_SQL = "SELECT fid,fperiodid,faccounttableid,faccountid,fassgrpid,fmeasureunitid,fcurrencyid,fdebitfor,fcreditfor,fdebitlocal,fcreditlocal,fdebitqty,fcreditqty,%1$s fcount, %2$s fvoucherid FROM t_gl_balance_log where forgid=? and fbooktypeid=? and fcalculated = '0' ORDER BY fperiodid,faccounttableid,faccountid,fcurrencyid,fassgrpid,%1$s fmeasureunitid";
    private static final String BILL_SQL = "SELECT ve.fid,v.fperiodid,av.faccounttableid,av.fmasterid faccountid,ve.fassgrpid,ve.fmeasureunitid,ve.fcurrencyid,%1$s ve.FORIGINALDEBIT fdebitfor,ve.FORIGINALCREDIT fcreditfor,ve.FLOCALDEBIT fdebitlocal,ve.FLOCALCREDIT fcreditlocal,%2$s case when fentrydc = '1' then fquantity else 0 end fdebitqty,case when fentrydc = '-1' then fquantity else 0 end fcreditqty,1 fcount FROM t_gl_voucher v left outer join t_gl_voucherentry ve ON v.fid = ve.fid left outer join t_bd_account av ON av.fid = ve.faccountid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') ";
    private static final String BILL_SQL_ENHANCE = "SELECT ve.fid,v.fperiodid,av.faccounttableid,av.fmasterid faccountid,ve.fassgrpid,ve.fmeasureunitid,ve.fcurrencyid,%1$s ve.FORIGINALDEBIT fdebitfor,ve.FORIGINALCREDIT fcreditfor,ve.FLOCALDEBIT fdebitlocal,ve.FLOCALCREDIT fcreditlocal,case when fentrydc = '1' then fquantity else 0 end fdebitqty,case when fentrydc = '-1' then fquantity else 0 end fcreditqty,1 fcount FROM t_gl_voucher v left outer join t_gl_voucherentry ve ON v.fid = ve.fid left outer join t_bd_account av ON av.fid = ve.faccountid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') AND ve.forgid = ? AND ve.fperiodid = ? ";
    private static final String UPD_BAL_AMT_SQL = "UPDATE t_gl_balance set fdebitfor = fdebitfor + ?, fcreditfor = fcreditfor + ?, fdebitlocal = fdebitlocal + ?, fcreditlocal = fcreditlocal + ?, fdebitqty = fdebitqty + ?, fcreditqty = fcreditqty + ?, fyeardebitfor = fyeardebitfor + ?, fyearcreditfor = fyearcreditfor + ?, fyeardebitlocal = fyeardebitlocal + ?, fyearcreditlocal = fyearcreditlocal + ?, fyeardebitqty = fyeardebitqty + ?, fyearcreditqty = fyearcreditqty + ?, fendfor=fendfor+?, fendlocal=fendlocal+?, fendqty=fendqty+?,%1$s fcount=fcount+?,fmodifytime=? where fid = ?";
    private static final String UPD_SUM_BAL_AMT_SQL = "UPDATE t_gl_acctbalance set fdebitfor = fdebitfor + ?, fcreditfor = fcreditfor + ?, fdebitlocal = fdebitlocal + ?, fcreditlocal = fcreditlocal + ?, fdebitqty = fdebitqty + ?, fcreditqty = fcreditqty + ?, fyeardebitfor = fyeardebitfor + ?, fyearcreditfor = fyearcreditfor + ?, fyeardebitlocal = fyeardebitlocal + ?, fyearcreditlocal = fyearcreditlocal + ?, fyeardebitqty = fyeardebitqty + ?, fyearcreditqty = fyearcreditqty + ?, fendfor=fendfor+?, fendlocal=fendlocal+?, fendqty=fendqty+?,%1$s fcount=fcount+?,fmodifytime=? where fid = ?";
    private static final String RE_UPD_BAL_AMT_SQL = "UPDATE t_gl_balance set fbeginfor=?, fbeginlocal=?, fbeginqty=?, fdebitfor = ?, fcreditfor = ?, fdebitlocal = ?, fcreditlocal = ?, fdebitqty = ?, fcreditqty = ?, fyeardebitfor = ?, fyearcreditfor =  ?, fyeardebitlocal =  ?, fyearcreditlocal = ?, fyeardebitqty = ?, fyearcreditqty = ?, fendfor=?, fendlocal=?, fendqty=?,%1$s fcount=?,fmodifytime=? where fid = ?";
    private static final String RE_UPD_SUM_BAL_AMT_SQL = "UPDATE t_gl_acctbalance set fbeginfor=?, fbeginlocal=?, fbeginqty=?, fdebitfor = ?, fcreditfor = ?, fdebitlocal = ?, fcreditlocal = ?, fdebitqty = ?, fcreditqty = ?, fyeardebitfor = ?, fyearcreditfor =  ?, fyeardebitlocal =  ?, fyearcreditlocal = ?, fyeardebitqty = ?, fyearcreditqty = ?, fendfor=?, fendlocal=?, fendqty=?,%1$s fcount=?,fmodifytime=? where fid = ?";
    private static final String INSERT_BAL_SQL = "INSERT INTO t_gl_balance(FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FACCOUNTID,FACCOUNTTABLEID,FCURRENCYID,FASSGRPID,FMEASUREUNITID,%1$s FBEGINFOR,FBEGINLOCAL,FBEGINQTY,FDEBITFOR,FCREDITFOR,FDEBITLOCAL,FCREDITLOCAL,FDEBITQTY,FCREDITQTY,FYEARDEBITFOR,FYEARCREDITFOR,FYEARDEBITLOCAL,FYEARCREDITLOCAL,FYEARDEBITQTY,FYEARCREDITQTY,FENDFOR,FENDLOCAL,FENDQTY,%3$s FCOUNT,fmodifytime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? %2$s)";
    private static final String INSERT_SUM_BAL_SQL = "INSERT INTO t_gl_acctbalance(FID,FORGID,FBOOKTYPEID,FPERIODID,FENDPERIODID,FACCOUNTID,FACCOUNTTABLEID,FCURRENCYID,FMEASUREUNITID,%1$s FBEGINFOR,FBEGINLOCAL,FBEGINQTY,FDEBITFOR,FCREDITFOR,FDEBITLOCAL,FCREDITLOCAL,FDEBITQTY,FCREDITQTY,FYEARDEBITFOR,FYEARCREDITFOR,FYEARDEBITLOCAL,FYEARCREDITLOCAL,FYEARDEBITQTY,FYEARCREDITQTY,FENDFOR,FENDLOCAL,FENDQTY,%3$s FCOUNT,fmodifytime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? %2$s)";
    private static final String UPD_CURR_Y_BAL_SQL = "UPDATE t_gl_balance SET FBEGINFOR = FBEGINFOR+?,FBEGINLOCAL = FBEGINLOCAL+?,FBEGINQTY = FBEGINQTY+?,FENDFOR = FENDFOR+?,FENDLOCAL = FENDLOCAL+?,FENDQTY = FENDQTY+?,FYEARDEBITFOR = FYEARDEBITFOR+?,FYEARCREDITFOR = FYEARCREDITFOR+?,FYEARDEBITLOCAL = FYEARDEBITLOCAL+?,FYEARCREDITLOCAL = FYEARCREDITLOCAL+?,FYEARDEBITQTY = FYEARDEBITQTY+?,FYEARCREDITQTY = FYEARCREDITQTY+? %1$s,fmodifytime=? WHERE FID = ?";
    private static final String UPD_CURR_Y_SUM_BAL_SQL = "UPDATE t_gl_acctbalance SET FBEGINFOR = FBEGINFOR+?,FBEGINLOCAL = FBEGINLOCAL+?,FBEGINQTY = FBEGINQTY+?,FENDFOR = FENDFOR+?,FENDLOCAL = FENDLOCAL+?,FENDQTY = FENDQTY+?,FYEARDEBITFOR = FYEARDEBITFOR+?,FYEARCREDITFOR = FYEARCREDITFOR+?,FYEARDEBITLOCAL = FYEARDEBITLOCAL+?,FYEARCREDITLOCAL = FYEARCREDITLOCAL+?,FYEARDEBITQTY = FYEARDEBITQTY+?,FYEARCREDITQTY = FYEARCREDITQTY+? %1$s,fmodifytime=? WHERE FID = ?";
    private static final String UPD_LATER_Y_BAL_SQL = "UPDATE t_gl_balance SET FBEGINFOR = FBEGINFOR+?,FBEGINLOCAL = FBEGINLOCAL+?,FBEGINQTY = FBEGINQTY+?,FENDFOR = FENDFOR+?,FENDLOCAL = FENDLOCAL+?,FENDQTY = FENDQTY+? %1$s,fmodifytime=? WHERE FID = ?";
    private static final String UPD_LATER_Y_SUM_BAL_SQL = "UPDATE t_gl_acctbalance SET FBEGINFOR = FBEGINFOR+?,FBEGINLOCAL = FBEGINLOCAL+?,FBEGINQTY = FBEGINQTY+?,FENDFOR = FENDFOR+?,FENDLOCAL = FENDLOCAL+?,FENDQTY = FENDQTY+? %1$s,fmodifytime=? WHERE FID = ?";
    private static final String VER_BAL_ACCT = "ver-bal-acct";
    private static final String BILL_SQL_ACCOUNT_BEGIN = "SELECT ve.fid,v.fperiodid,av.faccounttableid,av.fmasterid faccountid,ve.fassgrpid,ve.fmeasureunitid,ve.fcurrencyid,%1$s ve.FORIGINALDEBIT fdebitfor,ve.FORIGINALCREDIT fcreditfor,ve.FLOCALDEBIT fdebitlocal,ve.FLOCALCREDIT fcreditlocal,case when fentrydc = '1' then fquantity else 0 end fdebitqty,case when fentrydc = '-1' then fquantity else 0 end fcreditqty,1 fcount FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_bd_account av ON av.fid = ve.faccountid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') and av.fmasterid in (?";
    private static final String BILL_SQL_ACCOUNT_BEGIN_ENHANCE = "SELECT ve.fid,v.fperiodid,av.faccounttableid,av.fmasterid faccountid,ve.fassgrpid,ve.fmeasureunitid,ve.fcurrencyid,%1$s ve.FORIGINALDEBIT fdebitfor,ve.FORIGINALCREDIT fcreditfor,ve.FLOCALDEBIT fdebitlocal,ve.FLOCALCREDIT fcreditlocal,case when fentrydc = '1' then fquantity else 0 end fdebitqty,case when fentrydc = '-1' then fquantity else 0 end fcreditqty,1 fcount FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_bd_account av ON av.fid = ve.faccountid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') AND ve.forgid = ? AND ve.fperiodid = ? and av.fmasterid in (?";
    private static final String BILL_SQL_ACCOUNT_END = ")";
    private static final MCT[] MULBALFIELD = new MCT[]{MCT.BEGIN, MCT.END, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT};
    private static final MCT[] RECALMULBALFIELD = new MCT[]{MCT.BEGIN, MCT.END, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT, MCT.DEBIT, MCT.CREDIT};

    @Override
    protected BalanceLog getLogData(Row rs) {
        BalanceLog log = new BalanceLog();
        log.setDebitFor(rs.getBigDecimal("fdebitfor"));
        log.setCreditFor(rs.getBigDecimal("fcreditfor"));
        log.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
        log.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        log.setDebitQty(rs.getBigDecimal("fdebitqty"));
        log.setCreditQty(rs.getBigDecimal("fcreditqty"));
        log.setCount(rs.getInteger("fcount"));
        this.localCurList.forEach(x -> {
            Collection fields = x.getBalanceLogFields(new MCT[]{MCT.DEBIT, MCT.CREDIT});
            fields.forEach(field -> log.putMulLocalAmt((MetaField)field, rs.getBigDecimal(field.getDbId())));
        });
        return log;
    }

    @Override
    protected BalanceData getBalanceData(Row rs, boolean reCal) {
        BalanceData data = new BalanceData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setAccountTableId(rs.getLong("faccounttableid"));
        data.setOrgId(rs.getLong("forgid"));
        data.setBtId(rs.getLong("fbooktypeid"));
        data.setAcctId(rs.getLong("faccountid"));
        data.setBeginFor(rs.getBigDecimal("fbeginfor"));
        data.setBeginLocal(rs.getBigDecimal("fbeginlocal"));
        data.setBeginQty(rs.getBigDecimal("fbeginqty"));
        data.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
        data.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
        data.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
        data.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
        data.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
        data.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
        data.setEndFor(rs.getBigDecimal("fendfor"));
        data.setEndLocal(rs.getBigDecimal("fendlocal"));
        data.setEndQty(rs.getBigDecimal("fendqty"));
        data.setCount(rs.getInteger("fcount"));
        if (reCal) {
            data.setDebitFor(rs.getBigDecimal("fdebitfor"));
            data.setCreditFor(rs.getBigDecimal("fcreditfor"));
            data.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
            data.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
            data.setDebitQty(rs.getBigDecimal("fdebitqty"));
            data.setCreditQty(rs.getBigDecimal("fcreditqty"));
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            MCT[] selField = reCal ? RECALMULBALFIELD : MULBALFIELD;
            Collection fields = localCur.getBalanceFields(selField);
            for (MetaField field : fields) {
                data.putMulLocalAmt(field, rs.getBigDecimal(field.getDbId()));
            }
        }
        return data;
    }

    @Override
    protected BalanceKey getPK(Row rs) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        int size = this.comassist.size();
        for (int i = 1; i <= size; ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new BalanceKey(rs.getLong("faccounttableid"), rs.getLong("faccountid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("fmeasureunitid"), list);
    }

    @Override
    protected BalanceKey getPK(ResultSet rs) throws SQLException {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new BalanceKey(rs.getLong("faccounttableid"), rs.getLong("faccountid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("fmeasureunitid"), list);
    }

    @Override
    protected BalanceKey getSumupPK(Row rs) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new BalanceKey(rs.getLong("faccounttableid"), rs.getLong("faccountid"), rs.getLong("fcurrencyid"), 0L, rs.getLong("fmeasureunitid"), list);
    }

    @Override
    protected String getAmountSelectFields(boolean reCal) {
        StringBuilder select = new StringBuilder("fbeginfor,fbeginlocal,fbeginqty,fendfor,fendlocal,fendqty,fyeardebitfor,fyeardebitlocal,fyearcreditfor,fyearcreditlocal,fyeardebitqty,fyearcreditqty,");
        if (reCal) {
            select.append("fdebitfor,fcreditfor,fdebitlocal,fcreditlocal,fdebitqty,fcreditqty,");
        }
        this.localCurList.forEach(x -> {
            select.append(x.getSqlBalanceFields(new MCT[]{MCT.BEGIN, MCT.END, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT})).append(",");
            if (reCal) {
                select.append(x.getSqlBalanceFields(new MCT[]{MCT.DEBIT, MCT.CREDIT})).append(",");
            }
        });
        return select.substring(0, select.length() - 1);
    }

    @Override
    protected String[] getKeyFields() {
        StringBuilder sb = new StringBuilder("faccountid, faccounttableid, fcurrencyid, fassgrpid, fmeasureunitid");
        String comFiled = this.getComassistField();
        if (!comFiled.isEmpty()) {
            sb.append(",").append(comFiled, 0, comFiled.length() - 1);
        }
        return sb.toString().split(",");
    }

    @Override
    protected String[] getSumupKeyFields() {
        StringBuilder sb = new StringBuilder("faccountid, faccounttableid, fcurrencyid, fmeasureunitid");
        String comFiled = this.getComassistField();
        if (!comFiled.isEmpty()) {
            sb.append(",").append(comFiled, 0, comFiled.length() - 1);
        }
        return sb.toString().split(",");
    }

    @Override
    protected List<BigDecimal> getNewBalAmtParam(BalanceKey pk, long periodId, BalanceLog logData, BalanceData preBal) {
        boolean hasPreAndSameYear;
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(preBal == null ? BigDecimal.ZERO : preBal.getEndFor());
        param.add(preBal == null ? BigDecimal.ZERO : preBal.getEndLocal());
        param.add(preBal == null ? BigDecimal.ZERO : preBal.getEndQty());
        param.add(logData.getDebitFor());
        param.add(logData.getCreditFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditLocal());
        param.add(logData.getDebitQty());
        param.add(logData.getCreditQty());
        boolean bl = hasPreAndSameYear = preBal != null && periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L;
        if (hasPreAndSameYear) {
            param.add(preBal.getYearDebitFor().add(logData.getDebitFor()));
            param.add(preBal.getYearCreditFor().add(logData.getCreditFor()));
            param.add(preBal.getYearDebitLocal().add(logData.getDebitLocal()));
            param.add(preBal.getYearCreditLocal().add(logData.getCreditLocal()));
            param.add(preBal.getYearDebitQty().add(logData.getDebitQty()));
            param.add(preBal.getYearCreditQty().add(logData.getCreditQty()));
        } else {
            param.add(logData.getDebitFor());
            param.add(logData.getCreditFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditLocal());
            param.add(logData.getDebitQty());
            param.add(logData.getCreditQty());
        }
        BigDecimal endfor = BigDecimal.ZERO;
        BigDecimal endlocal = BigDecimal.ZERO;
        BigDecimal endqty = BigDecimal.ZERO;
        if (preBal != null) {
            endfor = preBal.getEndFor();
            endlocal = preBal.getEndLocal();
            endqty = preBal.getEndQty();
        }
        param.add(endfor.add(logData.getDebitFor()).subtract(logData.getCreditFor()));
        param.add(endlocal.add(logData.getDebitLocal()).subtract(logData.getCreditLocal()));
        param.add(endqty.add(logData.getDebitQty()).subtract(logData.getCreditQty()));
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            param.add(preBal == null ? BigDecimal.ZERO : preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END)));
            param.add(logData.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)));
            param.add(logData.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT)));
            if (hasPreAndSameYear) {
                param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))));
                param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
            } else {
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            }
            BigDecimal endMulLocal = BigDecimal.ZERO;
            if (preBal != null) {
                endMulLocal = preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END));
            }
            param.add(endMulLocal.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
        }
        return param;
    }

    @Override
    protected List<BigDecimal> getUpdateBalAmtParam(long periodId, BalanceLog logData, BalanceData bal, BalanceData preBal, boolean reCal, long startPeriodId) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        if (reCal) {
            param.add(preBal == null ? bal.getBeginFor() : preBal.getEndFor());
            param.add(preBal == null ? bal.getBeginLocal() : preBal.getEndLocal());
            param.add(preBal == null ? bal.getBeginQty() : preBal.getEndQty());
        }
        param.add(logData.getDebitFor());
        param.add(logData.getCreditFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditLocal());
        param.add(logData.getDebitQty());
        param.add(logData.getCreditQty());
        if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
            if (preBal == null) {
                if (periodId != startPeriodId) {
                    param.add(logData.getDebitFor());
                    param.add(logData.getCreditFor());
                    param.add(logData.getDebitLocal());
                    param.add(logData.getCreditLocal());
                    param.add(logData.getDebitQty());
                    param.add(logData.getCreditQty());
                } else {
                    param.add(bal.getYearDebitFor().add(logData.getDebitFor()).subtract(bal.getDebitFor()));
                    param.add(bal.getYearCreditFor().add(logData.getCreditFor()).subtract(bal.getCreditFor()));
                    param.add(bal.getYearDebitLocal().add(logData.getDebitLocal()).subtract(bal.getDebitLocal()));
                    param.add(bal.getYearCreditLocal().add(logData.getCreditLocal()).subtract(bal.getCreditLocal()));
                    param.add(bal.getYearDebitQty().add(logData.getDebitQty()).subtract(bal.getDebitQty()));
                    param.add(bal.getYearCreditQty().add(logData.getCreditQty()).subtract(bal.getCreditQty()));
                }
            } else {
                param.add(preBal.getYearDebitFor().add(logData.getDebitFor()));
                param.add(preBal.getYearCreditFor().add(logData.getCreditFor()));
                param.add(preBal.getYearDebitLocal().add(logData.getDebitLocal()));
                param.add(preBal.getYearCreditLocal().add(logData.getCreditLocal()));
                param.add(preBal.getYearDebitQty().add(logData.getDebitQty()));
                param.add(preBal.getYearCreditQty().add(logData.getCreditQty()));
            }
        } else {
            param.add(logData.getDebitFor());
            param.add(logData.getCreditFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditLocal());
            param.add(logData.getDebitQty());
            param.add(logData.getCreditQty());
        }
        if (reCal) {
            param.add(((BigDecimal)param.get(0)).add(logData.getDebitFor()).subtract(logData.getCreditFor()));
            param.add(((BigDecimal)param.get(1)).add(logData.getDebitLocal()).subtract(logData.getCreditLocal()));
            param.add(((BigDecimal)param.get(2)).add(logData.getDebitQty()).subtract(logData.getCreditQty()));
        } else {
            param.add(logData.getDebitFor().subtract(logData.getCreditFor()));
            param.add(logData.getDebitLocal().subtract(logData.getCreditLocal()));
            param.add(logData.getDebitQty().subtract(logData.getCreditQty()));
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            BigDecimal beginMulLocal = BigDecimal.ZERO;
            if (reCal) {
                beginMulLocal = preBal == null ? bal.getMulLoclAmt(localCur.getBalanceField(MCT.BEGIN)) : preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END));
                param.add(beginMulLocal);
            }
            param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
            param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
                if (preBal == null) {
                    if (periodId != startPeriodId) {
                        param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                        param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
                    } else {
                        param.add(bal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(bal.getMulLoclAmt(localCur.getBalanceField(MCT.DEBIT))));
                        param.add(bal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))).subtract(bal.getMulLoclAmt(localCur.getBalanceField(MCT.CREDIT))));
                    }
                } else {
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))));
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
                }
            } else {
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            }
            if (reCal) {
                param.add(beginMulLocal.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
                continue;
            }
            param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)).subtract(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
        }
        return param;
    }

    @Override
    protected boolean equals(BalanceData bal, BigDecimal[] amount) {
        boolean equals;
        boolean bl = equals = bal.getBeginFor().equals(amount[0]) && bal.getBeginLocal().equals(amount[1]) && bal.getBeginQty().equals(amount[2]) && bal.getDebitFor().equals(amount[3]) && bal.getCreditFor().equals(amount[4]) && bal.getDebitLocal().equals(amount[5]) && bal.getCreditLocal().equals(amount[6]) && bal.getDebitQty().equals(amount[7]) && bal.getCreditQty().equals(amount[8]) && bal.getYearDebitFor().equals(amount[9]) && bal.getYearCreditFor().equals(amount[10]) && bal.getYearDebitLocal().equals(amount[11]) && bal.getYearCreditLocal().equals(amount[12]) && bal.getYearDebitQty().equals(amount[13]) && bal.getYearCreditQty().equals(amount[14]) && bal.getEndFor().equals(amount[15]) && bal.getEndLocal().equals(amount[16]) && bal.getEndQty().equals(amount[17]);
        if (equals) {
            int i = 17;
            for (LocalCurrencyConfigVO locaCur : this.localCurList) {
                boolean mulEq = bal.getMulLoclAmt(locaCur.getBalanceField(MCT.BEGIN)).equals(amount[i++]) && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.DEBIT)).equals(amount[i++]) && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.CREDIT)).equals(amount[i++]) && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_DEBIT)).equals(amount[i++]) && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_CREDIT)).equals(amount[i++]) && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.END)).equals(amount[i++]);
                if (mulEq) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void dealNext(long periodId, BalanceLog logData, Iterator<BalanceData> balIt, Params params, long curBalId, long endPeriodId) {
        if (!balIt.hasNext() && endPeriodId != GLUtil.MAX_PERIOD) {
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, curBalId});
        }
        BigDecimal difffor = logData.getDebitFor().subtract(logData.getCreditFor());
        BigDecimal difflocal = logData.getDebitLocal().subtract(logData.getCreditLocal());
        BigDecimal diffqty = logData.getDebitQty().subtract(logData.getCreditQty());
        HashMap<String, BigDecimal> diff = new HashMap<String, BigDecimal>(this.localCurList.size());
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            diff.put(localCur.getBalanceField(MCT.BEGIN).getMetaId(), logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)).subtract(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
        }
        while (balIt.hasNext()) {
            String key;
            BalanceData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Comparable<BigDecimal>> param = new ArrayList<Comparable<BigDecimal>>();
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            if (periodId / GLUtil.YEAR_PERIOD_L == bal.getPeriodId() / GLUtil.YEAR_PERIOD_L) {
                param.add(logData.getDebitFor());
                param.add(logData.getCreditFor());
                param.add(logData.getDebitLocal());
                param.add(logData.getCreditLocal());
                param.add(logData.getDebitQty());
                param.add(logData.getCreditQty());
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add(logData.getMulLocalAmt(x.getBalanceLogField(MCT.DEBIT)));
                    param.add(logData.getMulLocalAmt(x.getBalanceLogField(MCT.CREDIT)));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateCurrYBalParam(param.toArray());
            } else {
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateLaterYBalParam(param.toArray());
            }
            if (bal.getPeriodId() != endPeriodId) {
                params.addUpdateEndPeriodParam(new Object[]{bal.getPeriodId(), curBalId});
            }
            curBalId = bal.getId();
            endPeriodId = bal.getEndPeriodId();
            if (balIt.hasNext()) continue;
            HashMap<String, Map> acct = (HashMap<String, Map>)ThreadCache.get((Object)VER_BAL_ACCT);
            if (acct == null) {
                acct = new HashMap<String, Map>(10);
                ThreadCache.put((Object)VER_BAL_ACCT, acct);
            }
            if (acct.containsKey(key = bal.getOrgId() + "-" + bal.getBtId() + "-" + bal.getAccountTableId())) {
                long pId = bal.getPeriodId();
                Map map = (Map)acct.get(key);
                List acctIds = map.computeIfAbsent(pId, k -> new ArrayList());
                acctIds.add(bal.getAcctId());
            } else {
                Map map = acct.computeIfAbsent(key, k -> new HashMap());
                ArrayList<Long> acctIds = new ArrayList<Long>(10);
                acctIds.add(bal.getAcctId());
                map.put(bal.getPeriodId(), acctIds);
            }
            if (bal.getEndPeriodId() == GLUtil.MAX_PERIOD.longValue()) continue;
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, bal.getId()});
        }
    }

    @Override
    protected void recalDealNext(long periodId, BalanceLog logData, Iterator<BalanceData> balIt, Params params, BalanceData preBal, long curBalId, long preEndPeriodId) {
        if (!balIt.hasNext() && preEndPeriodId != GLUtil.MAX_PERIOD) {
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, curBalId});
        }
        BigDecimal diffDebitfor = logData.getDebitFor().subtract(preBal.getDebitFor());
        BigDecimal diffDebitlocal = logData.getDebitLocal().subtract(preBal.getDebitLocal());
        BigDecimal diffDebitqty = logData.getDebitQty().subtract(preBal.getDebitQty());
        BigDecimal diffCreditfor = logData.getCreditFor().subtract(preBal.getCreditFor());
        BigDecimal diffCreditlocal = logData.getCreditLocal().subtract(preBal.getCreditLocal());
        BigDecimal diffCreditqty = logData.getCreditQty().subtract(preBal.getCreditQty());
        BigDecimal difffor = diffDebitfor.subtract(diffCreditfor);
        BigDecimal difflocal = diffDebitlocal.subtract(diffCreditlocal);
        BigDecimal diffqty = diffDebitqty.subtract(diffCreditqty);
        HashMap<String, BigDecimal> diff = new HashMap<String, BigDecimal>(this.localCurList.size());
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            BigDecimal difDebit = logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)).subtract(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.DEBIT)));
            BigDecimal difCredit = logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)).subtract(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.CREDIT)));
            diff.put(localCur.getBalanceField(MCT.BEGIN).getMetaId(), difDebit.subtract(difCredit));
            diff.put(localCur.getBalanceField(MCT.DEBIT).getMetaId(), difDebit);
            diff.put(localCur.getBalanceField(MCT.CREDIT).getMetaId(), difCredit);
        }
        while (balIt.hasNext()) {
            String key;
            BalanceData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Comparable<BigDecimal>> param = new ArrayList<Comparable<BigDecimal>>();
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            if (periodId / GLUtil.YEAR_PERIOD_L == bal.getPeriodId() / GLUtil.YEAR_PERIOD_L) {
                param.add(diffDebitfor);
                param.add(diffCreditfor);
                param.add(diffDebitlocal);
                param.add(diffCreditlocal);
                param.add(diffDebitqty);
                param.add(diffCreditqty);
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.DEBIT).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.CREDIT).getMetaId()));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateCurrYBalParam(param.toArray());
            } else {
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateLaterYBalParam(param.toArray());
            }
            if (bal.getPeriodId() != preEndPeriodId) {
                params.addUpdateEndPeriodParam(new Object[]{preEndPeriodId, curBalId});
            }
            curBalId = bal.getId();
            preEndPeriodId = bal.getEndPeriodId();
            if (balIt.hasNext()) continue;
            HashMap<String, Map> acct = (HashMap<String, Map>)ThreadCache.get((Object)VER_BAL_ACCT);
            if (acct == null) {
                acct = new HashMap<String, Map>(10);
                ThreadCache.put((Object)VER_BAL_ACCT, acct);
            }
            if (acct.containsKey(key = bal.getOrgId() + "-" + bal.getBtId() + "-" + bal.getAccountTableId())) {
                long pId = bal.getPeriodId();
                Map map = (Map)acct.get(key);
                List acctIds = map.computeIfAbsent(pId, k -> new ArrayList());
                acctIds.add(bal.getAcctId());
            } else {
                Map map = acct.computeIfAbsent(key, k -> new HashMap());
                ArrayList<Long> acctIds = new ArrayList<Long>(10);
                acctIds.add(bal.getAcctId());
                map.put(bal.getPeriodId(), acctIds);
            }
            if (bal.getEndPeriodId() == GLUtil.MAX_PERIOD.longValue()) continue;
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, bal.getId()});
        }
    }

    @Override
    protected void updateVerBalance() {
        Map acct = (Map)ThreadCache.get((Object)VER_BAL_ACCT);
        BalanceVersionBalCal bal = new BalanceVersionBalCal();
        bal.updateBal(acct, true);
    }

    @Override
    protected void putCache(BalanceData bal) {
        String key;
        HashMap<String, Map> acct = (HashMap<String, Map>)ThreadCache.get((Object)VER_BAL_ACCT);
        if (acct == null) {
            acct = new HashMap<String, Map>(10);
            ThreadCache.put((Object)VER_BAL_ACCT, acct);
        }
        if (acct.containsKey(key = BalanceTransferUtils.getBalTranferKey(bal.getOrgId(), bal.getBtId(), bal.getAccountTableId()))) {
            long periodId = bal.getPeriodId();
            Map map = (Map)acct.get(key);
            List acctIds = map.computeIfAbsent(periodId, k -> new ArrayList());
            acctIds.add(bal.getAcctId());
        } else {
            Map map = acct.computeIfAbsent(key, k -> new HashMap());
            ArrayList<Long> acctIds = new ArrayList<Long>(10);
            acctIds.add(bal.getAcctId());
            map.put(bal.getPeriodId(), acctIds);
        }
    }

    @Override
    protected void putCache(BalanceLog log, BalanceKey bk, long orgId, long btId, long periodId) {
        String key;
        HashMap<String, Map> acct = (HashMap<String, Map>)ThreadCache.get((Object)VER_BAL_ACCT);
        if (acct == null) {
            acct = new HashMap<String, Map>(10);
            ThreadCache.put((Object)VER_BAL_ACCT, acct);
        }
        if (acct.containsKey(key = BalanceTransferUtils.getBalTranferKey(orgId, btId, bk.getAccountTableId()))) {
            Map map = (Map)acct.get(key);
            List acctIds = map.computeIfAbsent(periodId, k -> new ArrayList());
            acctIds.add(bk.getAccountId());
        } else {
            Map map = acct.computeIfAbsent(key, k -> new HashMap());
            ArrayList<Long> acctIds = new ArrayList<Long>(10);
            acctIds.add(bk.getAccountId());
            map.put(periodId, acctIds);
        }
    }

    @Override
    protected DataSet getBillDataSet(long orgId, long bookTypeId, long periodId) {
        return DB.queryDataSet((String)"queryVoucher", (DBRoute)gl, (String)this.getBillSql(orgId), (Object[])this.getBillParams(orgId, bookTypeId, periodId));
    }

    @Override
    protected String[] getOrderBy() {
        String orderBy = String.format("faccountid,fcurrencyid,fassgrpid,%1$s fmeasureunitid", this.getComassistField());
        return orderBy.split(",");
    }

    @Override
    protected String getTab() {
        return "T_GL_BALANCE";
    }

    @Override
    protected String getSumupTab() {
        return "T_GL_ACCTBALANCE";
    }

    @Override
    protected String getLogTab() {
        return "T_GL_BALANCE_LOG";
    }

    @Override
    protected String getLogSql() {
        return String.format(LOG_SQL, this.getComassistField(), this.getMulLocalField());
    }

    private String getMulLocalField() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> sb.append(x.getSqlBalanceFields(new MCT[]{MCT.DEBIT, MCT.CREDIT})).append(","));
        return sb.toString();
    }

    protected Object[] getLogParams(long orgId, long bookTypeId) {
        return new Object[]{orgId, bookTypeId};
    }

    @Override
    protected String getUpdBalSql(boolean reCal) {
        return reCal ? String.format(RE_UPD_BAL_AMT_SQL, this.dynMulLocalUpdateField(reCal)) : String.format(UPD_BAL_AMT_SQL, this.dynMulLocalUpdateField(reCal));
    }

    protected String dynMulLocalUpdateField(boolean reCal) {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> {
            MetaField debit = x.getBalanceField(MCT.DEBIT);
            MetaField credit = x.getBalanceField(MCT.CREDIT);
            MetaField yearDebit = x.getBalanceField(MCT.YEAR_DEBIT);
            MetaField yearCredit = x.getBalanceField(MCT.YEAR_CREDIT);
            MetaField end = x.getBalanceField(MCT.END);
            if (reCal) {
                MetaField begin = x.getBalanceField(MCT.BEGIN);
                sb.append(begin.getDbId()).append(" = ?,").append(debit.getDbId()).append(" = ?,").append(credit.getDbId()).append(" = ?,").append(yearDebit.getDbId()).append(" = ?,").append(yearCredit.getDbId()).append(" = ?,").append(end.getDbId()).append(" = ?,");
            } else {
                sb.append(debit.getDbId()).append(" = ").append(debit.getDbId()).append(" + ?,").append(credit.getDbId()).append(" = ").append(credit.getDbId()).append(" + ?,").append(yearDebit.getDbId()).append(" = ").append(yearDebit.getDbId()).append(" + ?,").append(yearCredit.getDbId()).append(" = ").append(yearCredit.getDbId()).append(" + ?,").append(end.getDbId()).append(" = ").append(end.getDbId()).append(" + ?,");
            }
        });
        return sb.toString();
    }

    @Override
    protected String getInsertBalSql() {
        int size = this.comassist.size() + this.localCurList.size() * 6;
        return String.format(INSERT_BAL_SQL, this.getComassistField(), this.getDynparam(size), this.dynMulLocalField());
    }

    protected String dynMulLocalField() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> {
            MetaField begin = x.getBalanceField(MCT.BEGIN);
            MetaField debit = x.getBalanceField(MCT.DEBIT);
            MetaField credit = x.getBalanceField(MCT.CREDIT);
            MetaField yearDebit = x.getBalanceField(MCT.YEAR_DEBIT);
            MetaField yearCredit = x.getBalanceField(MCT.YEAR_CREDIT);
            MetaField end = x.getBalanceField(MCT.END);
            sb.append(begin.getDbId()).append(",").append(debit.getDbId()).append(",").append(credit.getDbId()).append(",").append(yearDebit.getDbId()).append(",").append(yearCredit.getDbId()).append(",").append(end.getDbId()).append(",");
        });
        return sb.toString();
    }

    @Override
    protected String getUpdCurrYBalSql() {
        return String.format(UPD_CURR_Y_BAL_SQL, this.dynCurYearBalField());
    }

    protected String dynCurYearBalField() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> {
            MetaField begin = x.getBalanceField(MCT.BEGIN);
            MetaField end = x.getBalanceField(MCT.END);
            MetaField yearDebit = x.getBalanceField(MCT.YEAR_DEBIT);
            MetaField yearCredit = x.getBalanceField(MCT.YEAR_CREDIT);
            sb.append(",").append(begin.getDbId()).append(" = ").append(begin.getDbId()).append(" + ?,").append(end.getDbId()).append(" = ").append(end.getDbId()).append(" + ?,").append(yearDebit.getDbId()).append(" = ").append(yearDebit.getDbId()).append(" + ?,").append(yearCredit.getDbId()).append(" = ").append(yearCredit.getDbId()).append(" + ?");
        });
        return sb.substring(0, sb.length());
    }

    @Override
    protected String getUpdLaterYBalSql() {
        return String.format(UPD_LATER_Y_BAL_SQL, this.dynLaterYearBalField());
    }

    protected String dynLaterYearBalField() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> {
            MetaField begin = x.getBalanceField(MCT.BEGIN);
            MetaField end = x.getBalanceField(MCT.END);
            sb.append(",").append(begin.getDbId()).append(" = ").append(begin.getDbId()).append(" + ?,").append(end.getDbId()).append(" = ").append(end.getDbId()).append(" + ?");
        });
        return sb.substring(0, sb.length());
    }

    @Override
    protected String getUpdSumBalSql(boolean reCal) {
        return reCal ? String.format(RE_UPD_SUM_BAL_AMT_SQL, this.dynMulLocalUpdateField(reCal)) : String.format(UPD_SUM_BAL_AMT_SQL, this.dynMulLocalUpdateField(reCal));
    }

    @Override
    protected String getInsertSumBalSql() {
        int size = this.comassist.size() + this.localCurList.size() * 6;
        return String.format(INSERT_SUM_BAL_SQL, this.getComassistField(), this.getDynparam(size), this.dynMulLocalField());
    }

    @Override
    protected String getUpdCurrYSumBalSql() {
        return String.format(UPD_CURR_Y_SUM_BAL_SQL, this.dynCurYearBalField());
    }

    @Override
    protected String getUpdLaterYSumBalSql() {
        return String.format(UPD_LATER_Y_SUM_BAL_SQL, this.dynLaterYearBalField());
    }

    protected String getBillSql(long orgId) {
        return String.format(BILL_SQL, this.getComassistField(), this.getMulVchLocal());
    }

    private String getMulVchLocal() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> {
            MetaField debit = x.getVoucherField(MCT.DEBIT);
            MetaField credit = x.getVoucherField(MCT.CREDIT);
            sb.append(debit.getDbId()).append(",").append(credit.getDbId()).append(",");
        });
        return sb.toString();
    }

    @Override
    protected String getBillSqlAccount(long orgId, int size, boolean enhanceEntryFilter) {
        StringBuilder sb = enhanceEntryFilter ? new StringBuilder(BILL_SQL_ACCOUNT_BEGIN_ENHANCE) : new StringBuilder(BILL_SQL_ACCOUNT_BEGIN);
        for (int i = 1; i < size; ++i) {
            sb.append(",?");
        }
        sb.append(BILL_SQL_ACCOUNT_END);
        String sql = sb.toString();
        return String.format(sql, this.getComassistField());
    }

    @Override
    protected Object[] getBillParams(long orgId, long bookTypeId, long periodId) {
        return new Object[]{orgId, bookTypeId, periodId};
    }

    @Override
    protected LogList<BalanceKey> sumLogList(LogList<BalanceKey> logList) {
        LogList<BalanceKey> logList1 = new LogList<BalanceKey>();
        for (Map.Entry<BalanceKey, Log> entry : logList.getData().entrySet()) {
            BalanceKey key = entry.getKey();
            BalanceKey newKey = new BalanceKey(key.getAccountTableId(), key.getAccountId(), key.getCurrencyId(), 0L, key.getMeasureunitId(), key.comassist);
            logList1.add(newKey, entry.getValue());
        }
        return logList1;
    }

    @Override
    protected Object[] getBillParams(long orgId, long bookTypeId, long periodId, Set<Long> accountMasterids, boolean enhanceEntryFilter) {
        ArrayList<Long> paramList = new ArrayList<Long>(accountMasterids.size() + 3);
        paramList.addAll(Arrays.asList(orgId, bookTypeId, periodId));
        if (enhanceEntryFilter) {
            paramList.add(orgId);
            paramList.add(periodId);
        }
        paramList.addAll(accountMasterids);
        return paramList.toArray();
    }

    @Override
    protected Integer updateBalance(long orgId, long bookTypeId, DataSet ds, boolean reCal, long periodId) {
        long startPeriodId = 0L;
        if (reCal) {
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            QFilter fbt = new QFilter("bookstype", "=", (Object)bookTypeId);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"startperiod, cashinitperiod", (QFilter[])new QFilter[]{forg, fbt});
            startPeriodId = book.getLong("startperiod");
        }
        ArrayList<Long> logIds = new ArrayList<Long>();
        LogList<BalanceKey> logList = new LogList<BalanceKey>();
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        List balPids = null;
        List sumBalPids = null;
        BalanceKey pk = null;
        long period = 0L;
        long pdId = 0L;
        int index = 0;
        for (Row rs : ds) {
            long pd = rs.getLong("fperiodid");
            BalanceKey lpk = this.getPK(rs);
            if (!reCal && rs.getInteger("fcount") > 0) {
                voucherIds.add(rs.getLong("fvoucherid"));
            }
            if (!logList.isEmpty() && (period != pd || !lpk.equals(pk) && logList.size() >= 200)) {
                if (period != pdId) {
                    pdId = period;
                    balPids = PeriodUtil.getAcctBalEndPeriodIdsInRealTime((String)">=", (Long)period, (Long[])new Long[]{orgId});
                    List<Long> loadCarryPeriod = CarryPeriodUtil.loadCarryPeriod(orgId, bookTypeId);
                    if (!loadCarryPeriod.isEmpty()) {
                        balPids.addAll(loadCarryPeriod);
                    }
                    sumBalPids = PeriodUtil.getAcctBalEndPeriodIds((String)">=", (Long)period, (Long[])new Long[]{orgId});
                }
                Tuple<List, Object> periodIdList = new Tuple<List, Object>(balPids, sumBalPids);
                this.updateBalance(orgId, bookTypeId, period, logList, logIds, periodIdList, reCal, startPeriodId, voucherIds);
                voucherIds.clear();
            }
            logList.add(lpk, this.getLogData(rs));
            if (!reCal) {
                logIds.add(rs.getLong("fid"));
            }
            period = pd;
            pk = lpk;
            ++index;
        }
        if (!logList.isEmpty()) {
            if (period != pdId) {
                balPids = PeriodUtil.getAcctBalEndPeriodIdsInRealTime((String)">=", (Long)period, (Long[])new Long[]{orgId});
                List<Long> loadCarryPeriod = CarryPeriodUtil.loadCarryPeriod(orgId, bookTypeId);
                if (!loadCarryPeriod.isEmpty()) {
                    balPids.addAll(loadCarryPeriod);
                }
                sumBalPids = PeriodUtil.getAcctBalEndPeriodIds((String)">=", (Long)period, (Long[])new Long[]{orgId});
            }
            this.updateBalance(orgId, bookTypeId, period, logList, logIds, new Tuple<Object, Object>(balPids, sumBalPids), reCal, startPeriodId, voucherIds);
        }
        this.updateVerBalance();
        return index;
    }

    @Override
    protected boolean isBalZero(BalanceData bal, BalanceLog logData) {
        boolean isZero;
        boolean bl = isZero = bal.getBeginFor().compareTo(BigDecimal.ZERO) == 0 && bal.getBeginLocal().compareTo(BigDecimal.ZERO) == 0 && bal.getBeginQty().compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditFor().add(logData.getCreditFor()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditLocal().add(logData.getCreditLocal()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearCreditQty().add(logData.getCreditQty()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitFor().add(logData.getDebitFor()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitLocal().add(logData.getDebitLocal()).compareTo(BigDecimal.ZERO) == 0 && bal.getYearDebitQty().add(logData.getDebitQty()).compareTo(BigDecimal.ZERO) == 0;
        if (isZero) {
            for (LocalCurrencyConfigVO locaCur : this.localCurList) {
                boolean mulLocalZero = bal.getMulLoclAmt(locaCur.getBalanceField(MCT.BEGIN)).compareTo(BigDecimal.ZERO) == 0 && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(locaCur.getBalanceLogField(MCT.DEBIT))).compareTo(BigDecimal.ZERO) == 0 && bal.getMulLoclAmt(locaCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(locaCur.getBalanceLogField(MCT.CREDIT))).compareTo(BigDecimal.ZERO) == 0;
                if (mulLocalZero) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected BalKey buildExtBalKey(BalanceKey key, long periodId, long endPeriodId, long curBalId) {
        return new AccountKey(key.getAccountId(), key.getAssgrpId(), key.getCurrencyId(), key.getMeasureunitId(), periodId, endPeriodId, curBalId, key.comassist);
    }
}

