/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.gl.balcal.Log;

public class BalanceLog
extends Log {
    private BigDecimal debitFor = BigDecimal.ZERO;
    private BigDecimal debitLocal = BigDecimal.ZERO;
    private BigDecimal creditFor = BigDecimal.ZERO;
    private BigDecimal creditLocal = BigDecimal.ZERO;
    private BigDecimal debitQty = BigDecimal.ZERO;
    private BigDecimal creditQty = BigDecimal.ZERO;
    private Long accassgrp = 0L;
    private Date bizDate;
    private String acccalculated = "1";
    private Map<String, BigDecimal> mulLocalCurAmt = new HashMap<String, BigDecimal>();

    @Override
    public void add(Log log) {
        if (log instanceof BalanceLog) {
            super.add(log);
            BalanceLog data = (BalanceLog)log;
            this.debitFor = this.debitFor.add(data.debitFor);
            this.debitLocal = this.debitLocal.add(data.debitLocal);
            this.creditFor = this.creditFor.add(data.creditFor);
            this.creditLocal = this.creditLocal.add(data.creditLocal);
            this.debitQty = this.debitQty.add(data.debitQty);
            this.creditQty = this.creditQty.add(data.creditQty);
            for (Map.Entry<String, BigDecimal> entry : this.mulLocalCurAmt.entrySet()) {
                this.mulLocalCurAmt.put(entry.getKey(), this.mulLocalCurAmt.get(entry.getKey()).add(data.getMulLocalCurAmt().get(entry.getKey())));
            }
            this.bizDate = data.bizDate;
        }
    }

    @Override
    public void subtract(Log log) {
        super.subtract(log);
        if (log instanceof BalanceLog) {
            BalanceLog data = (BalanceLog)log;
            this.debitFor = this.debitFor.subtract(data.debitFor);
            this.debitLocal = this.debitLocal.subtract(data.debitLocal);
            this.creditFor = this.creditFor.subtract(data.creditFor);
            this.creditLocal = this.creditLocal.subtract(data.creditLocal);
            this.debitQty = this.debitQty.subtract(data.debitQty);
            this.creditQty = this.creditQty.subtract(data.creditQty);
            for (Map.Entry<String, BigDecimal> entry : this.mulLocalCurAmt.entrySet()) {
                this.mulLocalCurAmt.put(entry.getKey(), this.mulLocalCurAmt.get(entry.getKey()).subtract(data.getMulLocalCurAmt().get(entry.getKey())));
            }
        }
    }

    @Override
    public void negate() {
        super.negate();
        this.debitFor = this.debitFor.negate();
        this.debitLocal = this.debitLocal.negate();
        this.creditFor = this.creditFor.negate();
        this.creditLocal = this.creditLocal.negate();
        this.debitQty = this.debitQty.negate();
        this.creditQty = this.creditQty.negate();
        for (Map.Entry<String, BigDecimal> entry : this.mulLocalCurAmt.entrySet()) {
            this.mulLocalCurAmt.put(entry.getKey(), entry.getValue().negate());
        }
    }

    public BigDecimal getDebitFor() {
        return this.debitFor;
    }

    public void setDebitFor(BigDecimal debitFor) {
        this.debitFor = debitFor;
    }

    public BigDecimal getDebitLocal() {
        return this.debitLocal;
    }

    public void setDebitLocal(BigDecimal debitLocal) {
        this.debitLocal = debitLocal;
    }

    public BigDecimal getCreditFor() {
        return this.creditFor;
    }

    public void setCreditFor(BigDecimal creditFor) {
        this.creditFor = creditFor;
    }

    public BigDecimal getCreditLocal() {
        return this.creditLocal;
    }

    public void setCreditLocal(BigDecimal creditLocal) {
        this.creditLocal = creditLocal;
    }

    public BigDecimal getDebitQty() {
        return this.debitQty;
    }

    public void setDebitQty(BigDecimal debitQty) {
        this.debitQty = debitQty;
    }

    public BigDecimal getCreditQty() {
        return this.creditQty;
    }

    public void setCreditQty(BigDecimal creditQty) {
        this.creditQty = creditQty;
    }

    public Long getAccassgrp() {
        return this.accassgrp;
    }

    public void setAccassgrp(Long accassgrp) {
        this.accassgrp = accassgrp;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public String getAcccalculated() {
        return this.acccalculated;
    }

    public void setAcccalculated(String acccalculated) {
        this.acccalculated = acccalculated;
    }

    public Map<String, BigDecimal> getMulLocalCurAmt() {
        return this.mulLocalCurAmt;
    }

    public void setMulLocalCurAmt(Map<String, BigDecimal> mulLocalCurAmt) {
        this.mulLocalCurAmt = mulLocalCurAmt;
    }

    public BigDecimal getMulLocalAmt(MetaField field) {
        return this.mulLocalCurAmt.get(field.getMetaId());
    }

    public void putMulLocalAmt(MetaField field, BigDecimal amt) {
        this.mulLocalCurAmt.put(field.getMetaId(), amt == null ? BigDecimal.ZERO : amt);
    }

    @Override
    public boolean isZero() {
        boolean isMatch = this.mulLocalCurAmt.values().stream().anyMatch(x -> x.compareTo(BigDecimal.ZERO) != 0);
        if (isMatch) {
            return false;
        }
        return super.isZero() && BigDecimal.ZERO.compareTo(this.debitFor) == 0 && BigDecimal.ZERO.compareTo(this.debitLocal) == 0 && BigDecimal.ZERO.compareTo(this.debitQty) == 0 && BigDecimal.ZERO.compareTo(this.creditFor) == 0 && BigDecimal.ZERO.compareTo(this.creditLocal) == 0 && BigDecimal.ZERO.compareTo(this.creditQty) == 0;
    }

    @Override
    public String toString() {
        String temp = "debitFor:" + this.debitFor + ",creditFor:" + this.creditFor + ",debitLocal:" + this.debitLocal + ",creditLocal:" + this.creditLocal + ",debitQty:" + this.debitQty + ",creditQty:" + this.creditQty + "," + super.toString();
        StringBuilder sb = new StringBuilder(temp);
        for (Map.Entry<String, BigDecimal> entry : this.mulLocalCurAmt.entrySet()) {
            sb.append(",").append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }
}

