/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.HashSet;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.AcctBalanceCalculator;
import kd.fi.gl.balcal.ZeroBalanceCarryover;
import kd.fi.gl.business.service.common.BillParamService;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.GLUtil;

public class CalculatorCFs {
    private static final Log logger = LogFactory.getLog((String)"kd.fi.gl.balcal.CalculatorCFs");

    private CalculatorCFs() {
        throw new IllegalStateException("Utility class");
    }

    public static void calculator(long orgId, long bookTypeId, Long periodId, String tableName, boolean isClosePeriod) {
        Runnable runnable = () -> {
            if (DebugTrace.enable()) {
                logger.info("###calculate execute thread");
            }
            LockKey lockKey = "gl_balance_log".equals(tableName) ? LockKey.BalanceCal : LockKey.CashflowCal;
            Lock.tryLock(orgId, bookTypeId, lockKey, () -> {
                Throwable throwable;
                TXHandle txh;
                if (DebugTrace.enable()) {
                    logger.info("###calculate execute getLock");
                }
                int count = 0;
                do {
                    txh = TX.requiresNew();
                    throwable = null;
                    try {
                        try {
                            count = CalculatorCFs.getCalculator(tableName).calculate(orgId, bookTypeId);
                        }
                        catch (Exception e) {
                            txh.markRollback();
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        throwable = e;
                        throw e;
                    }
                    finally {
                        if (txh != null) {
                            if (throwable != null) {
                                try {
                                    txh.close();
                                }
                                catch (Throwable e) {
                                    throwable.addSuppressed(e);
                                }
                            } else {
                                txh.close();
                            }
                        }
                    }
                } while (count > 0);
                if (isClosePeriod) {
                    txh = TX.requiresNew();
                    throwable = null;
                    try {
                        try {
                            boolean value;
                            CalculatorCFs.getCalculator(tableName).reCalculate(orgId, bookTypeId, periodId);
                            CalculatorCFs.clearCalculatedLog(orgId, bookTypeId, periodId, tableName);
                            if ("gl_balance_log".equals(tableName)) {
                                AcctBalanceCalculator cal = new AcctBalanceCalculator();
                                cal.reCalculateAcct(orgId, bookTypeId, periodId);
                            }
                            if ((value = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.bal.changed_endperiod", (boolean)false)) && "gl_balance_log".equals(tableName)) {
                                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
                                ZeroBalanceCarryover.carryoverBal(orgId, bookTypeId, periodId, bookInfo.getStartPeriodId(), false);
                            }
                        }
                        catch (Exception ex) {
                            txh.markRollback();
                            throw ex;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (txh != null) {
                            if (throwable != null) {
                                try {
                                    txh.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                txh.close();
                            }
                        }
                    }
                }
            });
            if (BillParamService.isEnableRealTimeWriteOff() && LockKey.BalanceCal == lockKey) {
                UnAcccurrentUpdateUtil.calculateBalanceLog(orgId, bookTypeId);
            }
        };
        GLThreadService.ayncCallBalance(tableName, runnable);
    }

    private static ICalculator getCalculator(String tableName) {
        return "gl_balance_log".equals(tableName) ? CalculatorFactory.createBalanceCalculator() : CalculatorFactory.createCashflowCalculator();
    }

    private static void clearCalculatedLog(long orgId, long bookTypeId, long periodId, String tableName) {
        int count = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.reserve.balancelog.size", (int)2);
        DynamicObject period = GLUtil.getPreviousPeriod(periodId, count);
        if (Objects.nonNull(period)) {
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            QFilter fbooktype = new QFilter("booktype", "=", (Object)bookTypeId);
            QFilter fperiod = new QFilter("period", "=", (Object)period.getLong("id"));
            QFilter fcalculated = new QFilter("calculated", "=", (Object)"1");
            QFilter acccalculated = new QFilter("acccalculated", "=", (Object)"1");
            try (DataSet set = QueryServiceHelper.queryDataSet((String)"gl_clearlog", (String)tableName, (String)"id", (QFilter[])new QFilter[]{forg, fbooktype, fperiod, fcalculated, acccalculated}, null);){
                HashSet<Long> idSet = new HashSet<Long>(16);
                int index = 0;
                while (set.hasNext()) {
                    idSet.add(set.next().getLong("id"));
                    if (++index < 500) continue;
                    DeleteServiceHelper.delete((String)tableName, (QFilter[])new QFilter("id", "in", idSet).toArray());
                    idSet.clear();
                    index = 0;
                }
                if (!idSet.isEmpty()) {
                    DeleteServiceHelper.delete((String)tableName, (QFilter[])new QFilter("id", "in", idSet).toArray());
                }
            }
        }
    }

    public static void calculatorSync(long orgId, long bookTypeId, Long periodId, String tableName) {
        if (DebugTrace.enable()) {
            logger.info("###calculate execute thread");
        }
        LockKey lockKey = "gl_balance_log".equals(tableName) ? LockKey.BalanceCal : LockKey.CashflowCal;
        Lock.tryLock(orgId, bookTypeId, lockKey, () -> {
            if (DebugTrace.enable()) {
                logger.info("###calculate execute getLock");
            }
            int count = 0;
            do {
                try (TXHandle txh = TX.requiresNew();){
                    try {
                        count = CalculatorCFs.getCalculator(tableName).calculate(orgId, bookTypeId);
                    }
                    catch (Exception e) {
                        txh.markRollback();
                        throw e;
                    }
                }
            } while (count > 0);
        });
    }
}

