/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.balcal.AbstractCalculator;
import kd.fi.gl.balcal.CashflowData;
import kd.fi.gl.balcal.CashflowKey;
import kd.fi.gl.balcal.CashflowLog;
import kd.fi.gl.balcal.CashflowSumLog;
import kd.fi.gl.balcal.CashflowSumLogKey;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.BalKey;
import kd.sdk.fi.gl.extpoint.bal.CashflowItemKey;

public class CashflowCalculator
extends AbstractCalculator<CashflowData, CashflowLog, CashflowKey> {
    private static final String LOG_SQL = "SELECT fid,fperiodid,fvoucherid,fvchentryid,fcfitemid fcfitemid,fassgrpid,fcurrencyid,famount,%1$sfaccountid,ftype,fdc, fcount,fbookeddate FROM t_gl_cashflow_log where forgid=? and fbooktypeid=? and fcalculated = '0' ORDER BY fperiodid,fcfitemid,fcurrencyid,%1$s fassgrpid,faccountid,ftype,fdc";
    private static final String UPD_BAL_AMT_SQL = "UPDATE t_gl_cashflow set famount = famount + ?, fyearamount = fyearamount + ?, fcount=fcount+?,fmodifytime=? where fid = ?";
    private static final String UPD_SUM_BAL_AMT_SQL = "UPDATE t_gl_cashflowsum set famount = famount + ? where fid = ?";
    private static final String RE_UPD_BAL_AMT_SQL = "UPDATE t_gl_cashflow set famount = ?, fyearamount = ?, fcount=?,fmodifytime=? where fid = ?";
    private static final String INSERT_BAL_SQL = "INSERT INTO t_gl_cashflow(fid,forgid,fbooktypeid,fperiodid,fendperiodid,fcfitemid,fcurrencyid,fassgrpid,%1$s famount,fyearamount,fcount,fmodifytime) VALUES (?,?,?,?,?,?,?,?,?,?,?,? %2$s)";
    private static final String INSERT_SUM_BAL_SQL = "INSERT INTO t_gl_cashflowsum(fid,forgid,fbooktypeid,fperiodid,faccountid,fcfitemid,fmaincfassgrpid,ftype,fdc,famount) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SUM_ENTRY_BAL_SQL = "INSERT INTO t_gl_cashflowsumentry(fid,fseq,fvoucherid,fvchentryid,fbookeddate,feamount,fentryid) values (?,?,?,?,?,?,?)";
    private static final String DEL_SUM_ENTRY_BAL_SQL = "DELETE FROM t_gl_cashflowsumentry WHERE fvchentryid ";
    private static final String UPD_CURR_Y_BAL_SQL = "UPDATE t_gl_cashflow SET fyearamount = fyearamount+?,fmodifytime=? WHERE FID = ?";
    private static final String DEL_SUM_BAL_SQL = "DELETE FROM t_gl_cashflowsum s WHERE NOT EXISTS (SELECT 1 FROM t_gl_cashflowsumentry e WHERE s.FID = e.FID);";
    private static final String[] SUM_LOG_KEY = new String[]{"faccountid", "fcfitemid", "fmaincfassgrpid", "ftype", "fdc"};
    String fromVoucher = " FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_bd_accountbooks bk ON v.fbookid = bk.fid ";

    @Override
    protected List<BigDecimal> getUpdateBalAmtParam(long periodId, CashflowLog logData, CashflowData cashflow, CashflowData preCashflow, boolean reCal, long startPeriodId) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>();
        param.add(logData.getAmount());
        if (reCal && (preCashflow == null || periodId / GLUtil.YEAR_PERIOD_L == preCashflow.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
            if (preCashflow == null) {
                if (periodId != startPeriodId) {
                    param.add(logData.getAmount());
                } else {
                    param.add(cashflow.getYearAmount());
                }
            } else {
                param.add(preCashflow.getYearAmount().add(logData.getAmount()));
            }
        } else {
            param.add(logData.getAmount());
        }
        return param;
    }

    @Override
    protected List<BigDecimal> getNewBalAmtParam(CashflowKey pk, long periodId, CashflowLog logData, CashflowData preBal) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>();
        param.add(logData.getAmount());
        if (preBal != null && periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L) {
            param.add(preBal.getYearAmount().add(logData.getAmount()));
        } else {
            param.add(logData.getAmount());
        }
        return param;
    }

    @Override
    protected void dealNext(long periodId, CashflowLog logData, Iterator<CashflowData> balIt, Params params, long curBalId, long endPeriodId) {
        while (balIt.hasNext()) {
            CashflowData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Comparable<BigDecimal>> param = new ArrayList<Comparable<BigDecimal>>();
            if (periodId / GLUtil.YEAR_PERIOD_L != bal.getPeriodId() / GLUtil.YEAR_PERIOD_L) continue;
            param.add(logData.getAmount());
            param.add(DateUtils.now());
            param.add(Long.valueOf(balId));
            params.addUpdateCurrYBalParam(param.toArray());
        }
    }

    @Override
    protected void recalDealNext(long periodId, CashflowLog logData, Iterator<CashflowData> balIt, Params params, CashflowData preBal, long curBalId, long preEndPeriodId) {
        BigDecimal diffBal = logData.getAmount().subtract(preBal.getAmount());
        while (balIt.hasNext()) {
            CashflowData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Comparable<BigDecimal>> param = new ArrayList<Comparable<BigDecimal>>();
            if (periodId / GLUtil.YEAR_PERIOD_L != bal.getPeriodId() / GLUtil.YEAR_PERIOD_L) continue;
            param.add(diffBal);
            param.add(DateUtils.now());
            param.add(Long.valueOf(balId));
            params.addUpdateCurrYBalParam(param.toArray());
        }
    }

    @Override
    protected String getTab() {
        return "T_GL_CASHFLOW";
    }

    @Override
    protected String getSumupTab() {
        return "";
    }

    @Override
    protected String getLogTab() {
        return "T_GL_CASHFLOW_LOG";
    }

    @Override
    protected String getLogSql() {
        return String.format(LOG_SQL, this.getComassistField());
    }

    @Override
    protected String[] getOrderBy() {
        String orderBy = String.format("fcfitemid,%1$s fassgrpid", this.getComassistField());
        return orderBy.split(",");
    }

    @Override
    protected String[] getKeyFields() {
        StringBuilder sb = new StringBuilder("fcfitemid,fcurrencyid,fassgrpid");
        String comFiled = this.getComassistField();
        if (!comFiled.isEmpty()) {
            sb.append(",").append(comFiled.substring(0, comFiled.length() - 1));
        }
        return sb.toString().split(",");
    }

    @Override
    protected String[] getSumupKeyFields() {
        StringBuilder sb = new StringBuilder("fcfitemid,fcurrencyid");
        String comFiled = this.getComassistField();
        if (!comFiled.isEmpty()) {
            sb.append(",").append(comFiled.substring(0, comFiled.length() - 1));
        }
        return sb.toString().split(",");
    }

    @Override
    protected String getAmountSelectFields(boolean reCal) {
        return "fyearamount,famount";
    }

    @Override
    protected String getUpdBalSql(boolean reCal) {
        return reCal ? RE_UPD_BAL_AMT_SQL : UPD_BAL_AMT_SQL;
    }

    @Override
    protected String getInsertBalSql() {
        return String.format(INSERT_BAL_SQL, this.getComassistField(), this.getDynparam(this.comassist.size()));
    }

    @Override
    protected String getUpdCurrYBalSql() {
        return UPD_CURR_Y_BAL_SQL;
    }

    private String getMainSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ve.fid, v.fperiodid, cfi.fmasterid fcfitemid,ve.fmaincfassgrpid fassgrpid,bk.fbasecurrencyid fcurrencyid,ve.fmaincfamount famount ,").append(this.getComassistField()).append("1 fcount");
        sql.append(this.fromVoucher);
        sql.append(" INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fmaincfitemid ");
        sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') AND ve.fmaincfitemid<>0 ");
        return sql.toString();
    }

    private String getSuppcfSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ve.fid, v.fperiodid, cfi.fmasterid fcfitemid, 0 fassgrpid, bk.fbasecurrencyid fcurrencyid, ve.fsuppcfamount famount ,").append(this.getComassistField()).append("1 fcount");
        sql.append(this.fromVoucher);
        sql.append(" INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fsuppcfitemid ");
        sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C') AND ve.fsuppcfitemid<>0");
        return sql.toString();
    }

    private String getProfitSql(long cashProfitId) {
        StringBuilder sql = new StringBuilder();
        if (cashProfitId != 0L) {
            sql.append(" SELECT ve.fid, v.fperiodid, ").append(cashProfitId).append(" fcfitemid, 0 fassgrpid, bk.fbasecurrencyid fcurrencyid, flocalcredit-ve.flocaldebit famount ,").append(this.getComassistField()).append("1 fcount");
            sql.append(this.fromVoucher);
            sql.append(" INNER JOIN t_bd_account ba ON ba.fid=ve.faccountid ");
            sql.append(" INNER JOIN t_bd_accounttype bat ON bat.fid=ba.faccounttypeid ");
            sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid=? AND v.fbillstatus in ('B','C')");
            sql.append(" AND v.fsourcetype <> '1' AND bat.faccounttype = '4'");
        }
        return sql.toString();
    }

    @Override
    protected DataSet getBillDataSet(long orgId, long bookTypeId, long periodId) {
        Object[] billParams = this.getBillParams(orgId, bookTypeId, periodId);
        DBRoute route = DBRoute.of((String)"gl");
        DataSet main = DB.queryDataSet((String)"getMainCf", (DBRoute)route, (String)this.getMainSql(), (Object[])billParams);
        DataSet supp = DB.queryDataSet((String)"getSuppCf", (DBRoute)route, (String)this.getSuppcfSql(), (Object[])billParams);
        main = main.union(supp);
        long cashProfitId = this.getCashProfit(orgId);
        if (cashProfitId > 0L) {
            DataSet cashProfit = DB.queryDataSet((String)"getCashProfitCf", (DBRoute)route, (String)this.getProfitSql(cashProfitId), (Object[])billParams);
            main = main.union(cashProfit);
        }
        return main;
    }

    @Override
    protected Object[] getBillParams(long orgId, long bookTypeId, long periodId) {
        return new Object[]{orgId, bookTypeId, periodId};
    }

    protected Long getCashProfit(long orgId) {
        QFilter fid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        QFilter cashProfitQf = new QFilter("isprefit", "=", (Object)"1");
        DynamicObject cashProfitDb = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])new QFilter[]{fid, cashProfitQf});
        if (cashProfitDb != null) {
            return cashProfitDb.getLong("masterid");
        }
        return 0L;
    }

    @Override
    protected String getUpdLaterYBalSql() {
        return null;
    }

    @Override
    protected CashflowKey getSumupPK(Row rs) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new CashflowKey(rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), 0L, list);
    }

    @Override
    protected CashflowKey getPK(ResultSet rs) throws SQLException {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new CashflowKey(rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), list);
    }

    @Override
    protected CashflowKey getPK(Row rs) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        return new CashflowKey(rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), list);
    }

    private CashflowSumLogKey getSumLogPk(Row rs, boolean reCal) {
        ArrayList<Long> list = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassist.size(); ++i) {
            list.add(rs.getLong("fcomassist" + i + "id"));
        }
        if (reCal) {
            return new CashflowSumLogKey(rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), 0L, "", "", list);
        }
        return new CashflowSumLogKey(rs.getLong("fcfitemid"), rs.getLong("fcurrencyid"), rs.getLong("fassgrpid"), rs.getLong("faccountid"), rs.getString("ftype"), rs.getString("fdc"), list);
    }

    private CashflowSumLogKey getCFSumLogPk(Row rs) {
        return new CashflowSumLogKey(rs.getLong("fcfitemid"), 0L, rs.getLong("fassgrpid"), rs.getLong("faccountid"), rs.getString("ftype"), rs.getString("fdc"), Collections.emptyList());
    }

    private CashflowSumLog getSumLogData(Row rs, boolean reCal) {
        CashflowSumLog log = new CashflowSumLog();
        log.setAmount(rs.getBigDecimal("famount"));
        Integer count = rs.getInteger("fcount");
        log.setCount(count);
        if (!reCal) {
            if (count > 0) {
                log.addVoucherInfo(rs.getLong("fvoucherid"), rs.getLong("fvchentryid"), rs.getDate("fbookeddate"), rs.getBigDecimal("famount"));
            } else if (count < 0) {
                log.delVoucherId(rs.getLong("fvoucherid"), rs.getLong("fvchentryid"));
            }
        }
        return log;
    }

    @Override
    protected CashflowLog getLogData(Row rs) {
        CashflowLog log = new CashflowLog();
        log.setAmount(rs.getBigDecimal("famount"));
        log.setCount(rs.getInteger("fcount"));
        return log;
    }

    @Override
    protected CashflowData getBalanceData(Row rs, boolean reCal) {
        CashflowData data = new CashflowData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setEndPeriodId(rs.getLong("fendperiodid"));
        data.setAmount(rs.getBigDecimal("famount"));
        data.setYearAmount(rs.getBigDecimal("fyearamount"));
        data.setCount(rs.getInteger("fcount"));
        return data;
    }

    protected CashflowData getSumData(Row rs) {
        CashflowData data = new CashflowData(rs.getLong("fid"));
        data.setPeriodId(rs.getLong("fperiodid"));
        data.setAmount(rs.getBigDecimal("famount"));
        data.setCount(rs.getInteger("fcount"));
        data.setAcctId(rs.getLong("faccountid"));
        return data;
    }

    @Override
    protected boolean equals(CashflowData bal, BigDecimal[] amount) {
        return bal.getAmount().equals(amount[0]) && bal.getYearAmount().equals(amount[1]);
    }

    @Override
    protected Integer updateBalance(long orgId, long bookTypeId, DataSet ds, boolean reCal, long periodId) {
        long startPeriodId = 0L;
        if (reCal) {
            QFilter fbt;
            QFilter forg = new QFilter("org", "=", (Object)orgId);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"startperiod, cashinitperiod", (QFilter[])new QFilter[]{forg, fbt = new QFilter("bookstype", "=", (Object)bookTypeId)});
            long cashInitPid = book.getLong("cashinitperiod");
            if (periodId < cashInitPid || cashInitPid == 0L) {
                return 0;
            }
            startPeriodId = cashInitPid;
        }
        ArrayList<Long> logIds = new ArrayList<Long>();
        LogList<CashflowKey> logSumList = new LogList<CashflowKey>();
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        List balPids = null;
        ArrayList sumBalPids = null;
        CashflowKey pk = null;
        long period = 0L;
        long pdId = 0L;
        int index = 0;
        for (Row rs : ds) {
            long pd = rs.getLong("fperiodid");
            CashflowKey lpk = this.getPK(rs);
            CashflowSumLogKey slpk = this.getSumLogPk(rs, reCal);
            if (!logSumList.isEmpty() && (period != pd || !lpk.equals(pk) && logSumList.size() >= 200)) {
                if (period != pdId) {
                    pdId = period;
                    balPids = PeriodUtil.getCashflowAvailableEndPeriodIds((String)">=", (Long)period, (Long[])new Long[]{orgId});
                    sumBalPids = new ArrayList();
                }
                this.updateBalance(orgId, bookTypeId, period, logSumList, (List<Long>)logIds, new Tuple<List<Long>, List<Long>>(balPids, sumBalPids), reCal, startPeriodId, (Set<Long>)voucherIds);
                voucherIds.clear();
            }
            logSumList.add(slpk, this.getSumLogData(rs, reCal));
            if (!reCal) {
                logIds.add(rs.getLong("fid"));
            }
            period = pd;
            pk = lpk;
            ++index;
        }
        if (!logSumList.isEmpty()) {
            if (period != pdId) {
                balPids = PeriodUtil.getCashflowAvailableEndPeriodIds((String)">=", (Long)period, (Long[])new Long[]{orgId});
                sumBalPids = new ArrayList();
            }
            this.updateBalance(orgId, bookTypeId, period, logSumList, (List<Long>)logIds, (Tuple<List<Long>, List<Long>>)new Tuple<Object, Object>(balPids, sumBalPids), reCal, startPeriodId, (Set<Long>)voucherIds);
        }
        this.updateVerBalance();
        return index;
    }

    @Override
    protected void updateBalance(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList, List<Long> logIds, Tuple<List<Long>, List<Long>> periodList, boolean reCal, long startPeriodId, Set<Long> voucherIds) {
        LogList<CashflowKey> sumDetailLogList;
        this.getBalChangeLogger().recordDataChangeSource(this.getTab(), logIds);
        Params balparams = new Params();
        LogList<CashflowKey> sumLogList = this.sumLogList(logList);
        Map<String, DataChangeLog> dataId2Log = new HashMap<String, DataChangeLog>(8);
        if (!sumLogList.isEmpty()) {
            Map sumBalData = this.getBalanceData(orgId, bookTypeId, sumLogList, (List)periodList.item1, reCal, this.getTab());
            dataId2Log = this.getBalChangeLogger().getDataId2Log(this.getTab(), sumBalData);
            this.buildBalParams(orgId, bookTypeId, periodId, sumLogList, reCal, startPeriodId, sumBalData, balparams, true);
        }
        Params detailarams = new Params();
        if (!reCal && !(sumDetailLogList = this.sumDetailLogList(logList, orgId, bookTypeId, periodId)).isEmpty()) {
            Map<CashflowSumLogKey, CashflowData> data = this.getCashSumData(orgId, bookTypeId, periodId, sumDetailLogList);
            this.buildDetailParams(orgId, bookTypeId, periodId, sumDetailLogList, detailarams, data);
        }
        Tuple<Params, Params> tuple = new Tuple<Params, Params>(balparams, detailarams);
        this.storeDB(tuple, logIds, reCal, voucherIds, dataId2Log);
        logList.clear();
    }

    private LogList<CashflowKey> sumDetailLogList(LogList<CashflowKey> logList, long orgId, long bookTypeId, long periodId) {
        LogList<CashflowKey> logList1 = new LogList<CashflowKey>();
        for (Map.Entry<CashflowKey, Log> entry : logList.getData().entrySet()) {
            CashflowSumLogKey key = (CashflowSumLogKey)entry.getKey();
            Long accountId = key.getAccountId();
            if (accountId == null || accountId == 0L) continue;
            CashflowSumLogKey newKey = new CashflowSumLogKey(key.getCfItemId(), 0L, key.getAssgrpId(), accountId, key.getType(), key.getDc(), Collections.emptyList());
            logList1.add(newKey, entry.getValue());
        }
        return logList1;
    }

    @Override
    protected LogList<CashflowKey> sumLogList(LogList<CashflowKey> logList) {
        LogList<CashflowKey> logList1 = new LogList<CashflowKey>();
        for (Map.Entry<CashflowKey, Log> entry : logList.getData().entrySet()) {
            CashflowKey key = entry.getKey();
            if (key.getCfItemId() == 0L) continue;
            CashflowKey newKey = new CashflowKey(key.getCfItemId(), key.getCurrencyId(), key.getAssgrpId(), key.comassist);
            CashflowLog log = new CashflowLog();
            log.setAmount(((CashflowSumLog)entry.getValue()).getAmount());
            log.setCount(entry.getValue().getCount());
            logList1.add(newKey, log);
        }
        return logList1;
    }

    private void buildDetailParams(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList, Params params, Map<CashflowSumLogKey, CashflowData> data) {
        for (Map.Entry<CashflowKey, Log> logEntry : logList.getData().entrySet()) {
            Map<Long, List<Object[]>> addVouchers;
            CashflowSumLogKey key = (CashflowSumLogKey)logEntry.getKey();
            CashflowSumLog value = (CashflowSumLog)logEntry.getValue();
            CashflowData cashflowData = data.get(key);
            long fid = 0L;
            if (cashflowData != null) {
                fid = cashflowData.getId();
                params.getUpdateBalParams().add(new Object[]{value.getAmount(), fid});
                if (!value.getDelvoucherIds().isEmpty()) {
                    params.addDelVchParams(new Object[]{fid, value.getDelvoucherIds().keySet()});
                }
            } else {
                fid = DB.genLongId((String)"t_gl_cashflowsum");
                params.getNewBalParams().add(new Object[]{fid, orgId, bookTypeId, periodId, key.getAccountId(), key.getCfItemId(), key.getAssgrpId(), key.getType(), key.getDc(), value.getAmount()});
            }
            if ((addVouchers = value.getAddVoucherInfos()).isEmpty()) continue;
            for (Map.Entry<Long, List<Object[]>> entry : addVouchers.entrySet()) {
                Long vid = entry.getKey();
                List<Object[]> eInfos = entry.getValue();
                long[] entryIds = DB.genGlobalLongIds((int)eInfos.size());
                int i = 0;
                for (Object[] e : eInfos) {
                    params.getAddVchParams().add(new Object[]{fid, 0, vid, e[0], e[1], e[2], entryIds == null ? (long)i : entryIds[i]});
                    ++i;
                }
            }
        }
    }

    @Override
    protected void storeDB(Tuple<Params, Params> params, List<Long> logIds, boolean reCal, Set<Long> voucherIds, Map<String, DataChangeLog> dataId2Log) {
        try (TXHandle h = TX.requiresNew((String)(this.getClass().getName() + "update"));){
            try {
                this.storeBalData(reCal, (Params)params.item1, dataId2Log);
                this.storeDetailBal((Params)params.item2);
                this.setCalculateStatus(logIds);
                if (!voucherIds.isEmpty()) {
                    TempVoucherService.deleteByIds((Long[])voucherIds.toArray(new Long[0]));
                    TempVoucherCFService.deleteByIds((Long[])voucherIds.toArray(new Long[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
            finally {
                logIds.clear();
            }
        }
    }

    private void storeDetailBal(Params param) {
        List<Object[]> delVchParams;
        if (!param.getNewBalParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)INSERT_SUM_BAL_SQL, param.getNewBalParams());
        }
        if (!param.getUpdateBalParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)UPD_SUM_BAL_AMT_SQL, param.getUpdateBalParams());
        }
        if (!(delVchParams = param.getDelVchParams()).isEmpty()) {
            for (Object[] params : delVchParams) {
                SqlBuilder builder = new SqlBuilder();
                builder.appendIn(DEL_SUM_ENTRY_BAL_SQL, new ArrayList((Set)params[1]));
                builder.append(" and fid = ? ", new Object[]{params[0]});
                DB.execute((DBRoute)gl, (SqlBuilder)builder);
            }
        }
        if (!param.getAddVchParams().isEmpty()) {
            DB.executeBatch((DBRoute)gl, (String)INSERT_SUM_ENTRY_BAL_SQL, param.getAddVchParams());
        }
        DB.execute((DBRoute)gl, (String)DEL_SUM_BAL_SQL);
    }

    protected Map<CashflowSumLogKey, CashflowData> getCashSumData(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList) {
        SqlBuilder builder = this.getSumlogSqlBuilder(orgId, bookTypeId, periodId, logList);
        DataSet ds = DB.queryDataSet((String)"CashflowCalculator.getCashSumData", (DBRoute)gl, (SqlBuilder)builder);
        HashMap<CashflowSumLogKey, CashflowData> data = new HashMap<CashflowSumLogKey, CashflowData>(16);
        for (Row rs : ds) {
            CashflowSumLogKey key = this.getCFSumLogPk(rs);
            data.put(key, this.getSumData(rs));
        }
        return data;
    }

    private SqlBuilder getSumlogSqlBuilder(long orgId, long bookTypeId, long periodId, LogList<CashflowKey> logList) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,forgid,fbooktypeid,fperiodid,faccountid,fcfitemid,fmaincfassgrpid fassgrpid,ftype,fdc,famount,1 fcount from t_gl_cashflowsum where ", new Object[0]);
        builder.append(" forgid = ?", new Object[]{orgId});
        builder.append(" and fbooktypeid = ?", new Object[]{bookTypeId});
        builder.append(" and fperiodid =?", new Object[]{periodId});
        String[] keys = this.getSumLogkeyField();
        Object[] param = new Object[5];
        for (int i = 0; i < keys.length; ++i) {
            param[i] = new HashSet();
        }
        for (CashflowKey logKey : logList.getData().keySet()) {
            int i = 0;
            for (Object val : ((CashflowSumLogKey)logKey).getKeyValue()) {
                ((Set)param[i]).add(val);
                ++i;
            }
        }
        for (int j = 0; j < keys.length; ++j) {
            builder.append(" and ", new Object[0]);
            builder.appendIn(keys[j], ((Set)param[j]).toArray());
        }
        return builder;
    }

    private String[] getSumLogkeyField() {
        return SUM_LOG_KEY;
    }

    @Override
    protected boolean isBalZero(CashflowData bal, CashflowLog logData) {
        return bal.getYearAmount().subtract(bal.getAmount()).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected BalKey buildExtBalKey(CashflowKey key, long periodId, long endPeriodId, long curBalId) {
        return new CashflowItemKey(key.getCfItemId(), key.getAssgrpId(), key.getCurrencyId(), periodId, endPeriodId, curBalId, key.comassist);
    }

    @Override
    protected void updateVerBalance() {
    }

    @Override
    protected void putCache(CashflowData bal) {
    }

    @Override
    protected void putCache(CashflowLog bal, CashflowKey key, long orgId, long bookTypeId, long periodId) {
    }

    @Override
    protected Object[] getBillParams(long orgId, long bookTypeId, long periodId, Set<Long> accountMasterIds, boolean enhanceEntryFilter) {
        return null;
    }

    @Override
    protected String getBillSqlAccount(long orgId, int size, boolean enhanceEntryFilter) {
        return null;
    }
}

