/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import kd.fi.gl.balcal.Log;

public class CashflowLog
extends Log {
    private BigDecimal amount = BigDecimal.ZERO;

    @Override
    public void add(Log log) {
        if (log instanceof CashflowLog) {
            super.add(log);
            CashflowLog data = (CashflowLog)log;
            this.amount = this.amount.add(data.amount);
        }
    }

    @Override
    public void subtract(Log log) {
        super.subtract(log);
        if (log instanceof CashflowLog) {
            CashflowLog data = (CashflowLog)log;
            this.amount = this.amount.subtract(data.amount);
        }
    }

    @Override
    public void negate() {
        super.negate();
        this.amount = this.amount.negate();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Override
    public boolean isZero() {
        return super.isZero() && BigDecimal.ZERO.compareTo(this.amount) == 0;
    }

    @Override
    public String toString() {
        return "amount:" + this.amount + "," + super.toString();
    }
}

