/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.InitBalance;

public class InitBalanceKey {
    private int hashcode;
    private long org;
    private long bookType;
    private long account;
    private long assgrp;
    private long currency;
    private long measureunit;
    private long[] comAssistIDs;

    public InitBalanceKey(long org, long bookType, long account, long assgrp, long currency, long measureunit, long ... comAssistIDs) {
        this.org = org;
        this.bookType = bookType;
        this.account = account;
        this.assgrp = assgrp;
        this.currency = currency;
        this.measureunit = measureunit;
        this.comAssistIDs = comAssistIDs;
    }

    public InitBalanceKey(DynamicObject dyn) {
        this.org = dyn.getLong(InitBalance.id_("org"));
        this.bookType = dyn.getLong(InitBalance.id_("booktype"));
        this.account = dyn.getLong("account.masterid");
        this.assgrp = dyn.getLong(InitBalance.id_("assgrp"));
        this.currency = dyn.getLong(InitBalance.id_("currency"));
        this.measureunit = dyn.getLong(InitBalance.id_("measureunit"));
        Object acctTable = dyn.get("accounttable");
        this.comAssistIDs = ComAssistTable.get(acctTable instanceof Long ? (Long)acctTable : (Long)((DynamicObject)acctTable).getPkValue()).getAllCommonAssistKeys().stream().map(arg_0 -> ((DynamicObject)dyn).get(arg_0)).map(value -> value == null ? Long.valueOf(0L) : value).mapToLong(value -> value instanceof Long ? (Long)value : (Long)((DynamicObject)value).getPkValue()).toArray();
    }

    public int hashCode() {
        int result = this.hashcode;
        if (result == 0) {
            result = Long.hashCode(this.account);
            result = 31 * result + Long.hashCode(this.assgrp);
            result = 31 * result + Long.hashCode(this.currency);
            result = 31 * result + Long.hashCode(this.measureunit);
            result = 31 * result + Long.hashCode(this.org);
            result = 31 * result + Long.hashCode(this.bookType);
            for (long comAssistID : this.comAssistIDs) {
                result = 31 * result + Long.hashCode(comAssistID);
            }
            this.hashcode = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof InitBalanceKey)) {
            return false;
        }
        InitBalanceKey bal = (InitBalanceKey)obj;
        boolean bl = equals = bal.account == this.account && bal.assgrp == this.assgrp && bal.currency == this.currency && bal.measureunit == this.measureunit && bal.org == this.org && bal.bookType == this.bookType;
        if (!equals || this.comAssistIDs.length != bal.comAssistIDs.length) {
            return false;
        }
        for (int i = 0; i < this.comAssistIDs.length; ++i) {
            if (this.comAssistIDs[i] == bal.comAssistIDs[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "org:" + this.org + ";bookType:" + this.bookType + ";account:" + this.account + ";assgrp:" + this.assgrp + ";currency:" + this.currency + ";measureunit:" + this.measureunit + ";comassists:" + Arrays.toString(this.comAssistIDs);
    }

    public long getOrg() {
        return this.org;
    }

    public long getBookType() {
        return this.bookType;
    }

    public long getAccount() {
        return this.account;
    }

    public long getAssgrp() {
        return this.assgrp;
    }

    public long getCurrency() {
        return this.currency;
    }

    public long getMeasureunit() {
        return this.measureunit;
    }

    public long[] getComAssistIDs() {
        return this.comAssistIDs;
    }
}

