/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.CarryPeriodUtil;
import kd.fi.gl.util.GLUtil;

public class ZeroBalanceCarryover {
    private static final Log LOGGER = LogFactory.getLog((String)"kd.fi.gl.balcal.ZeroBalanceCarryover");
    private static final String UPDATE = "update t_gl_balance set fendperiodid=? where fid = ? ";

    public static void carryoverBal(long orgId, long bookTypeId, long periodId, long startPeriod, boolean tryLock) {
        LOGGER.info("carryover_periodId_startperiod:{}-{}", (Object)periodId, (Object)startPeriod);
        if (periodId == 0L) {
            return;
        }
        long curYearMaxPeriod = GLUtil.getCurYearMaxPeriod(periodId);
        if (periodId != curYearMaxPeriod) {
            return;
        }
        DynamicObject curYearMinPeriod = GLUtil.getCurYearMinPeriod(periodId);
        if (curYearMinPeriod.getLong("id") <= startPeriod || curYearMinPeriod.getInt("periodnumber") != 1) {
            return;
        }
        if (tryLock) {
            if (!Lock.tryLock(orgId, bookTypeId, LockKey.BalanceCal, () -> ZeroBalanceCarryover.execute(orgId, bookTypeId, curYearMinPeriod))) {
                LOGGER.info("orgId:{},bookType:{} is operating...", (Object)orgId, (Object)bookTypeId);
            }
        } else {
            ZeroBalanceCarryover.execute(orgId, bookTypeId, curYearMinPeriod);
        }
    }

    private static void execute(long orgId, long bookTypeId, DynamicObject curYearMinPeriod) {
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbooktype = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter fendPeriod = new QFilter("endperiod", "=", (Object)GLUtil.MAX_PERIOD);
        QFilter fperiod = new QFilter("period", "<", (Object)curYearMinPeriod.getLong("id"));
        String field = "id,endfor,endlocal,endqty";
        ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
        boolean carryPeriod = false;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ZeroBalanceTransfer.execute", (String)"gl_balance", (String)field, (QFilter[])new QFilter[]{forg, fbooktype, fperiod, fendPeriod}, null);){
            for (Row row : dataSet) {
                if (row.getBigDecimal("endfor").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("endlocal").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("endqty").compareTo(BigDecimal.ZERO) == 0) {
                    params.add(new Object[]{curYearMinPeriod.getLong("id"), row.getLong("id")});
                }
                if (params.size() < 1000) continue;
                carryPeriod = true;
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)UPDATE, params);
                params.clear();
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)UPDATE, params);
                carryPeriod = true;
            }
        }
        if (carryPeriod) {
            CarryPeriodUtil.saveCarryPeriod(orgId, bookTypeId, curYearMinPeriod.getLong("id"));
        }
    }
}

