/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.acctpullupbalupdate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.balcal.acctpullupbalupdate.AcctBalKey;
import kd.fi.gl.balcal.acctpullupbalupdate.AcctBalanceData;
import kd.fi.gl.util.GLUtil;

public class AcctBalUpdateProcess {
    private long orgId;
    private long booktypeId;
    private Collection<LocalCurrencyConfigVO> configVOS;

    public AcctBalUpdateProcess(long orgId, long booktypeId) {
        this.orgId = orgId;
        this.booktypeId = booktypeId;
        this.configVOS = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)booktypeId);
    }

    public void update() {
        SqlBuilder del = new SqlBuilder();
        del.append("delete from t_gl_acctbalance where forgid=?", new Object[]{this.orgId});
        del.append(" and fbooktypeid=?", new Object[]{this.booktypeId});
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)del);
        DataSet dataSet = this.queryBalance1(this.orgId, this.booktypeId);
        HashMap<AcctBalKey, List<AcctBalanceData>> map = new HashMap<AcctBalKey, List<AcctBalanceData>>();
        for (Row row : dataSet) {
            AcctBalKey key = new AcctBalKey(row.getLong("faccountid"), row.getLong("faccounttableid"), row.getLong("fcurrencyid"), row.getLong("fmeasureunitid"), row.getLong("fcomassist1id"), row.getLong("fcomassist2id"));
            ArrayList<AcctBalanceData> list = (ArrayList<AcctBalanceData>)map.get(key);
            if (list == null) {
                if (map.size() > 1000) {
                    this.processBalData(this.orgId, this.booktypeId, map);
                    map.clear();
                }
                list = new ArrayList<AcctBalanceData>();
                AcctBalanceData data = this.buildData(row);
                list.add(data);
                map.put(key, list);
                continue;
            }
            list.add(this.buildData(row));
        }
        if (!map.isEmpty()) {
            this.processBalData(this.orgId, this.booktypeId, map);
        }
    }

    private DataSet queryBalance1(long orgId, long booktypeId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid,fbooktypeid,faccountid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id,fperiodid,", new Object[0]);
        sqlBuilder.append("sum(fbeginlocal) fbeginlocal,sum(fbeginfor) fbeginfor,sum(fbeginqty) fbeginqty,sum(fdebitlocal) fdebitlocal,sum(fdebitfor) fdebitfor,", new Object[0]);
        sqlBuilder.append("sum(fdebitqty) fdebitqty,sum(fcreditlocal) fcreditlocal,sum(fcreditfor) fcreditfor,sum(fcreditqty) fcreditqty,", new Object[0]);
        sqlBuilder.append("sum(fyeardebitlocal) fyeardebitlocal,sum(fyeardebitfor) fyeardebitfor,sum(fyeardebitqty) fyeardebitqty,sum(fyearcreditlocal) fyearcreditlocal,", new Object[0]);
        sqlBuilder.append("sum(fyearcreditfor) fyearcreditfor,sum(fyearcreditqty) fyearcreditqty,", new Object[0]);
        for (LocalCurrencyConfigVO configVO : this.configVOS) {
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(",", new Object[0]);
        }
        sqlBuilder.append("sum(fendlocal) fendlocal,sum(fendfor) fendfor,sum(fendqty) fendqty,sum(fcount) fcount from t_gl_balance ", new Object[0]);
        sqlBuilder.append(" where forgid=?", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid=?", new Object[]{booktypeId});
        sqlBuilder.append(" group by forgid,fbooktypeid,faccountid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id,fperiodid", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        dataSet = dataSet.orderBy(new String[]{"faccountid", "fcurrencyid", "fmeasureunitid", "fcomassist1id", "fcomassist2id", "fperiodid"});
        return dataSet;
    }

    private void processBalData(long orgId, long booktypeId, Map<AcctBalKey, List<AcctBalanceData>> map) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<AcctBalKey, List<AcctBalanceData>> entry : map.entrySet()) {
            AcctBalKey key = entry.getKey();
            List<AcctBalanceData> value = entry.getValue();
            AcctBalanceData preData = null;
            int size = value.size();
            int i = 1;
            for (AcctBalanceData data : value) {
                Object[] param;
                if (preData != null) {
                    this.recalbal(preData, data);
                }
                if (i == size) {
                    if (preData == null) {
                        param = this.getParam(orgId, booktypeId, GLUtil.MAX_PERIOD, data, key);
                        params.add(param);
                    } else {
                        Object[] param1 = this.getParam(orgId, booktypeId, data.getPeriodId(), preData, key);
                        params.add(param1);
                        Object[] param2 = this.getParam(orgId, booktypeId, GLUtil.MAX_PERIOD, data, key);
                        params.add(param2);
                    }
                } else if (i > 1 && preData != null) {
                    param = this.getParam(orgId, booktypeId, data.getPeriodId(), preData, key);
                    params.add(param);
                }
                preData = data;
                ++i;
            }
        }
        long[] ids = DB.genLongIds((String)"t_gl_acctbalance", (int)params.size());
        for (int i = 0; i < ids.length; ++i) {
            ((Object[])params.get((int)i))[0] = ids[i];
        }
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into t_gl_acctbalance (fid,fperiodid,fendperiodid, forgid,fbooktypeid,faccounttableid,faccountid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id,");
        insertSql.append("fbeginlocal,fbeginfor,fbeginqty,fdebitlocal,fdebitfor,fdebitqty,fcreditlocal,fcreditfor,fcreditqty,fyeardebitlocal,");
        insertSql.append("fyeardebitfor,fyeardebitqty,fyearcreditlocal,fyearcreditfor,fyearcreditqty,fendlocal,fendfor,fendqty,fcount");
        for (LocalCurrencyConfigVO configVO : this.configVOS) {
            insertSql.append(",").append(configVO.getBalanceField(MCT.BEGIN).getDbId());
            insertSql.append(",").append(configVO.getBalanceField(MCT.DEBIT).getDbId());
            insertSql.append(",").append(configVO.getBalanceField(MCT.CREDIT).getDbId());
            insertSql.append(",").append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId());
            insertSql.append(",").append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId());
            insertSql.append(",").append(configVO.getBalanceField(MCT.END).getDbId());
        }
        insertSql.append(") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        for (int i = 0; i < this.configVOS.size() * 6; ++i) {
            insertSql.append(",?");
        }
        insertSql.append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertSql.toString(), params);
    }

    private Object[] getParam(long orgId, long booktypeId, long endPeriod, AcctBalanceData preData, AcctBalKey key) {
        Object[] param = new Object[]{0L, preData.getPeriodId(), endPeriod, orgId, booktypeId, key.getAccttableId(), key.getAccountId(), key.getCurrencyId(), key.getMeasureunitId(), key.getComassist1Id(), key.getComassist2Id(), preData.getBeginlocal(), preData.getBeginfor(), preData.getBeginqty(), preData.getDebitlocal(), preData.getDebitfor(), preData.getDebitqty(), preData.getCreditlocal(), preData.getCreditfor(), preData.getCreditqty(), preData.getYeardebitlocal(), preData.getYeardebitfor(), preData.getYeardebitqty(), preData.getYearcreditlocal(), preData.getYearcreditfor(), preData.getYearcreditqty(), preData.getEndlocal(), preData.getEndfor(), preData.getEndqty(), preData.getCount()};
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(param));
        Map<String, BigDecimal> localAmt = preData.getMulLocalAmt();
        for (LocalCurrencyConfigVO configVO : this.configVOS) {
            list.add(localAmt.get(configVO.getBalanceField(MCT.BEGIN).getDbId()));
            list.add(localAmt.get(configVO.getBalanceField(MCT.DEBIT).getDbId()));
            list.add(localAmt.get(configVO.getBalanceField(MCT.CREDIT).getDbId()));
            list.add(localAmt.get(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId()));
            list.add(localAmt.get(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId()));
            list.add(localAmt.get(configVO.getBalanceField(MCT.END).getDbId()));
        }
        return list.toArray(new Object[0]);
    }

    private void recalbal(AcctBalanceData preData, AcctBalanceData data) {
        data.setBeginqty(preData.getEndqty());
        data.setBeginlocal(preData.getEndlocal());
        data.setBeginfor(preData.getEndfor());
        if (preData.getPeriodId() / 10000L == data.getPeriodId() / 10000L) {
            data.setYearcreditqty(preData.getYearcreditqty().add(data.getCreditqty()));
            data.setYearcreditlocal(preData.getYearcreditlocal().add(data.getCreditlocal()));
            data.setYearcreditfor(preData.getYearcreditfor().add(data.getCreditfor()));
            data.setYeardebitqty(preData.getYeardebitqty().add(data.getDebitqty()));
            data.setYeardebitlocal(preData.getYeardebitlocal().add(data.getDebitlocal()));
            data.setYeardebitfor(preData.getYeardebitfor().add(data.getDebitfor()));
        } else {
            data.setYearcreditqty(data.getCreditqty());
            data.setYearcreditlocal(data.getCreditlocal());
            data.setYearcreditfor(data.getCreditfor());
            data.setYeardebitqty(data.getDebitqty());
            data.setYeardebitlocal(data.getDebitlocal());
            data.setYeardebitfor(data.getDebitfor());
        }
        data.setEndqty(data.getBeginqty().add(data.getDebitqty()).subtract(data.getCreditqty()));
        data.setEndfor(data.getBeginfor().add(data.getDebitfor()).subtract(data.getCreditfor()));
        data.setEndlocal(data.getBeginlocal().add(data.getDebitlocal()).subtract(data.getCreditlocal()));
    }

    private AcctBalanceData buildData(Row row) {
        AcctBalanceData data = new AcctBalanceData();
        data.setPeriodId(row.getLong("fperiodid"));
        data.setBeginfor(row.getBigDecimal("fbeginfor"));
        data.setBeginlocal(row.getBigDecimal("fbeginlocal"));
        data.setBeginqty(row.getBigDecimal("fbeginqty"));
        data.setDebitfor(row.getBigDecimal("fdebitfor"));
        data.setDebitlocal(row.getBigDecimal("fdebitlocal"));
        data.setDebitqty(row.getBigDecimal("fdebitqty"));
        data.setCreditlocal(row.getBigDecimal("fcreditlocal"));
        data.setCreditfor(row.getBigDecimal("fcreditfor"));
        data.setCreditqty(row.getBigDecimal("fcreditqty"));
        data.setYeardebitfor(row.getBigDecimal("fyeardebitfor"));
        data.setYeardebitlocal(row.getBigDecimal("fyeardebitlocal"));
        data.setYeardebitqty(row.getBigDecimal("fyeardebitqty"));
        data.setYearcreditfor(row.getBigDecimal("fyearcreditfor"));
        data.setYearcreditlocal(row.getBigDecimal("fyearcreditlocal"));
        data.setYearcreditqty(row.getBigDecimal("fyearcreditqty"));
        data.setEndfor(row.getBigDecimal("fendfor"));
        data.setEndlocal(row.getBigDecimal("fendlocal"));
        data.setEndqty(row.getBigDecimal("fendqty"));
        data.setCount(row.getInteger("fcount"));
        for (LocalCurrencyConfigVO configVO : this.configVOS) {
            data.putMulLocalAmt(configVO.getBalanceField(MCT.BEGIN).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.BEGIN).getDbId()));
            data.putMulLocalAmt(configVO.getBalanceField(MCT.DEBIT).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.DEBIT).getDbId()));
            data.putMulLocalAmt(configVO.getBalanceField(MCT.CREDIT).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.CREDIT).getDbId()));
            data.putMulLocalAmt(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId()));
            data.putMulLocalAmt(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId()));
            data.putMulLocalAmt(configVO.getBalanceField(MCT.END).getDbId(), row.getBigDecimal(configVO.getBalanceField(MCT.END).getDbId()));
        }
        return data;
    }
}

