/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.acctpullupbalupdate.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balcal.acctpullupbalupdate.handle.IAcctPullUpBalance;
import kd.fi.gl.balcal.acctpullupbalupdate.param.AcctBalanceVersionUpdateParam;
import kd.fi.gl.balcal.acctpullupbalupdate.param.MasterIdNewAndOld;
import kd.fi.gl.balcal.acctpullupbalupdate.param.OrgAndMasterIdList;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;

public class AcctPullUpBalanceImpl
implements IAcctPullUpBalance {
    @Override
    public List<Map<String, Object>> updateBalanceData(AcctBalanceVersionUpdateParam updateParam) {
        updateParam = this.rebuildParam(updateParam);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        List<OrgAndMasterIdList> orgAndMasterIdLists = updateParam.getOrgAndMasterIdLists();
        for (OrgAndMasterIdList orgAndMasterIdList : orgAndMasterIdLists) {
            long orgId = orgAndMasterIdList.getOrgId();
            long bookTypeId = orgAndMasterIdList.getBookTypeId();
            List<MasterIdNewAndOld> masterIdGroups = orgAndMasterIdList.getMasterIdGroups();
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
            result.put("success", true);
            if (Lock.tryLock(orgId, bookTypeId, LockKey.BalanceCal, () -> this.updateBalData(orgId, masterIdGroups))) {
                result.put("success", false);
            }
            resultList.add(result);
        }
        return resultList;
    }

    private AcctBalanceVersionUpdateParam rebuildParam(AcctBalanceVersionUpdateParam param) {
        List<OrgAndMasterIdList> orgAndMasterIdLists = param.getOrgAndMasterIdLists();
        ArrayList<Long> orgs = new ArrayList<Long>(orgAndMasterIdLists.size());
        ArrayList<Long> accountIds = new ArrayList<Long>(10);
        HashMap<Long, Long> masterIdOldMapNew = new HashMap<Long, Long>(16);
        for (OrgAndMasterIdList orgAndMasterIdList : orgAndMasterIdLists) {
            long orgId = orgAndMasterIdList.getOrgId();
            orgs.add(orgId);
            List<MasterIdNewAndOld> masterIdGroups = orgAndMasterIdList.getMasterIdGroups();
            for (MasterIdNewAndOld masterIdGroup : masterIdGroups) {
                long l = masterIdGroup.getOldId();
                long newId = masterIdGroup.getNewId();
                accountIds.add(l);
                masterIdOldMapNew.put(l, newId);
            }
        }
        QFilter orgFilter = new QFilter("org.id", "in", orgs);
        QFilter acctFilter = new QFilter("account.id", "in", accountIds);
        StringBuilder sb = new StringBuilder();
        sb.append("booktype.id");
        sb.append(",").append("org.id");
        sb.append(",").append("account.id");
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"rebuildParam", (String)"gl_balance", (String)sb.toString(), (QFilter[])new QFilter[]{orgFilter, acctFilter}, null);
        HashMap newOrgAndMasterIdListsMap = new HashMap(16);
        for (Object row : queryDataSet) {
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(1);
            hashMap.put(row.getLong("org.id"), row.getLong("booktype.id"));
            ArrayList<Long> acctIds = null;
            acctIds = newOrgAndMasterIdListsMap.containsKey(hashMap) ? (ArrayList<Long>)newOrgAndMasterIdListsMap.get(hashMap) : new ArrayList<Long>(10);
            acctIds.add(row.getLong("account.id"));
            newOrgAndMasterIdListsMap.put(hashMap, acctIds);
        }
        ArrayList<OrgAndMasterIdList> newOrgAndMasterIdLists = new ArrayList<OrgAndMasterIdList>(10);
        for (Map.Entry entry : newOrgAndMasterIdListsMap.entrySet()) {
            OrgAndMasterIdList paramObj = new OrgAndMasterIdList();
            Map key = (Map)entry.getKey();
            for (Map.Entry keyEntry : key.entrySet()) {
                paramObj.setOrgId((Long)keyEntry.getKey());
                paramObj.setBookTypeId((Long)keyEntry.getValue());
            }
            List mapListEntryValue = (List)entry.getValue();
            ArrayList<MasterIdNewAndOld> masterIdGroups = new ArrayList<MasterIdNewAndOld>(mapListEntryValue.size());
            for (Long acctIds : mapListEntryValue) {
                MasterIdNewAndOld newAndOld = new MasterIdNewAndOld();
                newAndOld.setOldId(acctIds);
                newAndOld.setNewId((Long)masterIdOldMapNew.get(acctIds));
                masterIdGroups.add(newAndOld);
            }
            paramObj.setMasterIdGroups(masterIdGroups);
            newOrgAndMasterIdLists.add(paramObj);
        }
        AcctBalanceVersionUpdateParam reParam = new AcctBalanceVersionUpdateParam();
        reParam.setOrgAndMasterIdLists(newOrgAndMasterIdLists);
        return reParam;
    }

    private void updateBalData(long orgId, List<MasterIdNewAndOld> masterIdGroups) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        for (MasterIdNewAndOld masterIdGroup : masterIdGroups) {
            Object[] updateParam = new Object[]{masterIdGroup.getNewId(), masterIdGroup.getOldId(), orgId};
            updateParams.add(updateParam);
        }
        if (updateParams.size() > 0) {
            this.patchExecute(updateParams);
        }
    }

    private void patchExecute(List<Object[]> insertParams) {
        String sql = "UPDATE T_GL_BALANCE SET FACCOUNTID=?  WHERE FACCOUNTID=? AND FORGID=?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, insertParams);
    }
}

