/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.ORM;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.constant.BalData;
import kd.fi.gl.accountref.constant.SingleAccountRefContext;
import kd.fi.gl.balcal.BalanceData;
import kd.fi.gl.balcal.BalanceKey;
import kd.fi.gl.balcal.CashflowData;
import kd.fi.gl.balcal.CashflowKey;
import kd.fi.gl.balcal.Data;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.log.BalCalChangeKey;
import kd.fi.gl.balcal.log.BalChangeAction;
import kd.fi.gl.balcal.log.BalChangeLog;
import kd.fi.gl.balcal.log.BalSourceLog;
import kd.fi.gl.balcal.log.CFCalChangeKey;
import kd.fi.gl.balcal.log.CFChangeLog;
import kd.fi.gl.balcal.log.CFSourceLog;
import kd.fi.gl.balcal.log.ChangeSourceLog;
import kd.fi.gl.balcal.log.ChangeType;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.business.service.log.DataChangeLogServiceHelper;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;
import org.apache.commons.lang3.ArrayUtils;

public class BalChangeLoggerImpl
implements BalChangeLogger {
    private final Date opDate = new Date();

    @Override
    public <D extends Data, K extends Key> Map<String, DataChangeLog> getDataId2Log(String table, Map<K, List<D>> balData) {
        HashMap<String, DataChangeLog> res = new HashMap<String, DataChangeLog>(balData.size());
        balData.forEach((key, datas) -> {
            for (Data data : datas) {
                DataChangeLog log;
                if ("T_GL_BALANCE".equals(table) || "T_GL_ACCTBALANCE".equals(table)) {
                    log = new BalCalChangeKey((BalanceKey)key, (BalanceData)data).createBalChangeLog(table);
                    ((BalChangeLog)log).setEntity(table);
                } else {
                    log = new CFCalChangeKey((CashflowKey)key, (CashflowData)data).createCFChangeLog();
                }
                res.put(log.getChangeId(), log);
            }
        });
        return res;
    }

    @Override
    public void recordRemoveData(String table, Object[] removeBalIds, Map<String, DataChangeLog> dataId2Log, BalChangeAction action) {
        String opName = action.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(removeBalIds.length);
            for (Object removeBalId : removeBalIds) {
                BalChangeLog dataChangeLog = (BalChangeLog)dataId2Log.get(removeBalId.toString());
                if (dataChangeLog == null) continue;
                dataChangeLog.setChangeType("delete");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(removeBalIds.length);
            for (Object removeBalId : removeBalIds) {
                CFChangeLog dataChangeLog = (CFChangeLog)dataId2Log.get(removeBalId.toString());
                if (dataChangeLog == null) continue;
                dataChangeLog.setChangeType("delete");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordUpdateEndPeriod(String table, List<Object[]> updateEndPeriodParams, Map<String, DataChangeLog> dataId2Log, boolean reCal) {
        String opName;
        String string = opName = reCal ? BalChangeAction.RE_CAL.name() : BalChangeAction.CAL_BAL_LOG.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateEndPeriodParams.size());
            for (Object[] updateParam : updateEndPeriodParams) {
                BalChangeLog log = (BalChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateEndPeriod");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                log.setEndPeriodId(updateParam[0].toString());
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(updateEndPeriodParams.size());
            for (Object[] updateParam : updateEndPeriodParams) {
                CFChangeLog log = (CFChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateEndPeriod");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                log.setEndPeriodId(updateParam[0].toString());
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordInsertData(String table, List<Object[]> newBalParams, boolean reCal, int comAssistSize) {
        String opName;
        String string = opName = reCal ? BalChangeAction.RE_CAL.name() : BalChangeAction.CAL_BAL_LOG.name();
        if ("T_GL_BALANCE".equals(table) || "T_GL_ACCTBALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(newBalParams.size());
            for (Object[] newParam : newBalParams) {
                BalChangeLog dataChangeLog = new BalChangeLog();
                dataChangeLog.setChangeType("insert");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                dataChangeLog.setEntity(table);
                dataChangeLog.setChangeId(newParam[0].toString());
                dataChangeLog.setOrgId(newParam[1].toString());
                dataChangeLog.setBookTypeId(newParam[2].toString());
                dataChangeLog.setPeriodId(newParam[3].toString());
                dataChangeLog.setEndPeriodId(newParam[4].toString());
                dataChangeLog.setAccountId(newParam[5].toString());
                dataChangeLog.setAccountTableId(newParam[6].toString());
                dataChangeLog.setCurrencyId(newParam[7].toString());
                int i = 7;
                if ("T_GL_BALANCE".equals(table)) {
                    dataChangeLog.setAssgrpId(newParam[8].toString());
                    i = 8;
                }
                dataChangeLog.setComAssistIdStr(ArrayUtils.subarray((Object[])newParam, (int)i, (int)(i + comAssistSize)));
                dataChangeLog.setBegin((BigDecimal)newParam[(i += comAssistSize) + 3]);
                dataChangeLog.setDebit((BigDecimal)newParam[i + 7]);
                dataChangeLog.setCredit((BigDecimal)newParam[i + 8]);
                dataChangeLog.setYearDebit((BigDecimal)newParam[i + 13]);
                dataChangeLog.setYearCredit((BigDecimal)newParam[i + 14]);
                dataChangeLog.setEnd((BigDecimal)newParam[i + 18]);
                dataChangeLog.setCount((Integer)newParam[newParam.length - 2]);
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(newBalParams.size());
            for (Object[] newParam : newBalParams) {
                CFChangeLog changeLog = new CFChangeLog();
                changeLog.setChangeType("insert");
                changeLog.setOpDate(this.opDate);
                changeLog.setOpName(opName);
                changeLog.setChangeId(newParam[0].toString());
                changeLog.setOrgId(newParam[1].toString());
                changeLog.setBookTypeId(newParam[2].toString());
                changeLog.setPeriodId(newParam[3].toString());
                changeLog.setEndPeriodId(newParam[4].toString());
                changeLog.setCfItemId(newParam[5].toString());
                changeLog.setCurrencyId(newParam[6].toString());
                changeLog.setAssgrpId(newParam[7].toString());
                changeLog.setComAssistIdStr(ArrayUtils.subarray((Object[])newParam, (int)8, (int)(8 + comAssistSize)));
                changeLog.setAmount((BigDecimal)newParam[newParam.length - 4]);
                changeLog.setYearAmount((BigDecimal)newParam[newParam.length - 3]);
                changeLog.setCount((Integer)newParam[newParam.length - 2]);
                logList.add(changeLog);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordInsertDyo(String table, List<DynamicObject> inserts, BalChangeAction action, int comAssistSize) {
        if (inserts.size() == 0) {
            return;
        }
        String opName = action.name();
        IDataEntityType dataType = inserts.get(0).getDataEntityType();
        if ("T_GL_BALANCE".equals(table) || "T_GL_ACCTBALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(inserts.size());
            long[] ids = ORM.create().genLongIds(dataType, inserts.size());
            for (int i = 0; i < inserts.size(); ++i) {
                DynamicObject bal = inserts.get(i);
                dataType.getPrimaryKey().setValueFast((Object)bal, (Object)ids[i]);
                BalChangeLog dataChangeLog = new BalChangeLog();
                dataChangeLog.setChangeType("insert");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                dataChangeLog.setEntity(table);
                dataChangeLog.setChangeId(ids[i] + "");
                dataChangeLog.setOrgId(bal.getLong("org") + "");
                dataChangeLog.setBookTypeId(bal.getLong("booktype") + "");
                dataChangeLog.setPeriodId(bal.getLong("period") + "");
                dataChangeLog.setEndPeriodId(bal.getLong("endperiod") + "");
                dataChangeLog.setAccountId(bal.getLong("account") + "");
                dataChangeLog.setAccountTableId(bal.getLong("accounttable") + "");
                dataChangeLog.setCurrencyId(bal.getLong("currency") + "");
                if ("T_GL_BALANCE".equals(table)) {
                    dataChangeLog.setAssgrpId(bal.getLong("assgrp") + "");
                    i = 8;
                }
                Object[] comAssists = new Object[comAssistSize];
                for (int j = 0; j < comAssists.length; ++j) {
                    comAssists[j] = bal.getLong("comassist" + (j + 1));
                }
                dataChangeLog.setComAssistIdStr(comAssists);
                dataChangeLog.setBegin(bal.getBigDecimal("beginlocal"));
                dataChangeLog.setDebit(bal.getBigDecimal("debitlocal"));
                dataChangeLog.setCredit(bal.getBigDecimal("creditlocal"));
                dataChangeLog.setYearDebit(bal.getBigDecimal("yeardebitlocal"));
                dataChangeLog.setYearCredit(bal.getBigDecimal("yearcreditlocal"));
                dataChangeLog.setEnd(bal.getBigDecimal("endlocal"));
                dataChangeLog.setCount(bal.getInt("count"));
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(inserts.size());
            long[] ids = ORM.create().genLongIds(dataType, inserts.size());
            for (int i = 0; i < inserts.size(); ++i) {
                DynamicObject bal = inserts.get(i);
                dataType.getPrimaryKey().setValueFast((Object)bal, (Object)ids[i]);
                CFChangeLog dataChangeLog = new CFChangeLog();
                dataChangeLog.setChangeType("insert");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                dataChangeLog.setChangeId(ids[i] + "");
                dataChangeLog.setOrgId(bal.getLong("org") + "");
                dataChangeLog.setBookTypeId(bal.getLong("booktype") + "");
                dataChangeLog.setPeriodId(bal.getLong("period") + "");
                dataChangeLog.setEndPeriodId(bal.getLong("endperiod") + "");
                dataChangeLog.setCfItemId(bal.getLong("cfitem") + "");
                dataChangeLog.setCurrencyId(bal.getLong("currency") + "");
                dataChangeLog.setAssgrpId(bal.getLong("assgrp") + "");
                Object[] comAssists = new Object[comAssistSize];
                for (int j = 0; j < comAssists.length; ++j) {
                    comAssists[j] = bal.getLong("comassist" + (j + 1));
                }
                dataChangeLog.setComAssistIdStr(comAssists);
                dataChangeLog.setAmount(bal.getBigDecimal("amount"));
                dataChangeLog.setYearAmount(bal.getBigDecimal("yearamount"));
                dataChangeLog.setReceiveAmount(bal.getBigDecimal("receiveamount"));
                dataChangeLog.setCount(bal.getInt("count"));
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordUpdateBal(String table, List<Object[]> updateBalParams, Map<String, DataChangeLog> dataId2Log, boolean reCal) {
        String opName;
        String string = opName = reCal ? BalChangeAction.RE_CAL.name() : BalChangeAction.CAL_BAL_LOG.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateBalParams.size());
            for (Object[] updateParam : updateBalParams) {
                BalChangeLog log = (BalChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateBal");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                int i = 0;
                if (reCal) {
                    log.setBegin((BigDecimal)updateParam[1]);
                    i = 3;
                }
                log.setDebit((BigDecimal)updateParam[i + 2]);
                log.setCredit((BigDecimal)updateParam[i + 3]);
                log.setYearDebit((BigDecimal)updateParam[i + 8]);
                log.setYearCredit((BigDecimal)updateParam[i + 9]);
                log.setEnd((BigDecimal)updateParam[i + 13]);
                log.setCount((Integer)updateParam[updateParam.length - 3]);
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(updateBalParams.size());
            for (Object[] updateParam : updateBalParams) {
                CFChangeLog log = (CFChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateBal");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                log.setAmount((BigDecimal)updateParam[0]);
                log.setYearAmount((BigDecimal)updateParam[1]);
                log.setCount((Integer)updateParam[2]);
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordInitUpdateBal(String table, List<Object[]> updateBalParams, Map<String, DataChangeLog> dataId2Log) {
        String opName = BalChangeAction.END_INIT.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateBalParams.size());
            for (Object[] updateParam : updateBalParams) {
                BalChangeLog log = (BalChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateBal");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                int i = 0;
                log.setBegin((BigDecimal)updateParam[i + 2]);
                log.setEnd((BigDecimal)updateParam[i + 4]);
                log.setYearDebit((BigDecimal)updateParam[i + 6]);
                log.setYearCredit((BigDecimal)updateParam[i + 8]);
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(updateBalParams.size());
            for (Object[] updateParam : updateBalParams) {
                CFChangeLog log = (CFChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateBal");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                log.setAmount((BigDecimal)updateParam[0]);
                log.setYearAmount((BigDecimal)updateParam[1]);
                log.setCount((Integer)updateParam[2]);
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordUpdateCurrYBal(String table, List<Object[]> updateCurrYBalParams, Map<String, DataChangeLog> dataId2Log, boolean reCal) {
        String opName;
        String string = opName = reCal ? BalChangeAction.RE_CAL.name() : BalChangeAction.CAL_BAL_LOG.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateCurrYBalParams.size());
            for (Object[] updateParam : updateCurrYBalParams) {
                BalChangeLog log = (BalChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log != null) {
                    log.setChangeType("updateCurrYBal");
                    log.setOpDate(this.opDate);
                    log.setOpName(opName);
                    log.setBegin((BigDecimal)updateParam[1]);
                    log.setEnd((BigDecimal)updateParam[4]);
                    log.setYearDebit((BigDecimal)updateParam[8]);
                    log.setYearCredit((BigDecimal)updateParam[9]);
                    logList.add(log);
                }
                DataChangeLogServiceHelper.recordBalChangeLog(logList);
            }
        } else {
            ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(updateCurrYBalParams.size());
            for (Object[] updateParam : updateCurrYBalParams) {
                CFChangeLog log = (CFChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (log == null) continue;
                log.setChangeType("updateCurrYBal");
                log.setOpDate(this.opDate);
                log.setOpName(opName);
                log.setYearAmount((BigDecimal)updateParam[0]);
                logList.add(log);
            }
            DataChangeLogServiceHelper.recordCFChangeLog(logList);
        }
    }

    @Override
    public void recordUpdateLaterYBal(String table, List<Object[]> updateLaterYBalParams, Map<String, DataChangeLog> dataId2Log, boolean reCal) {
        String opName;
        String string = opName = reCal ? BalChangeAction.RE_CAL.name() : BalChangeAction.CAL_BAL_LOG.name();
        if ("T_GL_BALANCE".equals(table)) {
            ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateLaterYBalParams.size());
            for (Object[] updateParam : updateLaterYBalParams) {
                BalChangeLog dataChangeLog = (BalChangeLog)dataId2Log.get(updateParam[updateParam.length - 1].toString());
                if (dataChangeLog == null) continue;
                dataChangeLog.setChangeType("updateLaterYBal");
                dataChangeLog.setOpDate(this.opDate);
                dataChangeLog.setOpName(opName);
                dataChangeLog.setBegin((BigDecimal)updateParam[1]);
                dataChangeLog.setEnd((BigDecimal)updateParam[4]);
                logList.add(dataChangeLog);
            }
            DataChangeLogServiceHelper.recordBalChangeLog(logList);
        }
    }

    @Override
    public void recordDataChangeSource(String table, List<Long> logIds) {
        List<ChangeSourceLog> logList = logIds.stream().map(id -> {
            ChangeSourceLog changeSourceLog = "T_GL_BALANCE".equals(table) ? new BalSourceLog() : new CFSourceLog();
            changeSourceLog.setSourceId(String.valueOf(id));
            changeSourceLog.setOpDate(this.opDate);
            changeSourceLog.setOpName(BalChangeAction.CAL_BAL_LOG.name());
            return changeSourceLog;
        }).collect(Collectors.toList());
        if ("T_GL_BALANCE".equals(table)) {
            DataChangeLogServiceHelper.recordBalSourceLog(logList);
        } else {
            DataChangeLogServiceHelper.recordCFSourceLog(logList);
        }
    }

    @Override
    public void recordInitUpdateCF(List<DynamicObject> updates, int comAssistsSize) {
        ArrayList<CFChangeLog> logList = new ArrayList<CFChangeLog>(updates.size());
        for (int i = 0; i < updates.size(); ++i) {
            DynamicObject bal = updates.get(i);
            CFChangeLog dataChangeLog = new CFChangeLog();
            dataChangeLog.setChangeType("updateBal");
            dataChangeLog.setOpDate(this.opDate);
            dataChangeLog.setOpName(BalChangeAction.END_INIT.name());
            dataChangeLog.setChangeId(bal.getPkValue().toString());
            dataChangeLog.setOrgId(bal.getLong("org") + "");
            dataChangeLog.setBookTypeId(bal.getLong("booktype") + "");
            dataChangeLog.setPeriodId(bal.getLong("period") + "");
            dataChangeLog.setEndPeriodId(bal.getLong("endperiod") + "");
            dataChangeLog.setCfItemId(bal.getLong("cfitem") + "");
            dataChangeLog.setCurrencyId(bal.getLong("currency") + "");
            dataChangeLog.setAssgrpId(bal.getLong("assgrp") + "");
            Object[] comAssists = new Object[comAssistsSize];
            for (int j = 0; j < comAssists.length; ++j) {
                comAssists[j] = bal.getLong("comassist" + (j + 1));
            }
            dataChangeLog.setComAssistIdStr(comAssists);
            dataChangeLog.setAmount(bal.getBigDecimal("amount"));
            dataChangeLog.setYearAmount(bal.getBigDecimal("yearamount"));
            dataChangeLog.setReceiveAmount(bal.getBigDecimal("receiveamount"));
            dataChangeLog.setCount(bal.getInt("count"));
            logList.add(dataChangeLog);
        }
        DataChangeLogServiceHelper.recordCFChangeLog(logList);
    }

    @Override
    public void recordBalTransData(SingleAccountRefContext context, String table, List<AbstractBalData> updateBalDatas, ChangeType changeType, long[] insertIds) {
        ArrayList<BalChangeLog> logList = new ArrayList<BalChangeLog>(updateBalDatas.size());
        for (int i = 0; i < updateBalDatas.size(); ++i) {
            BalData balData = (BalData)updateBalDatas.get(i);
            BalChangeLog log = new BalChangeLog();
            log.setOpDate(this.opDate);
            log.setOpName(BalChangeAction.BAL_TRANSFER.name());
            log.setEntity(table);
            log.setChangeType(changeType.name());
            log.setChangeId((changeType == ChangeType.insert ? insertIds[i] : balData.getId()) + "");
            log.setOrgId(context.getOrgId() + "");
            log.setBookTypeId(context.getBookTypeId() + "");
            log.setAccountTableId(context.getAcctTblRef().getNewAccountTableId() + "");
            log.setPeriodId(balData.getPeriodId() + "");
            log.setEndPeriodId(balData.getEndPeriodId() + "");
            log.setAccountId(balData.getAcctMasterId() + "");
            log.setAssgrpId(balData.getAssgrpId() + "");
            log.setCurrencyId(balData.getCurrencyId() + "");
            if (changeType != ChangeType.delete) {
                log.setBegin(balData.getBeginLocal());
                log.setDebit(balData.getDebitLocal());
                log.setCredit(balData.getCreditLocal());
                log.setYearDebit(balData.getYearDebitLocal());
                log.setYearCredit(balData.getYearCreditLocal());
                log.setEnd(balData.getEndLocal());
                log.setCount(balData.getCount());
            }
            logList.add(log);
        }
        DataChangeLogServiceHelper.recordBalChangeLog(logList);
    }
}

