/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal.repair;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.balcal.CashflowCalculator;
import kd.fi.gl.balcal.repair.IBalanceRepairable;
import org.apache.commons.lang3.StringUtils;

public class CashflowRepairService
extends CashflowCalculator
implements IBalanceRepairable {
    private static final Log LOG = LogFactory.getLog(CashflowRepairService.class);
    private static final String PERIODS_SQL = "SELECT distinct(v.fperiodid) fperiodid FROM t_gl_voucher v inner join t_gl_voucherentry ve ON v.fid = ve.fid WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid >= ? AND v.fperiodid <= ? AND ve.fmaincfassgrpid in {assistid} AND v.fbillstatus in ('B','C') order by v.fperiodid asc ";
    private static final String fromVoucher = " FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_bd_accountbooks bk ON v.fbookid = bk.fid ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reCalculateByAssist(long orgId, long bookTypeId, Set<Long> assistIds, long startPeriodId, long endPeriodId) {
        if (CollectionUtils.isEmpty(assistIds)) {
            throw new KDBizException("param assistIds is empty. ");
        }
        LOG.info("reCalculateByAssist on cashflow: org: {}, booktypeid: {}, startperiod: {}, endperiod: {}, assistid: {}", new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId, assistIds});
        ThreadCache.put((Object)"balance_calculator_standalone_transaction", (Object)Boolean.FALSE.toString());
        try {
            this.initComassist(orgId, bookTypeId);
            for (long curPeriod : this.queryDistinctPeriods(orgId, bookTypeId, assistIds, startPeriodId, endPeriodId)) {
                DataSet dataSet = this.getBillDataSet(orgId, bookTypeId, assistIds, curPeriod);
                dataSet = this.transferMid(dataSet);
                this.updateBalance(orgId, bookTypeId, dataSet, true, curPeriod);
            }
        }
        finally {
            ThreadCache.remove((Object)"balance_calculator_standalone_transaction");
        }
    }

    private List<Long> queryDistinctPeriods(long orgId, long bookTypeId, Set<Long> assistIds, long startPeriodId, long endPeriodId) {
        String sql = PERIODS_SQL.replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")");
        Object[] params = new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId};
        DataSet dataSet = DB.queryDataSet((String)"queryVoucherOnBalanceRepair", (DBRoute)gl, (String)sql, (Object[])params);
        ArrayList<Long> periodIds = new ArrayList<Long>(8);
        while (dataSet.hasNext()) {
            periodIds.add(dataSet.next().getLong("fperiodid"));
        }
        return periodIds;
    }

    private DataSet getBillDataSet(long orgId, long bookTypeId, Set<Long> assistIds, long period) {
        Object[] billParams = new Object[]{orgId, bookTypeId, period};
        DBRoute route = DBRoute.of((String)"gl");
        DataSet main = DB.queryDataSet((String)"getMainCf", (DBRoute)route, (String)this.getMainSql().replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")"), (Object[])billParams);
        DataSet supp = DB.queryDataSet((String)"getSuppCf", (DBRoute)route, (String)this.getSuppcfSql().replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")"), (Object[])billParams);
        main = main.union(supp);
        long cashProfitId = this.getCashProfit(orgId);
        if (cashProfitId > 0L) {
            DataSet cashProfit = DB.queryDataSet((String)"getCashProfitCf", (DBRoute)route, (String)this.getProfitSql(cashProfitId).replace("{assistid}", "(" + StringUtils.join(assistIds, (String)",") + ")"), (Object[])billParams);
            main = main.union(cashProfit);
        }
        return main;
    }

    protected String getMainSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ve.fid, v.fperiodid, cfi.fmasterid fcfitemid,ve.fmaincfassgrpid fassgrpid,bk.fbasecurrencyid fcurrencyid,ve.fmaincfamount famount ,").append(this.getComassistField()).append("1 fcount");
        sql.append(fromVoucher);
        sql.append(" INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fmaincfitemid ");
        sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid = ? AND ve.fassgrpid in {assistid} AND v.fbillstatus in ('B','C') AND ve.fmaincfitemid<>0 ");
        return sql.toString();
    }

    protected String getSuppcfSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ve.fid, v.fperiodid, cfi.fmasterid fcfitemid, 0 fassgrpid, bk.fbasecurrencyid fcurrencyid, ve.fsuppcfamount famount ,").append(this.getComassistField()).append("1 fcount");
        sql.append(fromVoucher);
        sql.append(" INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fsuppcfitemid ");
        sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid = ? AND ve.fassgrpid in {assistid} AND v.fbillstatus in ('B','C') AND ve.fsuppcfitemid<>0");
        return sql.toString();
    }

    protected String getProfitSql(long cashProfitId) {
        StringBuilder sql = new StringBuilder();
        if (cashProfitId != 0L) {
            sql.append(" SELECT ve.fid, v.fperiodid, ").append(cashProfitId).append(" fcfitemid, 0 fassgrpid, bk.fbasecurrencyid fcurrencyid, flocalcredit-ve.flocaldebit famount ,").append(this.getComassistField()).append("1 fcount");
            sql.append(fromVoucher);
            sql.append(" INNER JOIN t_bd_account ba ON ba.fid=ve.faccountid ");
            sql.append(" INNER JOIN t_bd_accounttype bat ON bat.fid=ba.faccounttypeid ");
            sql.append(" WHERE v.forgid=? AND v.fbooktypeid = ? AND v.fperiodid = ? AND ve.fassgrpid in {assistid} AND v.fbillstatus in ('B','C')");
            sql.append(" AND v.fsourcetype <> '1' AND bat.faccounttype = '4'");
        }
        return sql.toString();
    }
}

