/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.business.dao.ms.MServiceDAOImpl;
import kd.fi.gl.business.service.cf.CashFlowFlexServiceImpl;
import kd.fi.gl.business.service.dap.DAPServiceImpl;
import kd.fi.gl.business.service.ms.MServiceImpl;
import kd.fi.gl.business.service.voucher.VoucherQueryServiceImpl;
import kd.fi.gl.business.service.voucher.VoucherStatusServiceImpl;
import kd.fi.gl.business.service.voucher.journal.VoucherJournalServiceImpl;
import kd.fi.gl.business.service.voucher.rel.VoucherRelationServiceImpl;
import kd.fi.gl.interfaces.dao.ms.IMServiceDAO;
import kd.fi.gl.interfaces.service.cf.ICashFlowFlexService;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.interfaces.service.ms.IMService;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.interfaces.service.voucher.IVoucherStatusService;
import kd.fi.gl.interfaces.service.voucher.journal.IVoucherJournalService;
import kd.fi.gl.interfaces.service.voucher.rel.IVoucherRelationService;

public class GLServiceFactory {
    private static final Map<String, String> serviceMap = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getLog((String)"GLServiceFactory");
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        return (T)(serviceInstanceMap.get() != null && serviceInstanceMap.get().containsKey(key) ? serviceInstanceMap.get().get(key) : GLServiceFactory.getService(key));
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"bos-core-api", (Object[])new Object[0]), serviceName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put(IVoucherRelationService.class.getSimpleName(), VoucherRelationServiceImpl.class.getName());
        serviceMap.put(IDAPService.class.getSimpleName(), DAPServiceImpl.class.getName());
        serviceMap.put(ICashFlowFlexService.class.getSimpleName(), CashFlowFlexServiceImpl.class.getName());
        serviceMap.put(IVoucherQueryService.class.getSimpleName(), VoucherQueryServiceImpl.class.getName());
        serviceMap.put(IVoucherJournalService.class.getSimpleName(), VoucherJournalServiceImpl.class.getName());
        serviceMap.put(IVoucherStatusService.class.getSimpleName(), VoucherStatusServiceImpl.class.getName());
        serviceMap.put(IMService.class.getSimpleName(), MServiceImpl.class.getName());
        serviceMap.put(IMServiceDAO.class.getSimpleName(), MServiceDAOImpl.class.getName());
    }
}

