/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.voucher;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.business.dao.voucher.ReadException;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.util.GLApp;
import org.apache.commons.collections4.CollectionUtils;

public interface IEntryReader<E extends IVoucherEntry>
extends AutoCloseable {
    public static final Log LOG = ExtLogFactory.getLog(IEntryReader.class);

    default public E read(Long entryId) throws ReadException {
        return (E)((IVoucherEntry)this.read(Collections.singletonList(entryId)).get(0));
    }

    public List<E> read(List<Long> var1) throws ReadException;

    default public E assertResult(Long entryId, E result) throws ReadException {
        if (result == null || result.getEntryId() != entryId.longValue()) {
            throw new ReadException(new ErrorCode("fi.gl.voucher.entry.read.error", ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c[%1$s]\u4e0e\u53c2\u6570[%2$s]\u4e0d\u5339\u914d\u3002", (String)"IEntryReader_0", (String)GLApp.instance.commonModule(), (Object[])new Object[]{result == null ? "null" : Long.valueOf(result.getEntryId()), entryId})), new Object[0]);
        }
        return result;
    }

    default public List<E> assertResult(List<Long> entryIds, List<E> result) throws ReadException {
        List resultIds = result.stream().map(IVoucherEntry::getEntryId).collect(Collectors.toList());
        boolean equal = CollectionUtils.isEqualCollection(entryIds, resultIds);
        if (!equal) {
            LOG.error("Entry read results {} not match entryIds {}", resultIds, entryIds);
            throw new ReadException(new ErrorCode("fi.gl.voucher.entry.read.error", ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e0e\u53c2\u6570\u4e0d\u5339\u914d\u3002", (String)"IEntryReader_1", (String)GLApp.instance.commonModule(), (Object[])new Object[0])), new Object[0]);
        }
        return result;
    }
}

