/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.dao.voucher.mc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.gl.business.dao.voucher.IEntryWriter;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherEntry;

public class MCEntryWriter<E extends IMCVoucherEntry>
implements IEntryWriter<E> {
    private final MulLocalConfig[] configs;

    public MCEntryWriter(MulLocalConfig[] configs) {
        this.configs = configs;
    }

    @Override
    public void write(E entry) {
        this.write(Collections.singletonList(entry));
    }

    @Override
    public void write(List<E> entries) {
        HashSet<Long> voucherIdSet = new HashSet<Long>(8);
        ArrayList<Object[]> params = new ArrayList<Object[]>(entries.size());
        ArrayList<Number> paramArray = new ArrayList<Number>(10);
        for (IMCVoucherEntry entry : entries) {
            voucherIdSet.add(entry.getId());
            for (MulLocalConfig config : this.configs) {
                paramArray.add(entry.getMCDebitAmount(config));
                paramArray.add(entry.getMCCreditAmount(config));
                paramArray.add(entry.getMCExRate(config));
            }
            paramArray.add(entry.getEntryId());
            params.add(paramArray.toArray());
            paramArray.clear();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update t_gl_voucherentry set ");
        sqlBuilder.append(Arrays.stream(this.configs).flatMap(x -> Stream.of(x.getDebitDbId() + " = ?", x.getCreditDbId() + " = ?", x.getExRateDbId() + " = ?")).collect(Collectors.joining(",")));
        sqlBuilder.append(" where fentryid = ?");
        TXHandle tx = TX.required();
        Object object = null;
        try {
            try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", "in", voucherIdSet)}).prepareShardingIndex();){
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sqlBuilder.toString(), params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

