/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service;

import java.util.function.BiFunction;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.util.replace.AssgrpBatchReplacer;
import kd.fi.gl.util.replace.CashFlowItemBatchReplacer;

public class BatchReplacerFactory {
    public static <T extends IVoucherEntry> CashFlowItemBatchReplacer<T> createCashFlowItemBatchReplacer(long orgId, long periodId) {
        return new CashFlowItemBatchReplacer(orgId, periodId);
    }

    public static <T extends IVoucherEntry> AssgrpBatchReplacer<T> createAssgrpBatchReplacer(boolean reloadMasterId, String assgrpKey) {
        return new AssgrpBatchReplacer(reloadMasterId, assgrpKey);
    }

    public static <T extends IVoucherEntry> AssgrpBatchReplacer<T> createAssgrpBatchReplacer(boolean reloadMasterId, String assgrpKey, Long filterOrgId, Long filterBookTypeId) {
        AssgrpBatchReplacer replacer = new AssgrpBatchReplacer(reloadMasterId, assgrpKey);
        replacer.setFilterPermission(filterOrgId, filterBookTypeId);
        return replacer;
    }

    public static <T extends IVoucherEntry> AssgrpBatchReplacer<T> createAssgrpBatchReplacer(boolean reloadMasterId, String assgrpKey, Long filterOrgId, Long filterBookTypeId, BiFunction<T, String, Object> defaultValueSetter) {
        AssgrpBatchReplacer<T> replacer = new AssgrpBatchReplacer<T>(reloadMasterId, assgrpKey, defaultValueSetter);
        replacer.setFilterPermission(filterOrgId, filterBookTypeId);
        return replacer;
    }

    public static <T extends IVoucherEntry> CashFlowItemBatchReplacer<T> createCombinedBatchReplacer(long orgId, long periodId, boolean reloadMasterId, String assgrpKey) {
        CashFlowItemBatchReplacer<T> cashFlowItemBatchReplacer = BatchReplacerFactory.createCashFlowItemBatchReplacer(orgId, periodId);
        AssgrpBatchReplacer<T> assgrpBatchReplacer = BatchReplacerFactory.createAssgrpBatchReplacer(reloadMasterId, assgrpKey);
        cashFlowItemBatchReplacer.setAssgrpBatchReplacer(assgrpBatchReplacer);
        return cashFlowItemBatchReplacer;
    }

    public static <T extends IVoucherEntry> CashFlowItemBatchReplacer<T> createCombinedBatchReplacer(long orgId, long periodId, boolean reloadMasterId, String assgrpKey, Long filterOrgId, Long filterBookTypeId) {
        CashFlowItemBatchReplacer<T> cashFlowItemBatchReplacer = BatchReplacerFactory.createCashFlowItemBatchReplacer(orgId, periodId);
        AssgrpBatchReplacer<T> assgrpBatchReplacer = BatchReplacerFactory.createAssgrpBatchReplacer(reloadMasterId, assgrpKey);
        assgrpBatchReplacer.setFilterPermission(filterOrgId, filterBookTypeId);
        cashFlowItemBatchReplacer.setAssgrpBatchReplacer(assgrpBatchReplacer);
        return cashFlowItemBatchReplacer;
    }
}

