/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.business.service.log.BalChangeLogSaveService;
import kd.fi.gl.business.service.log.CFChangeLogSaveService;

public class GLServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();
    private static Log LOG = LogFactory.getLog((String)"GLServiceFactory");
    private static final ThreadLocal<Map<String, Object>> serviceInstanceMap = new ThreadLocal();

    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        return (T)(serviceInstanceMap.get() != null && serviceInstanceMap.get().containsKey(key) ? serviceInstanceMap.get().get(key) : GLServiceFactory.getService(key));
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"bos-core-api", (Object[])new Object[0]), serviceName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("DesignMetadataService", "kd.bos.service.metadata.design.DesignMetadataServiceImpl");
        serviceMap.put("IFifoSimulateService", "kd.fi.gl.business.service.reciprocal.baldeduct.FifoSimulateServiceImpl");
        serviceMap.put("IFifoRealTimeWriteOffService", "kd.fi.gl.business.service.reciprocal.realtime.FifoRealTimeWriteOffServiceImpl");
        serviceMap.put(BalChangeLogSaveService.class.getSimpleName(), BalChangeLogSaveService.class.getTypeName());
        serviceMap.put(CFChangeLogSaveService.class.getSimpleName(), CFChangeLogSaveService.class.getTypeName());
    }
}

