/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.constant.GLConstants;

public class PeriodService {
    public static List<Long> getAvailablePeriodIds(Long orgId, Long bookTypeId, Long periodid, Long acctId) {
        ArrayList<Long> availablePeriodids = new ArrayList<Long>(12);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select p.fid from t_bd_period p where p.fid < ?", new Object[]{periodid});
        sql.append(" and p.fid >= ? ", new Object[]{periodid / GLConstants.TYPE_PERIOD_L * GLConstants.TYPE_PERIOD_L});
        sql.append("and exists (select 1 from t_gl_balance where forgid = ? ", new Object[]{orgId});
        sql.append(" and fbooktypeid = ? ", new Object[]{bookTypeId});
        sql.append(" and fperiodid = p.fid ", new Object[0]);
        sql.append(" and faccountid = ? )", new Object[]{acctId});
        try (DataSet ds = DB.queryDataSet((String)"PeriodUtil.getAvailablePeriod", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                availablePeriodids.add(row.getLong("fid"));
            }
        }
        return availablePeriodids;
    }

    public static Date getEndDate(long period) {
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)period).toArray());
        return periodDO.getDate("enddate");
    }
}

