/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.ms;

import java.util.function.Consumer;

public class Result<T> {
    private Status status;
    private T value;

    public static <T> Result<T> unavailable() {
        Result<T> result = new Result<T>();
        result.setStatus(Status.UNAVAILABLE);
        return result;
    }

    public static <T> Result<T> success(T value) {
        Result<T> result = new Result<T>();
        result.setValue(value);
        result.setStatus(Status.SUCCESS);
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T orElse(T value) {
        if (this.status == Status.SUCCESS) {
            return this.getValue();
        }
        return value;
    }

    public void ifSuccess(Consumer<? super T> consumer) {
        if (this.status == Status.SUCCESS) {
            consumer.accept(this.value);
        }
    }

    public static enum Status {
        SUCCESS,
        UNAVAILABLE;

    }
}

