/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.orgrootchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgChangeCheckDetail;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrgViewServiceHelper {
    private static final Log log = LogFactory.getLog(OrgViewServiceHelper.class);

    public List<OrgChangeCheckDetail> changeRootOrgViewUp(long oldRootId, long newRootId) {
        log.info("OrgRootChange orgview up start..");
        ArrayList<OrgChangeCheckDetail> checkDetails = new ArrayList<OrgChangeCheckDetail>(16);
        Map<Long, String> orgViews = this.getOrgViews();
        if (orgViews.size() <= 0) {
            return checkDetails;
        }
        Map<Long, Long> rootOrgs = this.getRootOrgByViewIds(orgViews.keySet());
        for (Map.Entry<Long, String> entry : orgViews.entrySet()) {
            Long viewId = entry.getKey();
            Long rootOrgId = rootOrgs.get(viewId);
            if (rootOrgId == 0L || rootOrgId != oldRootId) continue;
            String viewNumber = entry.getValue();
            try {
                List<OrgParam> paramList = this.resetRoot(oldRootId, newRootId, viewNumber);
                paramList.forEach(param -> {
                    if (!param.isSuccess()) {
                        this.addCheckDetail(viewNumber, param.getMsg(), checkDetails);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.addCheckDetail(viewNumber, e.getMessage(), checkDetails);
            }
        }
        log.info("OrgRootChange orgview up end..");
        return checkDetails;
    }

    protected List<OrgParam> resetRoot(Long oldRootId, Long newRootId, String viewNumber) {
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(2);
        OrgParam newParam = new OrgParam();
        newParam.setId(newRootId.longValue());
        newParam.setDuty(viewNumber);
        paramList.add(newParam);
        OrgParam oldParam = new OrgParam();
        oldParam.setId(oldRootId.longValue());
        oldParam.setDuty(viewNumber);
        oldParam.setParentId(newRootId.longValue());
        paramList.add(oldParam);
        try (TXHandle tx = TX.requiresNew((String)"OrgViewServiceHelper.resetRoot");){
            try {
                OrgUnitServiceHelper.addOrUpdate(paramList);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return paramList;
    }

    public Map<Long, String> getOrgViews() {
        HashMap<Long, String> orgViewMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("ismainview", "=", (Object)Character.valueOf('1'));
        List viewIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountingsysviewsch", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        QFilter vIdsFilter = new QFilter("id", "in", (Object)viewIds);
        QFilter treetypeFilter = new QFilter("treetype", "=", (Object)"10");
        DynamicObjectCollection orgViews = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id,number", (QFilter[])new QFilter[]{vIdsFilter, treetypeFilter});
        if (CollectionUtils.isNotEmpty((Collection)orgViews)) {
            orgViews.stream().forEach(k -> orgViewMap.put(k.getLong("id"), k.getString("number")));
        }
        return orgViewMap;
    }

    private Map<Long, Long> getRootOrgByViewIds(Set<Long> viewIds) {
        QFilter viewFilter = new QFilter("view", "in", viewIds);
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,view", (QFilter[])new QFilter[]{viewFilter, parentFilter});
        HashMap<Long, Long> rootOrgs = new HashMap<Long, Long>(orgDyn.size());
        orgDyn.forEach(dyo -> rootOrgs.put(dyo.getLong("view"), dyo.getLong("org")));
        return rootOrgs;
    }

    private void addCheckDetail(String viewNumber, String reason, List<OrgChangeCheckDetail> checkDetails) {
        String solution = ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5347\u7ea7\u6838\u7b97\u4e3b\u89c6\u56fe\u3002", (String)"OrgViewServiceHelper_1", (String)"fi-gl-common", (Object[])new Object[0]);
        OrgChangeCheckDetail checkDetail = new OrgChangeCheckDetail();
        checkDetail.setEntity("bos_org_viewschema");
        checkDetail.setBdNumber(viewNumber);
        checkDetail.setReason(reason);
        checkDetail.setSolution(solution);
        checkDetails.add(checkDetail);
    }
}

