/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.dao.recip.AcccurrentDAO;
import kd.fi.gl.business.service.common.BillParamService;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.business.service.reciprocal.baldeduct.AssgrpFeed;
import kd.fi.gl.business.service.reciprocal.baldeduct.FiFoSimulateParam;
import kd.fi.gl.business.service.reciprocal.baldeduct.UnAcccurrentProcessor;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingDetailResult;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingResult;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingSumarryResult;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.business.vo.reciprocal.AgeRangeVO;
import kd.fi.gl.constant.reciprocal.UnAcccurrent;
import kd.fi.gl.interfaces.service.reciprocal.IFifoSimulateService;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.simulate.balance.vo.BalanceVO;
import kd.fi.gl.util.AssistEntityQueryHelper;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.DataSetUtils;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MultiIndexTreeCache;
import org.apache.commons.lang3.tuple.Pair;

public class FifoSimulateServiceImpl
implements IFifoSimulateService {
    protected static final Log LOG = LogFactory.getLog(FifoSimulateServiceImpl.class);
    protected static final List<String> ACCCURALLFILEDS = Splitter.on((String)",").trimResults().splitToList((CharSequence)"id, org, booktype, account,assgrp.id assgrpid,assgrp.value assval, sourcetype, currency, localcurrency, amountfor, amount , amountbalfor, amountbal, voucherid, voucherentry, description, biznum, entrydc,bizdate,expiredate, bookeddate, status,accounttable,masterid,period");

    @Override
    public DataSet executeSimulateSumResult(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, List<AgeRangeVO> rangeVOs) {
        return this.executeSimulate(fifoParam, flexProps, rangeVOs, null);
    }

    @Override
    public DataSet executeSimulateDetailResult(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps) {
        return this.executeSimulate(fifoParam, flexProps, Collections.emptyList(), null);
    }

    @Override
    public DataSet executeSimulateDetailResult(FiFoSimulateParam fifoParam, Set<Long> assgrpIds) {
        List<AccountFlexVO> flexProps = FifoSimulateServiceImpl.assgrpConvertFlexFieldValues(fifoParam.getOrgId(), fifoParam.getAcctTableId(), fifoParam.getAccountId(), assgrpIds);
        return this.executeSimulate(fifoParam, flexProps, Collections.emptyList(), assgrpIds);
    }

    public DataSet executeSimulate(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, List<AgeRangeVO> rangeVOs, Set<Long> assgrpIds) {
        this.validateParameters(fifoParam, flexProps);
        DebugTrace.action(() -> {
            LOG.info("FifoSimulateServiceImpl.executeSimulate_fifoParam:{} flexProps:{} rangeVOs:{} assgrpIds:{}", new Object[]{fifoParam, flexProps, rangeVOs, assgrpIds});
            LOG.info("FifoSimulateServiceImpl.executeSimulate_isEnableRealTimeWriteOff:{} isRuningRealTimeWriteOff:{}", (Object)BillParamService.isEnableRealTimeWriteOff(), (Object)UnAcccurrentUpdateUtil.isRuningRealTimeWriteOff(fifoParam.getOrgId(), fifoParam.getBookTypeId(), fifoParam.getAccountId()));
        });
        if (!BillParamService.isEnableRealTimeWriteOff() || UnAcccurrentUpdateUtil.isRuningRealTimeWriteOff(fifoParam.getOrgId(), fifoParam.getBookTypeId(), fifoParam.getAccountId())) {
            LOG.info("FifoSimulateServiceImpl.executeSimulate \u5168\u90e8\u7ef4\u5ea6\u5012\u7b97");
            return FifoSimulateServiceImpl.balanceWriteOff(fifoParam, flexProps, assgrpIds, rangeVOs);
        }
        AssgrpFeed<Long> assgrpFeed = this.buildUnAccurrentAssgrp(fifoParam, flexProps);
        if (CollectionUtils.isNotEmpty(assgrpIds)) {
            for (Long currencyId : fifoParam.getCurrencyIds()) {
                for (Long l : assgrpIds) {
                    assgrpFeed.feedChangeRecord(currencyId, l);
                }
            }
        }
        DebugTrace.action(() -> LOG.info("FifoSimulateServiceImpl.executeSimulate_assgrpFeed:{}", (Object)assgrpFeed));
        if (Objects.isNull(assgrpIds) && !assgrpFeed.isFullReCalculate()) {
            this.setUnCalBalAssgrpValue(fifoParam, assgrpFeed);
            this.setUnCalStatusAssgrpValue(fifoParam, assgrpFeed);
        }
        DebugTrace.action(() -> LOG.info("FifoSimulateServiceImpl.executeSimulate_assgrpFeed:{}", (Object)assgrpFeed));
        if (assgrpFeed.isFullReCalculate()) {
            return FifoSimulateServiceImpl.balanceWriteOff(fifoParam, flexProps, assgrpIds, rangeVOs);
        }
        Set<Long> needCalAssgrpIds = assgrpFeed.getCalculateAssgrp().entrySet().stream().flatMap(x -> ((Set)x.getValue()).stream()).collect(Collectors.toSet());
        DebugTrace.action(() -> LOG.info("FifoSimulateServiceImpl.executeSimulate_needCalAssgrpIds\uff1a{}", (Object)needCalAssgrpIds));
        if (needCalAssgrpIds.size() == 0) {
            LOG.info("FifoSimulateServiceImpl.executeSimulate \u672a\u6838\u9500\u5f80\u6765\u8d26\u67e5\u8be2");
            return FifoSimulateServiceImpl.queryUnAcccurrent(fifoParam, flexProps, null, null, rangeVOs);
        }
        DataSet dataSet = FifoSimulateServiceImpl.balanceWriteOff(fifoParam, flexProps, needCalAssgrpIds, rangeVOs);
        if (Objects.isNull(assgrpIds)) {
            for (Map.Entry entry : assgrpFeed.getCalculateAssgrp().entrySet()) {
                DataSet unAcccurrentDs = FifoSimulateServiceImpl.queryUnAcccurrent(fifoParam, flexProps, (Long)entry.getKey(), (Set)entry.getValue(), rangeVOs);
                dataSet = Objects.isNull(dataSet) ? unAcccurrentDs : dataSet.union(unAcccurrentDs);
            }
        }
        return dataSet;
    }

    protected static DataSet balanceWriteOff(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds, List<AgeRangeVO> rangeVOs) {
        PerformanceWatch watch = new PerformanceWatch(FifoSimulateServiceImpl.class, "balanceWriteOff", false);
        watch.reset();
        watch.start("queryBalance");
        DataSet balanceData = FifoSimulateServiceImpl.queryBalance(fifoParam, flexProps, assgrpIds);
        if (DebugTrace.enable()) {
            LOG.info("FifoSimulateServiceImpl.balanceWriteOff_fifoParam\uff1a{}", (Object)fifoParam);
            DataSetHelper.logDataSet("FifoSimulateServiceImpl.balanceWriteOff_balanceData:", balanceData);
        }
        watch.stop();
        watch.start("balanceToTreeCache");
        ArrayList<BalanceVO> dimensionList = new ArrayList<BalanceVO>(8);
        MultiIndexTreeCache<BalanceVO> balanceCache = new MultiIndexTreeCache<BalanceVO>("balance_deposit", 10000000);
        while (balanceData.hasNext()) {
            Row row = balanceData.next();
            BigDecimal amountbalfor = row.getBigDecimal("amountbalfor");
            BigDecimal amountbal = row.getBigDecimal("amountbal");
            int dcFor = fifoParam.getAcctDc() * amountbalfor.compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
            int dc = fifoParam.getAcctDc() * amountbal.compareTo(BigDecimal.ZERO) > 0 ? 1 : -1;
            BalanceVO balanceVO = new BalanceVO(amountbalfor.abs(), amountbal.abs(), dcFor, dc);
            Object[] com = FifoSimulateServiceImpl.comAssgrpKey(row, flexProps);
            balanceCache.addData(balanceVO, com);
            dimensionList.add(balanceVO);
        }
        balanceData.close();
        watch.stop();
        watch.start("deductAllBal");
        DataSet dataSet = FifoSimulateServiceImpl.deductAllBal(fifoParam, flexProps, assgrpIds, balanceCache, dimensionList, rangeVOs);
        watch.stop();
        DebugTrace.action(() -> DataSetHelper.logDataSet("FifoSimulateServiceImpl.balanceWriteOff_dataSet:", dataSet));
        LOG.info("FifoSimulateServiceImpl.balanceWriteOff_cost:{}", (Object)watch.show(true));
        return dataSet;
    }

    private AssgrpFeed<Long> buildUnAccurrentAssgrp(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps) {
        QFilter filter = fifoParam.buildCommonQFilter();
        if (fifoParam.getCurrencyIds().size() > 0) {
            filter.and(new QFilter("currency", "in", fifoParam.getCurrencyIds()));
        }
        Map<String, Set<Long>> flexFieldToValues = FifoSimulateServiceImpl.getFlexFieldToValues(flexProps);
        filter.and(new QFilter(UnAcccurrent.ISORIGINPOINT, "=", (Object)"1"));
        String selectFields = "currency,assgrp,forwriteoffdate,localwriteoffdate";
        AssgrpFeed<Long> assgrpFeed = new AssgrpFeed<Long>(fifoParam.getBookedDate(), fifoParam.getAccountId(), 1000);
        try (DataSet dataSet = AssistEntityQueryHelper.queryWithORM(UnAcccurrent.ENTITY, flexFieldToValues, Arrays.asList(filter.toArray()), Arrays.asList(selectFields.split(",")), null, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long currency = next.getLong("currency");
                Long assgrp = next.getLong("assgrp");
                assgrpFeed.feedUnAcccurrentRecord(next.getDate("forwriteoffdate"), next.getDate("localwriteoffdate"), currency, assgrp);
                if (!assgrpFeed.isFullReCalculate()) continue;
                break;
            }
        }
        return assgrpFeed;
    }

    private static Map<String, Set<Long>> getFlexFieldToValues(List<AccountFlexVO> flexProps) {
        HashMap<String, Set<Long>> flexFieldToValues = new HashMap<String, Set<Long>>(flexProps.size());
        for (AccountFlexVO acctFlexVO : flexProps) {
            if (!Objects.nonNull(acctFlexVO.getFlexField()) || !Objects.nonNull(acctFlexVO.getValues())) continue;
            flexFieldToValues.computeIfAbsent(acctFlexVO.getFlexField(), x -> new HashSet()).addAll(acctFlexVO.getValues());
        }
        return flexFieldToValues;
    }

    private void setUnCalBalAssgrpValue(FiFoSimulateParam fifoParam, AssgrpFeed<Long> assgrpFeed) {
        QFilter filter = fifoParam.buildCommonQFilter();
        if (fifoParam.getCurrencyIds().size() > 0) {
            filter.and(new QFilter("currency", "in", fifoParam.getCurrencyIds()));
        }
        filter.and(new QFilter("acccalculated", "=", (Object)"0"));
        filter.and(new QFilter("accassgrp", ">", (Object)0L));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (String)"gl_balance_log", (String)"account,currency,accassgrp", (QFilter[])filter.toArray(), null).distinct();){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long currency = next.getLong("currency");
                Long accassgrp = next.getLong("accassgrp");
                assgrpFeed.feedChangeRecord(currency, accassgrp);
            }
        }
    }

    private void setUnCalStatusAssgrpValue(FiFoSimulateParam fifoParam, AssgrpFeed<Long> assgrpFeed) {
        QFilter filter = fifoParam.buildCommonQFilter();
        if (fifoParam.getCurrencyIds().size() > 0) {
            filter.and(new QFilter("currency", "in", fifoParam.getCurrencyIds()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (String)"gl_unacccurrent_status", (String)"account,currency,assgrp", (QFilter[])filter.toArray(), (String)" assgrp asc").distinct();){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long currency = next.getLong("currency");
                Long accassgrp = next.getLong("assgrp");
                assgrpFeed.feedChangeRecord(currency, accassgrp);
            }
        }
    }

    protected static DataSet queryUnAcccurrent(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Long currencyId, Set<Long> needCalAssgrpIds, List<AgeRangeVO> rangeVOs) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>(8);
        filter.add(fifoParam.buildCommonQFilter());
        filter.add(new QFilter("bookeddate", "<=", (Object)fifoParam.getBookedDate()));
        if (fifoParam.getCurrencyIds().size() > 0) {
            filter.add(new QFilter("currency", "in", fifoParam.getCurrencyIds()));
        }
        if (Objects.nonNull(currencyId)) {
            filter.add(new QFilter("currency", "=", (Object)currencyId));
        }
        if (Objects.nonNull(needCalAssgrpIds)) {
            filter.add(new QFilter("assgrp", "not in", needCalAssgrpIds));
        }
        DebugTrace.action(() -> LOG.info("FifoSimulateServiceImpl.queryUnAcccurrent_filter:{}", (Object)filter));
        Map<String, Set<Long>> flexFieldToValues = FifoSimulateServiceImpl.getFlexFieldToValues(flexProps);
        AgingResult agingResult = FifoSimulateServiceImpl.buildAgingResult(fifoParam, flexProps, rangeVOs);
        try (DataSet dataSet = AssistEntityQueryHelper.queryWithORM(UnAcccurrent.ENTITY, flexFieldToValues, filter, ACCCURALLFILEDS, null, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ReciprocalRecord acccurrent = AcccurrentDAO.createAcccurrent(row);
                acccurrent.setLeavingAmountFor(acccurrent.getAmountBalFor());
                acccurrent.setLeavingAmount(acccurrent.getAmountBal());
                agingResult.add(acccurrent);
            }
        }
        return agingResult.getAgingResult();
    }

    protected static AgingResult buildAgingResult(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, List<AgeRangeVO> rangeVOs) {
        if (CollectionUtils.isNotEmpty(rangeVOs)) {
            return new AgingSumarryResult(rangeVOs, flexProps, fifoParam.isShowByExpireDate(), fifoParam.getExpiredate(), fifoParam.isSynCurrency());
        }
        return new AgingDetailResult(flexProps, fifoParam.isShowByExpireDate(), fifoParam.getExpiredate(), fifoParam.isSynCurrency());
    }

    protected static DataSet deductAllBal(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds, MultiIndexTreeCache<BalanceVO> balanceCache, List<BalanceVO> dimensionList, List<AgeRangeVO> rangeVOs) {
        Pair<Date, Date> beforeRangDate = Pair.of((Object)fifoParam.getBookedDate(), (Object)fifoParam.getBookedDate());
        Date reciInitBeginDate = FifoSimulateServiceImpl.reciInitBeginDate(fifoParam.buildCommonQFilter());
        AgingResult agingResult = FifoSimulateServiceImpl.buildAgingResult(fifoParam, flexProps, rangeVOs);
        UnAcccurrentProcessor processor = new UnAcccurrentProcessor(balanceCache, dimensionList);
        block36: do {
            beforeRangDate = FifoSimulateServiceImpl.getBeforeRangDate(reciInitBeginDate, beforeRangDate);
            QFilter filter = new QFilter("status", "in", Arrays.asList("0", "1"));
            filter.and(new QFilter("bookeddate", "<=", (Object)fifoParam.getBookedDate()));
            filter.and(new QFilter("bizdate", ">", beforeRangDate.getLeft()));
            filter.and(new QFilter("bizdate", "<=", beforeRangDate.getRight()));
            String orderBy = "currency asc, assgrp asc, bizdate desc, id desc ";
            try (DataSet beforeAccCur = FifoSimulateServiceImpl.queryAccCurrentByDate(fifoParam, flexProps, assgrpIds, ACCCURALLFILEDS, filter, orderBy);
                 DataSet refoundDs = FifoSimulateServiceImpl.writeOffRefoundRecord(fifoParam, flexProps, assgrpIds, beforeRangDate);
                 DataSet beforeResult = refoundDs.hasNext() ? DataSetUtils.gainSumDataSet(beforeAccCur.union(refoundDs)).orderBy(new String[]{"currency asc", "assgrpid asc", "bizdate desc", " id desc "}) : beforeAccCur;){
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet("FifoSimulateServiceImpl.deductAllBal_beforeResult:", beforeResult);
                }
                LOG.info("==deductAllBal begin:" + filter);
                while (true) {
                    if (beforeResult.hasNext()) {
                        Row row = beforeResult.next();
                        Object[] curGroupKey = FifoSimulateServiceImpl.comAssgrpKey(row, flexProps);
                        ReciprocalRecord unAcccurrent = processor.feed(curGroupKey, row.getBigDecimal("amountbalfor"), row.getBigDecimal("amountbal"), row.getDate("bookeddate"), () -> AcccurrentDAO.createAcccurrent(row));
                        if (Objects.nonNull(unAcccurrent)) {
                            agingResult.add(unAcccurrent);
                        }
                        if (processor.existBalanceVO()) continue;
                        DataSet dataSet = agingResult.getAgingResult();
                        return dataSet;
                        continue;
                    }
                    continue block36;
                    break;
                }
            }
        } while (FifoSimulateServiceImpl.preInitBeginDate().compareTo((Date)beforeRangDate.getLeft()) != 0);
        return agingResult.getAgingResult();
    }

    protected static DataSet writeOffRefoundRecord(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds, Pair<Date, Date> beforeRangDate) {
        String flexField;
        Object flexField2;
        SqlBuilder buyerSql = new SqlBuilder();
        buyerSql.append("select ", new Object[0]);
        for (AccountFlexVO acctFlexVO : flexProps) {
            flexField2 = acctFlexVO.getFlexField();
            if (!Objects.nonNull(flexField2)) continue;
            buyerSql.append((String)flexField2 + ".fvalue", new Object[0]).append("\"" + (String)flexField2 + "\",", new Object[0]);
        }
        buyerSql.append("buyer.fid id, buyer.forgid org, buyer.fbooktypeid booktype, buyer.faccountid account, buyer.fassgrpid assgrpid, ass.fvalue assval, buyer.fsourcetype sourcetype, buyer.fcurrencyid currency ,buyer.flocalcurrencyid localcurrency, 0 amountfor, 0 amount, l.famountfor  amountbalfor, l.famount  amountbal, buyer.fvoucherid voucherid, buyer.fvchentryid voucherentry, buyer.fdescription description, buyer.fbiznum biznum, buyer.fentrydc entrydc,buyer.fbizdate bizdate,buyer.fexpiredate expiredate, buyer.fbookeddate bookeddate, buyer.fstatus status, buyer.facctableid accounttable, buyer.fmasterid masterid, buyer.fperiodid period", new Object[0]);
        buyerSql.append(" from t_gl_reciprocal_log l", new Object[0]).append(" inner join t_gl_acccurrent buyer on l.fbuyerentryid = buyer.fid", new Object[0]).append(" inner join t_gl_acccurrent wf on l.fwriteoffentryid = wf.fid", new Object[0]).append(" inner join t_gl_assist ass on buyer.fassgrpid = ass.fid", new Object[0]);
        for (AccountFlexVO accountFlexVO : flexProps) {
            flexField2 = accountFlexVO.getFlexField();
            if (!Objects.nonNull(flexField2)) continue;
            buyerSql.append(" LEFT JOIN t_gl_assist_bd " + (String)flexField2 + " ON " + (String)flexField2 + ".fid=buyer.fassgrpid and " + (String)flexField2 + ".fflexfield = ?", new Object[]{flexField2});
        }
        buyerSql.append(" where l.forgid = ?", new Object[]{fifoParam.getOrgId()}).append(" and l.fbooktypeid = ?", new Object[]{fifoParam.getBookTypeId()}).append(" and l.facctableid = ?", new Object[]{fifoParam.getAcctTableId()}).append(" and l.faccountid = ? ", new Object[]{fifoParam.getAccountId()}).append(" and wf.forgid = ?", new Object[]{fifoParam.getOrgId()}).append(" and wf.fbooktypeid = ?", new Object[]{fifoParam.getBookTypeId()}).append(" and wf.facctableid = ?", new Object[]{fifoParam.getAcctTableId()}).append(" and wf.fbookeddate > ?", new Object[]{fifoParam.getBookedDate()}).append(" and ? < buyer.fbizdate and buyer.fbizdate <= ?", new Object[]{beforeRangDate.getLeft(), beforeRangDate.getRight()});
        if (!fifoParam.getCurrencyIds().isEmpty()) {
            buyerSql.appendIn(" and buyer.fcurrencyid", new ArrayList<Long>(fifoParam.getCurrencyIds()));
        }
        if (CollectionUtils.isNotEmpty(assgrpIds)) {
            buyerSql.appendIn(" and buyer.fassgrpid", new ArrayList<Long>(assgrpIds));
        }
        for (AccountFlexVO acctFlexVO : flexProps) {
            if (!Objects.nonNull(acctFlexVO.getFlexField()) || !Objects.nonNull(acctFlexVO.getValues()) || acctFlexVO.getValues().size() <= 0) continue;
            buyerSql.appendIn(" and " + acctFlexVO.getFlexField() + ".fvalue", new ArrayList<Long>(acctFlexVO.getValues()));
        }
        if (DebugTrace.enable()) {
            LOG.info("FifoSimulateServiceImpl.writeOffRefoundRecord_buyerSql:{}", (Object)buyerSql);
        }
        DataSet buyerDs = DB.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)buyerSql);
        SqlBuilder wfSql = new SqlBuilder();
        wfSql.append("select ", new Object[0]);
        for (AccountFlexVO acctFlexVO : flexProps) {
            flexField = acctFlexVO.getFlexField();
            if (!Objects.nonNull(flexField)) continue;
            wfSql.append(flexField + ".fvalue", new Object[0]).append("\"" + flexField + "\",", new Object[0]);
        }
        wfSql.append("wf.fid id, wf.forgid org, wf.fbooktypeid booktype, wf.faccountid account, wf.fassgrpid fassgrpid, ass.fvalue assval, wf.fsourcetype sourcetype, wf.fcurrencyid currency ,wf.flocalcurrencyid localcurrency, 0 amountfor, 0 amount, -1 * l.famountfor  amountbalfor, -1 * l.famount  amountbal, wf.fvoucherid voucherid, wf.fvchentryid voucherentry, wf.fdescription description, wf.fbiznum biznum, wf.fentrydc entrydc,wf.fbizdate bizdate,wf.fexpiredate expiredate, wf.fbookeddate bookeddate, wf.fstatus status, wf.facctableid accounttable, wf.fmasterid masterid, wf.fperiodid period", new Object[0]);
        wfSql.append(" from t_gl_reciprocal_log l", new Object[0]).append(" inner join t_gl_acccurrent buyer on l.fbuyerentryid = buyer.fid", new Object[0]).append(" inner join t_gl_acccurrent wf on l.fwriteoffentryid = wf.fid", new Object[0]).append(" inner join t_gl_assist ass on wf.fassgrpid = ass.fid", new Object[0]);
        for (AccountFlexVO acctFlexVO : flexProps) {
            flexField = acctFlexVO.getFlexField();
            if (!Objects.nonNull(flexField)) continue;
            wfSql.append(" LEFT JOIN t_gl_assist_bd " + flexField + " ON " + flexField + ".fid=buyer.fassgrpid and " + flexField + ".fflexfield = ?", new Object[]{flexField});
        }
        wfSql.append(" where l.forgid = ?", new Object[]{fifoParam.getOrgId()}).append(" and l.fbooktypeid = ?", new Object[]{fifoParam.getBookTypeId()}).append(" and l.facctableid = ?", new Object[]{fifoParam.getAcctTableId()}).append(" and l.faccountid = ? ", new Object[]{fifoParam.getAccountId()}).append(" and buyer.forgid = ?", new Object[]{fifoParam.getOrgId()}).append(" and buyer.fbooktypeid = ?", new Object[]{fifoParam.getBookTypeId()}).append(" and buyer.facctableid = ?", new Object[]{fifoParam.getAcctTableId()}).append(" and buyer.fbookeddate > ?", new Object[]{fifoParam.getBookedDate()}).append(" and ? < wf.fbizdate and wf.fbizdate <= ?", new Object[]{beforeRangDate.getLeft(), beforeRangDate.getRight()});
        if (!fifoParam.getCurrencyIds().isEmpty()) {
            buyerSql.appendIn(" and wf.fcurrencyid", new ArrayList<Long>(fifoParam.getCurrencyIds()));
        }
        if (CollectionUtils.isNotEmpty(assgrpIds)) {
            buyerSql.appendIn(" and wf.fassgrpid", new ArrayList<Long>(assgrpIds));
        }
        for (AccountFlexVO acctFlexVO : flexProps) {
            if (!Objects.nonNull(acctFlexVO.getFlexField()) || !Objects.nonNull(acctFlexVO.getValues()) || acctFlexVO.getValues().size() <= 0) continue;
            wfSql.appendIn(" and " + acctFlexVO.getFlexField() + ".fvalue", new ArrayList<Long>(acctFlexVO.getValues()));
        }
        if (DebugTrace.enable()) {
            LOG.info("FifoSimulateServiceImpl.writeOffRefoundRecord_wfSql:{}", (Object)wfSql);
        }
        DataSet wfDs = DB.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)wfSql);
        return buyerDs.union(wfDs);
    }

    protected static Date reciInitBeginDate(QFilter filter) {
        filter.and(new QFilter("isendinit", "=", (Object)Boolean.TRUE));
        try (DataSet acctDs = QueryServiceHelper.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (String)"gl_reci_init_state", (String)"endinitperiod.begindate", (QFilter[])filter.toArray(), (String)" endinitperiod asc");){
            if (acctDs.hasNext()) {
                Date date = acctDs.next().getDate("endinitperiod.begindate");
                return date;
            }
        }
        return null;
    }

    protected static Pair<Date, Date> getBeforeRangDate(Date reciInitBeginDate, Pair<Date, Date> bookedDateRang) {
        if (Objects.isNull(reciInitBeginDate) || ((Date)bookedDateRang.getRight()).compareTo(reciInitBeginDate) < 0) {
            bookedDateRang = Pair.of((Object)FifoSimulateServiceImpl.preInitBeginDate(), (Object)bookedDateRang.getLeft());
            return bookedDateRang;
        }
        Date startBookedDate = FifoSimulateServiceImpl.addMonths((Date)bookedDateRang.getLeft());
        bookedDateRang = Pair.of((Object)startBookedDate, (Object)bookedDateRang.getLeft());
        return bookedDateRang;
    }

    protected static Date preInitBeginDate() {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)GLUtil.getInitBeginDate(), (int)-1);
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    protected static Object[] comAssgrpKey(Row row, List<AccountFlexVO> flexProps) {
        Object[] dimensionKey = new Object[flexProps.size() + 1];
        dimensionKey[0] = row.getLong("currency");
        int i = 1;
        for (AccountFlexVO flexField : flexProps) {
            dimensionKey[i] = row.getString(flexField.getFlexField());
            ++i;
        }
        return dimensionKey;
    }

    protected static DataSet queryBalance(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds) {
        Date maxMonthDate = DateUtils.getMaxMonthDate(fifoParam.getBookedDate());
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(fifoParam.getOrgId(), fifoParam.getBookTypeId());
        if (bookInfo == null) {
            throw new KDBizException("AccountBook cannot be null");
        }
        DynamicObject periodDy = PeriodUtil.getPeriodByDate((Date)maxMonthDate, (long)bookInfo.getPeriodTypeId());
        Preconditions.checkNotNull((Object)periodDy, (Object)ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6838\u9500\u6a21\u5f0f\u4e0b\u67e5\u8be2\u4e0d\u5230\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u671f\u95f4\u3002", (String)"FifoSimulateServiceImpl_0", (String)"fi-gl-common", (Object[])new Object[0]));
        DataSet balance = FifoSimulateServiceImpl.queryCurPeriodBalance(fifoParam, periodDy.getLong("id"), flexProps, FifoSimulateServiceImpl.getBalanceSelFields(Arrays.asList("endfor amountbalfor", "endlocal amountbal")));
        if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)fifoParam.getBookedDate(), (Date)periodDy.getDate("enddate"))) {
            Pair rangDate = Pair.of((Object)fifoParam.getBookedDate(), (Object)periodDy.getDate("enddate"));
            DataSet curPeriodAmount = FifoSimulateServiceImpl.getCurPeriodAmount(fifoParam, flexProps, assgrpIds, (Pair<Date, Date>)rangDate);
            balance = balance.union(curPeriodAmount);
            balance = DataSetUtils.gainSumDataSet(balance);
        }
        StringBuilder filter = new StringBuilder(" (amountbalfor != 0 or amountbal != 0)");
        for (AccountFlexVO accountFlexVO : flexProps) {
            if (!Objects.nonNull(accountFlexVO.getFlexField()) || !Objects.nonNull(accountFlexVO.getValues()) || accountFlexVO.getValues().size() <= 0) continue;
            Set assVals = accountFlexVO.getValues().stream().map(String::valueOf).collect(Collectors.toSet());
            filter.append(" and ").append(accountFlexVO.getFlexField()).append(" in (").append(String.join((CharSequence)",", assVals)).append(")");
        }
        balance = balance.filter(filter.toString());
        balance = balance.addField(bookInfo.getBaseCurrencyId() + "", "currencylocal");
        return balance;
    }

    private static DataSet queryCurPeriodBalance(FiFoSimulateParam fifoParam, Long periodId, List<AccountFlexVO> flexProps, List<String> fileds) {
        ArrayList<QFilter> balanceFilters = new ArrayList<QFilter>(16);
        balanceFilters.add(fifoParam.buildCommonQFilter());
        balanceFilters.add(FifoSimulateServiceImpl.getPeriodQFilter(fifoParam.getOrgId(), periodId));
        Set<Long> currencys = fifoParam.getCurrencyIds();
        if (Objects.nonNull(currencys) && currencys.size() > 0) {
            balanceFilters.add(new QFilter("currency", "in", currencys));
        }
        if (DebugTrace.enable()) {
            LOG.info("FifoSimulateServiceImpl.queryCurPeriodBalance_filter:{}", balanceFilters);
        }
        Map<String, Set<Long>> flexFieldToValues = FifoSimulateServiceImpl.getFlexFieldToValues(flexProps);
        DataSet balance = AssistEntityQueryHelper.queryWithORM("gl_balance", flexFieldToValues, balanceFilters, fileds, "", null);
        return DataSetUtils.gainSumDataSet(balance);
    }

    private static DataSet getCurPeriodAmount(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds, Pair<Date, Date> rangDate) {
        String amtDc = "-1 * " + fifoParam.getAcctDc();
        List acccurFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)("org, booktype, account, currency,  " + amtDc + "* amountfor amountbalfor,  " + amtDc + " * amount amountbal"));
        QFilter filter = new QFilter("bookeddate", ">", rangDate.getLeft());
        filter.and(new QFilter("bookeddate", "<=", rangDate.getRight()));
        return FifoSimulateServiceImpl.queryAccCurrentByDate(fifoParam, flexProps, assgrpIds, acccurFields, filter, null);
    }

    protected static DataSet queryAccCurrentByDate(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps, Set<Long> assgrpIds, List<String> selFields, QFilter qfilter, String orderBy) {
        Set<Long> currencys;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(8);
        filter.add(fifoParam.buildCommonQFilter());
        if (Objects.nonNull(qfilter)) {
            filter.add(qfilter);
        }
        if (Objects.nonNull(currencys = fifoParam.getCurrencyIds()) && currencys.size() > 0) {
            filter.add(new QFilter("currency", "in", currencys));
        }
        if (Objects.nonNull(assgrpIds) && assgrpIds.size() > 0) {
            filter.add(new QFilter("assgrp", "in", assgrpIds));
        }
        if (DebugTrace.enable()) {
            LOG.info("FifoSimulateServiceImpl.queryAccCurrentByDate_filter:{}", filter);
        }
        DataSet dataSet = AssistEntityQueryHelper.queryWithORM("gl_acccurrent", new ArrayList<String>(flexProps.stream().map(AccountFlexVO::getFlexField).collect(Collectors.toSet())), filter, selFields, orderBy, null);
        return dataSet;
    }

    private static QFilter getPeriodQFilter(Long orgId, Long periodId) {
        QFilter filter = new QFilter("period", ">=", (Object)PeriodUtil.retainPeriodType((long)periodId));
        filter.and(new QFilter("period", "<=", (Object)periodId));
        filter.and(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)periodId, (Long[])new Long[]{orgId})));
        return filter;
    }

    private static List<String> getBalanceSelFields(List<String> fields) {
        ArrayList<String> allFields = new ArrayList<String>(5 + fields.size());
        allFields.add("org");
        allFields.add("booktype");
        allFields.add("account");
        allFields.add("currency");
        allFields.addAll(fields);
        return allFields;
    }

    private static List<AccountFlexVO> assgrpConvertFlexFieldValues(Long orgId, Long acctTableId, Long acctMasterId, Set<Long> assgrpIds) {
        HashMap<String, Set> flexFieldToValues = new HashMap<String, Set>(8);
        QFilter filter = new QFilter("masterid", "=", (Object)acctMasterId);
        try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)acctTableId, (String)"checkitementry.asstactitem.flexfield, checkitementry.enaccheck", Collections.singletonList(filter));){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                if (!next.getBoolean("checkitementry.enaccheck").booleanValue()) continue;
                flexFieldToValues.computeIfAbsent(next.getString("checkitementry.asstactitem.flexfield"), x -> new HashSet(8));
            }
        }
        if (Objects.nonNull(assgrpIds)) {
            QFilter hgFilter = new QFilter("hg", "in", assgrpIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)FifoSimulateServiceImpl.class.getName(), (String)"gl_assist_bd", (String)"asstype,assval", (QFilter[])hgFilter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Set asstype = (Set)flexFieldToValues.get(row.getString("asstype"));
                    if (!CollectionUtils.isNotEmpty((Collection)asstype)) continue;
                    asstype.add(row.getLong("assval"));
                }
            }
        }
        ArrayList<AccountFlexVO> flexProps = new ArrayList<AccountFlexVO>(8);
        flexFieldToValues.forEach((k, v) -> flexProps.add(new AccountFlexVO((String)k, (Set<Long>)v)));
        return flexProps;
    }

    private static Integer getRetralMonths() {
        return Integer.parseInt(BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.writeOff.months", (String)"6"));
    }

    public static Date addMonths(Date date) {
        int amount = FifoSimulateServiceImpl.getRetralMonths() * -1;
        return FifoSimulateServiceImpl.add(date, 2, amount);
    }

    private void validateParameters(FiFoSimulateParam fifoParam, List<AccountFlexVO> flexProps) {
        if (fifoParam == null) {
            throw new IllegalArgumentException("fifoParam cannot be null");
        }
        if (flexProps == null) {
            throw new IllegalArgumentException("flexProps cannot be null");
        }
        if (fifoParam.getBookedDate() == null) {
            throw new IllegalArgumentException("fifoParam.getBookedDate cannot be null");
        }
    }
}

