/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.baldeduct;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.simulate.balance.vo.BalanceVO;
import kd.fi.gl.util.MultiIndexTreeCache;

public class UnAcccurrentProcessor {
    protected static final Log LOG = LogFactory.getLog(UnAcccurrentProcessor.class);
    private final MultiIndexTreeCache<BalanceVO> balanceCache;
    private final List<BalanceVO> dimensionList;
    private final MultiIndexTreeCache<OriginDate> originPointMap = new MultiIndexTreeCache("originPointMap", 1000000);

    public UnAcccurrentProcessor(MultiIndexTreeCache<BalanceVO> balanceCache, List<BalanceVO> dimensionList) {
        this.balanceCache = balanceCache;
        this.dimensionList = dimensionList;
    }

    public ReciprocalRecord feed(Object[] curGroupKey, BigDecimal amountbalfor, BigDecimal amountbal, Date bookeddate, Supplier<ReciprocalRecord> recordCreator) {
        BalanceVO balanceVO = this.balanceCache.retrieval(curGroupKey);
        if (Objects.isNull(balanceVO)) {
            return null;
        }
        boolean balZero = this.isBalZero(balanceVO);
        if (balZero) {
            this.dimensionList.remove(balanceVO);
            return null;
        }
        BigDecimal deductAmountFor = BigDecimal.ZERO;
        if (balanceVO.getDcFor() == 1 && amountbalfor.compareTo(BigDecimal.ZERO) > 0 || balanceVO.getDcFor() == -1 && amountbalfor.compareTo(BigDecimal.ZERO) < 0) {
            deductAmountFor = balanceVO.deductFor(amountbalfor.abs());
        }
        BigDecimal deductAmount = BigDecimal.ZERO;
        if (balanceVO.getDc() == 1 && amountbal.compareTo(BigDecimal.ZERO) > 0 || balanceVO.getDc() == -1 && amountbal.compareTo(BigDecimal.ZERO) < 0) {
            deductAmount = balanceVO.deduct(amountbal.abs());
        }
        if (DebugTrace.enable()) {
            LOG.info("==deductAmountFor:{}, deductAmount:{}, bizdate:{}", new Object[]{deductAmountFor, deductAmount, bookeddate});
        }
        OriginDate originDate = this.originPointMap.retrieval(curGroupKey);
        if (deductAmountFor.compareTo(BigDecimal.ZERO) > 0 || deductAmount.compareTo(BigDecimal.ZERO) > 0) {
            ReciprocalRecord acccurrent = recordCreator.get();
            acccurrent.setLeavingAmountFor(deductAmountFor.multiply(new BigDecimal(balanceVO.getDcFor())));
            acccurrent.setLeavingAmount(deductAmount.multiply(new BigDecimal(balanceVO.getDc())));
            if (Objects.isNull(originDate)) {
                originDate = new OriginDate(true, acccurrent.getBookeddate(), acccurrent.getBookeddate());
                this.originPointMap.addData(originDate, curGroupKey);
            } else if (originDate.isSameDirection) {
                originDate.forWriteOffDate = acccurrent.getBookeddate();
                originDate.localWriteOffDate = acccurrent.getBookeddate();
            }
            if (balanceVO.getLeavingAmountFor().compareTo(BigDecimal.ZERO) == 0) {
                acccurrent.setForWriteOffDate(originDate.forWriteOffDate);
            }
            if (balanceVO.getLeavingAmount().compareTo(BigDecimal.ZERO) == 0) {
                acccurrent.setLocalWriteOffDate(originDate.localWriteOffDate);
            }
            return acccurrent;
        }
        if (Objects.isNull(originDate)) {
            this.originPointMap.addData(new OriginDate(false, bookeddate, bookeddate), curGroupKey);
        }
        return null;
    }

    public boolean isBalZero(BalanceVO balanceVO) {
        return balanceVO.getLeavingAmountFor().compareTo(BigDecimal.ZERO) == 0 && balanceVO.getLeavingAmount().compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean existBalanceVO() {
        return this.dimensionList.size() > 0;
    }

    protected static class OriginDate {
        private final boolean isSameDirection;
        private Date forWriteOffDate;
        private Date localWriteOffDate;

        public OriginDate(boolean isSameDirection, Date forWriteOffDate, Date localWriteOffDate) {
            this.isSameDirection = isSameDirection;
            this.forWriteOffDate = forWriteOffDate;
            this.localWriteOffDate = localWriteOffDate;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginDate other = (OriginDate)obj;
            if (!Objects.equals(this.isSameDirection, other.isSameDirection)) {
                return false;
            }
            if (!Objects.equals(this.forWriteOffDate, other.forWriteOffDate)) {
                return false;
            }
            return Objects.equals(this.localWriteOffDate, other.localWriteOffDate);
        }

        public int hashCode() {
            return Objects.hash(this.isSameDirection, this.forWriteOffDate, this.localWriteOffDate);
        }
    }
}

