/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.realtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.gl.business.service.reciprocal.realtime.BaseKey;
import kd.fi.gl.business.service.reciprocal.realtime.GroupKey;
import kd.fi.gl.business.service.reciprocal.realtime.OriginPoint;
import org.apache.commons.lang3.tuple.Pair;

public class RealTimeWriteOffContext {
    private Long orgId;
    private Long bookTypeId;
    private Long acctTableId;
    private Map<BaseKey, Map<GroupKey, OriginPoint>> balLogOriPoint = new HashMap<BaseKey, Map<GroupKey, OriginPoint>>(8);
    private Map<BaseKey, Map<GroupKey, OriginPoint>> unAccOriPoint = new HashMap<BaseKey, Map<GroupKey, OriginPoint>>(8);
    private Set<Long> acctMasterIds;
    private Set<Long> currencyIds;
    private Set<Long> assgrpIds;
    private Map<BaseKey, Set<Long>> needCalAssgrp;
    private Map<BaseKey, Set<Long>> noNeedCalAssgrp;
    private Map<Pair<Long, Long>, Map<Long, List<Long>>> acctToBalLogIds;

    public RealTimeWriteOffContext(Long orgId, Long bookTypeId) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
    }

    public RealTimeWriteOffContext(Long orgId, Long bookTypeId, Long acctTableId) {
        this(orgId, bookTypeId);
        this.acctTableId = acctTableId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getBookTypeId() {
        return this.bookTypeId;
    }

    public void setBookTypeId(Long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public Long getAcctTableId() {
        if (Objects.isNull(this.acctTableId)) {
            this.acctTableId = 0L;
        }
        return this.acctTableId;
    }

    public void setAcctTableId(Long acctTableId) {
        this.acctTableId = acctTableId;
    }

    public Map<BaseKey, Map<GroupKey, OriginPoint>> getBalLogOriPoint() {
        return this.balLogOriPoint;
    }

    public void setBalLogOriPoint(Map<BaseKey, Map<GroupKey, OriginPoint>> balLogOriPoint) {
        this.balLogOriPoint = balLogOriPoint;
    }

    public Map<BaseKey, Map<GroupKey, OriginPoint>> getUnAccOriPoint() {
        return this.unAccOriPoint;
    }

    public void setUnAccOriPoint(Map<BaseKey, Map<GroupKey, OriginPoint>> unAccOriPoint) {
        this.unAccOriPoint = unAccOriPoint;
    }

    public Set<Long> getAcctMasterIds() {
        if (Objects.isNull(this.acctMasterIds)) {
            this.acctMasterIds = new HashSet<Long>(8);
        }
        return this.acctMasterIds;
    }

    public void setAcctMasterIds(Set<Long> acctMasterIds) {
        this.acctMasterIds = acctMasterIds;
    }

    public Set<Long> getCurrencyIds() {
        if (Objects.isNull(this.currencyIds)) {
            this.currencyIds = new HashSet<Long>(3);
        }
        return this.currencyIds;
    }

    public void setCurrencyIds(Set<Long> currencyIds) {
        this.currencyIds = currencyIds;
    }

    public Set<Long> getAssgrpIds() {
        if (Objects.isNull(this.assgrpIds)) {
            this.assgrpIds = new HashSet<Long>(10);
        }
        return this.assgrpIds;
    }

    public void setAssgrpIds(Set<Long> assgrpIds) {
        this.assgrpIds = assgrpIds;
    }

    public Map<BaseKey, Set<Long>> getNeedCalAssgrp() {
        if (Objects.isNull(this.needCalAssgrp) && Objects.isNull(this.noNeedCalAssgrp)) {
            this.groupAssgrp();
        }
        if (Objects.isNull(this.needCalAssgrp)) {
            this.needCalAssgrp = new HashMap<BaseKey, Set<Long>>(0);
        }
        return this.needCalAssgrp;
    }

    public Map<BaseKey, Set<Long>> getNoNeedCalAssgrp() {
        if (Objects.isNull(this.needCalAssgrp) && Objects.isNull(this.noNeedCalAssgrp)) {
            this.groupAssgrp();
        }
        if (Objects.isNull(this.noNeedCalAssgrp)) {
            this.noNeedCalAssgrp = new HashMap<BaseKey, Set<Long>>(0);
        }
        return this.noNeedCalAssgrp;
    }

    public Map<Pair<Long, Long>, Map<Long, List<Long>>> getAcctToBalLogIds() {
        if (Objects.isNull(this.acctToBalLogIds)) {
            this.acctToBalLogIds = new HashMap<Pair<Long, Long>, Map<Long, List<Long>>>(8);
        }
        return this.acctToBalLogIds;
    }

    public void addAcctToBalLogIds(Pair<Long, Long> pair, Long voucherId, Long balLogId) {
        this.getAcctToBalLogIds().computeIfAbsent(pair, x -> new HashMap(8)).computeIfAbsent(voucherId, x -> new ArrayList(8)).add(balLogId);
    }

    private void groupAssgrp() {
        if (Objects.isNull(this.needCalAssgrp) && Objects.isNull(this.noNeedCalAssgrp)) {
            this.needCalAssgrp = new HashMap<BaseKey, Set<Long>>(8);
            this.noNeedCalAssgrp = new HashMap<BaseKey, Set<Long>>(8);
        }
        for (Map.Entry<BaseKey, Map<GroupKey, OriginPoint>> baseEntry : this.getBalLogOriPoint().entrySet()) {
            BaseKey key = baseEntry.getKey();
            Map<GroupKey, OriginPoint> unAccOriginPointMap = this.getUnAccOriPoint().get(key);
            if (!Objects.nonNull(baseEntry.getValue())) continue;
            if (Objects.isNull(unAccOriginPointMap)) {
                Set assgrpIds = baseEntry.getValue().keySet().stream().map(GroupKey::getAssgrpId).collect(Collectors.toSet());
                this.needCalAssgrp.computeIfAbsent(key, x -> new HashSet(10)).addAll(assgrpIds);
                continue;
            }
            baseEntry.getValue().forEach((balLogGroupKey, balLogOriginPoint) -> {
                OriginPoint unAccOriginPoint = (OriginPoint)unAccOriginPointMap.get(balLogGroupKey);
                if (Objects.nonNull(unAccOriginPoint) && unAccOriginPoint.getBalDc().equals(balLogOriginPoint.getBalDc()) && Objects.nonNull(unAccOriginPoint.getLastWriteOffDate()) && unAccOriginPoint.getLastWriteOffDate().compareTo(balLogOriginPoint.getLastWriteOffDate()) <= 0) {
                    this.noNeedCalAssgrp.computeIfAbsent(key, x -> new HashSet(10)).add(balLogGroupKey.getAssgrpId());
                } else {
                    this.needCalAssgrp.computeIfAbsent(key, x -> new HashSet(10)).add(balLogGroupKey.getAssgrpId());
                }
            });
        }
    }
}

