/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal.realtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.business.dao.balance.BalanceLogDAO;
import kd.fi.gl.constant.AccCurrent;
import kd.fi.gl.constant.GLConstants;
import kd.fi.gl.constant.reciprocal.UnAcccurrent;
import kd.fi.gl.util.DataSetHelper;

public class UnAcccurrentHandle {
    private static final Log LOG = LogFactory.getLog(UnAcccurrentHandle.class);
    private static final String INSERT_UNACCCURRENT_SQL = "INSERT INTO T_GL_UNACCCURRENT (FID, FORGID, FBOOKTYPEID, FPERIODID, FACCTABLEID, FACCOUNTID, FASSGRPID, FCURRENCYID, FAMOUNTFOR, FAMOUNTBALFOR, FLOCALCURRENCYID, FAMOUNT, FAMOUNTBAL, FBIZDATE, FEXPIREDATE, FBIZNUM, FDESCRIPTION, FSTATUS, FVCHENTRYID, FSOURCETYPE, FVOUCHERID, FMODIFYTIME, FCREATETIME, FMASTERID, FEFFECTIVEDATE, FUNEFFECTIVEDATE, FCREATORID, FWRITEOFFPERSONID, FENTRYDC, FBOOKEDDATE, FRECORDID, FFORWRITEOFFDATE, FLOCALWRITEOFFDATE, FISORIGINPOINT) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private static final String UPDATE_UNACCCURRENT_SQL = "UPDATE T_GL_UNACCCURRENT SET FAMOUNTBALFOR = ?, FAMOUNTBAL = ?, FFORWRITEOFFDATE = ?, FLOCALWRITEOFFDATE = ?, FISORIGINPOINT = ? WHERE FID = ?";
    private final Set<Long> handledUnAccIds = new HashSet<Long>(128);

    public void handle(DataSet newUnAccDs, DataSet oldUnAccDs, List<Long> logIds) {
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet("UnAcccurrentHandle.handle#newUnAccDs:{}", newUnAccDs);
            DataSetHelper.logDataSet("UnAcccurrentHandle.handle#oldUnAccDs:{}", oldUnAccDs);
        }
        Params params = null;
        Row dbPointer = null;
        Row newPointer = null;
        HashMap<Long, Object[]> updateValue = new HashMap<Long, Object[]>(128);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(16);
        while (newUnAccDs.hasNext() || oldUnAccDs.hasNext()) {
            if (Objects.isNull(params)) {
                params = new Params();
            }
            if (null == dbPointer && oldUnAccDs.hasNext()) {
                dbPointer = oldUnAccDs.next();
            }
            if (null == newPointer && newUnAccDs.hasNext()) {
                newPointer = newUnAccDs.next();
            }
            if (DebugTrace.enable()) {
                LOG.info("UnAcccurrentHandle.handle#dbPointer:{}", (Object)dbPointer);
                LOG.info("UnAcccurrentHandle.handle#newPointer:{}", (Object)newPointer);
            }
            if (dbPointer == null) {
                if (newPointer != null) {
                    this.createUnAcccurrent(newPointer, updateValue);
                }
                newPointer = null;
            } else if (newPointer == null) {
                this.deleteUnAcccurrent(params, dbPointer);
                dbPointer = null;
            } else {
                Long newUnAccId = newPointer.getLong("id");
                Long l = dbPointer.getLong(UnAcccurrent.RECORDID);
                if (newUnAccId > l) {
                    this.deleteUnAcccurrent(params, dbPointer);
                    dbPointer = null;
                    if (!oldUnAccDs.hasNext()) {
                        this.createUnAcccurrent(newPointer, updateValue);
                        newPointer = null;
                    }
                } else if (newUnAccId.equals(l)) {
                    this.updateUnAcccurrent(params, newPointer, dbPointer);
                    dbPointer = null;
                    newPointer = null;
                } else {
                    this.createUnAcccurrent(newPointer, updateValue);
                    newPointer = null;
                    if (!newUnAccDs.hasNext()) {
                        this.deleteUnAcccurrent(params, dbPointer);
                        dbPointer = null;
                    }
                }
            }
            int batchSize = 999;
            if (updateValue.size() <= batchSize && params.getNewUnAcccurrentParams().size() <= batchSize && params.getUpdateUnAcccurrentParams().size() <= batchSize && params.getDeleteUnAcccurrentIds().size() <= batchSize) continue;
            futures.add(this.buildTask(params, new HashMap<Long, Object[]>(updateValue)));
            updateValue.clear();
            params = null;
        }
        if (updateValue.size() > 0 || Objects.nonNull(params) && (params.getNewUnAcccurrentParams().size() > 0 || params.getUpdateUnAcccurrentParams().size() > 0 || params.getDeleteUnAcccurrentIds().size() > 0)) {
            if (Objects.isNull(params)) {
                params = new Params();
            }
            params.addUpdateBalLogParams(logIds);
            futures.add(this.buildTask(params, new HashMap<Long, Object[]>(updateValue)));
            updateValue.clear();
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Future<Boolean> buildTask(Params params, Map<Long, Object[]> updateValue) {
        return ThreadService.submit(() -> {
            this.batchStoreData(params, updateValue);
            return true;
        }, (TaskType)TaskType.GL_WRITE_UNACCCURRENT_CALCULATED);
    }

    private void batchStoreData(Params params, Map<Long, Object[]> updateValue) {
        if (updateValue.size() > 0) {
            this.createNewUnAcccurrentParams(params, updateValue);
        }
        updateValue.clear();
        this.storeData(params);
    }

    protected void createNewUnAcccurrentParams(Params params, Map<Long, Object[]> updateValue) {
        QFilter filter = new QFilter("id", "in", updateValue.keySet());
        try (DataSet acccurDs = QueryServiceHelper.queryDataSet((String)UnAcccurrentHandle.class.getName(), (String)AccCurrent.ENTITY, (String)"id, org, booktype, period, accounttable, account, assgrp, currency, amountfor, amountbalfor, localcurrency, amount, amountbal, bizdate, expiredate, biznum, description, status, voucherentry, sourcetype, voucherid, modifytime, createtime, masterid, effectivedate, uneffectivedate, creator, writeoffperson, entrydc, bookeddate", (QFilter[])filter.toArray(), null);){
            long[] ids = DB.genLongIds((String)UnAcccurrent.Table, (int)updateValue.size());
            int index = 0;
            while (acccurDs.hasNext()) {
                params.getNewUnAcccurrentParams().add(this.getInsertParam(acccurDs.next(), ids[index++], updateValue));
            }
        }
    }

    protected Object[] getInsertParam(Row row, long id, Map<Long, Object[]> updateValue) {
        ArrayList<Object> param = new ArrayList<Object>(34);
        Object[] values = updateValue.get(row.getLong("id"));
        param.add(id);
        param.add(row.getLong("org"));
        param.add(row.getLong("booktype"));
        param.add(row.getLong("period"));
        param.add(row.getLong("accounttable"));
        param.add(row.getLong("account"));
        param.add(row.getLong("assgrp"));
        param.add(row.getLong("currency"));
        param.add(row.getBigDecimal("amountfor"));
        param.add(values[0]);
        param.add(row.getLong("localcurrency"));
        param.add(row.getBigDecimal("amount"));
        param.add(values[1]);
        param.add(row.getDate("bizdate"));
        param.add(row.getDate("expiredate"));
        param.add(row.getString("biznum"));
        param.add(row.getString("description"));
        param.add(row.getString("status"));
        param.add(row.getLong("voucherentry"));
        param.add(row.getString("sourcetype"));
        param.add(row.getLong("voucherid"));
        param.add(row.getDate("modifytime"));
        param.add(row.getDate("createtime"));
        param.add(row.getLong("masterid"));
        param.add(row.getDate("effectivedate"));
        param.add(row.getDate("uneffectivedate"));
        param.add(row.getLong("creator"));
        param.add(row.getLong("writeoffperson"));
        param.add(row.getString("entrydc"));
        param.add(row.getDate("bookeddate"));
        param.add(row.getLong("id"));
        param.add(values[2]);
        param.add(values[3]);
        param.add(UnAcccurrentHandle.isOriginPoint((Date)values[2], (Date)values[3]));
        return param.toArray();
    }

    protected SqlBuilder getDeleteUnAcccurrentSql(String tablename, List<Object> ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from ", new Object[0]);
        sql.append(tablename, new Object[0]);
        sql.appendIn(" where fid ", ids);
        return sql;
    }

    private void deleteUnAcccurrent(Params params, Row oldUnAccRow) {
        params.addDeleteUnAcccurrentIds(oldUnAccRow.getLong("id"));
    }

    private void updateUnAcccurrent(Params params, Row newUnAccRow, Row oldUnAccRow) {
        Long newUnAccId = newUnAccRow.getLong("id");
        if (this.handledUnAccIds.contains(newUnAccId)) {
            this.deleteUnAcccurrent(params, oldUnAccRow);
        } else {
            if (this.isNeedUpdateUnAcccurrent(newUnAccRow, oldUnAccRow)) {
                params.getUpdateUnAcccurrentParams().add(this.getUpdateParam(newUnAccRow, oldUnAccRow.getLong("id")));
            }
            this.handledUnAccIds.add(newUnAccId);
        }
    }

    private boolean isNeedUpdateUnAcccurrent(Row newUnAccRow, Row oldUnAccRow) {
        return newUnAccRow.getBigDecimal("amountbalfor").compareTo(oldUnAccRow.getBigDecimal("amountbalfor")) != 0 || newUnAccRow.getBigDecimal("amountbal").compareTo(oldUnAccRow.getBigDecimal("amountbal")) != 0 || !Objects.equals(newUnAccRow.getDate(UnAcccurrent.FORWRITEOFFDATE), oldUnAccRow.getDate(UnAcccurrent.FORWRITEOFFDATE)) || !Objects.equals(newUnAccRow.getDate(UnAcccurrent.LOCALWRITEOFFDATE), oldUnAccRow.getDate(UnAcccurrent.LOCALWRITEOFFDATE)) || (Objects.nonNull(newUnAccRow.getDate(UnAcccurrent.FORWRITEOFFDATE)) || Objects.nonNull(newUnAccRow.getDate(UnAcccurrent.LOCALWRITEOFFDATE))) && oldUnAccRow.getBoolean("isoriginpoint") == false;
    }

    private Object[] getUpdateParam(Row row, Long unAccId) {
        ArrayList<Object> param = new ArrayList<Object>(10);
        param.add(row.getBigDecimal("amountbalfor"));
        param.add(row.getBigDecimal("amountbal"));
        param.add(row.getDate(UnAcccurrent.FORWRITEOFFDATE));
        param.add(row.getDate(UnAcccurrent.LOCALWRITEOFFDATE));
        param.add(UnAcccurrentHandle.isOriginPoint(row.getDate(UnAcccurrent.FORWRITEOFFDATE), row.getDate(UnAcccurrent.LOCALWRITEOFFDATE)));
        param.add(unAccId);
        return param.toArray();
    }

    private void createUnAcccurrent(Row newUnAccRow, Map<Long, Object[]> updateValue) {
        Long newUnAccId = newUnAccRow.getLong("id");
        if (this.handledUnAccIds.add(newUnAccId)) {
            updateValue.put(newUnAccId, this.getUpdateValue(newUnAccRow));
        }
    }

    private Object[] getUpdateValue(Row row) {
        return new Object[]{row.getBigDecimal("amountbalfor"), row.getBigDecimal("amountbal"), row.getDate(UnAcccurrent.FORWRITEOFFDATE), row.getDate(UnAcccurrent.LOCALWRITEOFFDATE)};
    }

    protected void storeData(Params params) {
        try (TXHandle h = TX.requiresNew((String)(UnAcccurrentHandle.class.getName() + "storeData"));){
            try {
                if (!params.getDeleteUnAcccurrentIds().isEmpty()) {
                    DB.execute((DBRoute)GLConstants.GL_DBRoute, (SqlBuilder)this.getDeleteUnAcccurrentSql(UnAcccurrent.Table, new ArrayList<Object>(params.getDeleteUnAcccurrentIds())));
                }
                if (!params.getNewUnAcccurrentParams().isEmpty()) {
                    DB.executeBatch((DBRoute)GLConstants.GL_DBRoute, (String)INSERT_UNACCCURRENT_SQL, params.getNewUnAcccurrentParams());
                }
                if (!params.getUpdateUnAcccurrentParams().isEmpty()) {
                    DB.executeBatch((DBRoute)GLConstants.GL_DBRoute, (String)UPDATE_UNACCCURRENT_SQL, params.getUpdateUnAcccurrentParams());
                }
                if (!params.getUpdateBalLogParams().isEmpty()) {
                    List partition = Lists.partition(params.getUpdateBalLogParams(), (int)999);
                    for (List ids : partition) {
                        BalanceLogDAO.updateAcccalculated(ids.toArray(new Long[0]));
                    }
                }
                params.clear();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static String isOriginPoint(Date forwriteoffdate, Date localwriteoffdate) {
        if (Objects.nonNull(forwriteoffdate) || Objects.nonNull(localwriteoffdate)) {
            return "1";
        }
        return "0";
    }

    static class Params {
        private final List<Object[]> newUnAcccurrentParams = new ArrayList<Object[]>(999);
        private final List<Object[]> updateUnAcccurrentParams = new ArrayList<Object[]>(999);
        private final Set<Long> deleteUnAcccurrentIds = new HashSet<Long>(999);
        private final List<Long> updateBalLogParams = new ArrayList<Long>(999);

        Params() {
        }

        public List<Object[]> getNewUnAcccurrentParams() {
            return this.newUnAcccurrentParams;
        }

        public List<Object[]> getUpdateUnAcccurrentParams() {
            return this.updateUnAcccurrentParams;
        }

        public Set<Long> getDeleteUnAcccurrentIds() {
            return this.deleteUnAcccurrentIds;
        }

        public void addDeleteUnAcccurrentIds(Long deleteUnAcccurrentId) {
            this.deleteUnAcccurrentIds.add(deleteUnAcccurrentId);
        }

        public List<Long> getUpdateBalLogParams() {
            return this.updateBalLogParams;
        }

        public void addUpdateBalLogParams(List<Long> balLogIds) {
            this.updateBalLogParams.addAll(balLogIds);
        }

        public void clear() {
            this.newUnAcccurrentParams.clear();
            this.updateUnAcccurrentParams.clear();
            this.deleteUnAcccurrentIds.clear();
            this.updateBalLogParams.clear();
        }
    }
}

