/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.synbook;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.gl.business.dao.synbook.VoucherRefTrackerDao;
import kd.fi.gl.business.vo.synbook.VoucherRefTrackerVO;
import kd.fi.gl.common.Tuple;

public class VoucherRefTrackerService {
    public static void clearAndSaveVoucherRefTrackers(Collection<VoucherRefTrackerVO> voucherRefTrackerVOList) {
        try (TXHandle txHandle = TX.required();){
            try {
                List<Tuple<Long, Long>> voucherIdBookIdTupleList = voucherRefTrackerVOList.stream().map(tracker -> Tuple.create(tracker.getSourceVoucherId(), tracker.getTargetBookId())).collect(Collectors.toList());
                VoucherRefTrackerService.deleteBySrcVoucherAndTargetBook(voucherIdBookIdTupleList);
                VoucherRefTrackerDao.batchSaveVoucherRefTrackers(voucherRefTrackerVOList);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static List<VoucherRefTrackerVO> getTrackersBySourceVouchers(Collection<Long> sourceVoucherIds, Long targetBookId) {
        return VoucherRefTrackerDao.getTrackersBySourceVouchers(sourceVoucherIds, targetBookId);
    }

    public static Map<Long, VoucherRefTrackerVO> getLatestLogsBySourceAndTarget(Collection<Long> sourceVoucherIds, Long targetBookId) {
        List<VoucherRefTrackerVO> voucherRefTrackerVOList = VoucherRefTrackerService.getTrackersBySourceVouchers(sourceVoucherIds, targetBookId);
        if (voucherRefTrackerVOList.isEmpty()) {
            return Collections.emptyMap();
        }
        return voucherRefTrackerVOList.stream().collect(Collectors.toMap(VoucherRefTrackerVO::getSourceVoucherId, log -> log, (existing, replacement) -> existing.getOpDate().after(replacement.getOpDate()) ? existing : replacement));
    }

    /*
     * Exception decompiling
     */
    public static void deleteBySrcVoucherAndTargetBook(List<Tuple<Long, Long>> voucherIdBookIdTupleList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

