/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.vo.voucher;

import java.io.Serializable;
import java.util.Objects;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.gl.business.vo.voucher.CurrencyField;
import kd.fi.gl.model.schema.VoucherSchema;

public class AmountField
implements Serializable {
    public static final AmountField LOCAL = new AmountField(VoucherSchema.instance.debitLocal, VoucherSchema.instance.creditLocal, VoucherSchema.instance.exRate, CurrencyField.LOCAL);
    public static final AmountField ORIGINAL = new AmountField(VoucherSchema.instance.debitOri, VoucherSchema.instance.creditOri, VoucherSchema.instance.exRate, CurrencyField.ORIGINAL);
    private static final long serialVersionUID = 6214450473713218469L;
    private final Prop debitProp;
    private final Prop creditProp;
    private final Prop exRateProp;
    private final CurrencyField currencyField;

    public AmountField(String debitField, String creditField, String exRateProp, CurrencyField currencyField) {
        this.debitProp = new Prop(VoucherSchema.instance.entry, debitField);
        this.creditProp = new Prop(VoucherSchema.instance.entry, creditField);
        this.exRateProp = new Prop(VoucherSchema.instance.entry, exRateProp);
        this.currencyField = currencyField;
    }

    public AmountField(Prop debitProp, Prop creditProp, Prop exRateProp, CurrencyField currencyField) {
        this.debitProp = debitProp;
        this.creditProp = creditProp;
        this.exRateProp = exRateProp;
        this.currencyField = currencyField;
    }

    public String getDebitField() {
        return this.debitProp.toString();
    }

    public Prop getDebitProp() {
        return this.debitProp;
    }

    public String getCreditField() {
        return this.creditProp.toString();
    }

    public Prop getCreditProp() {
        return this.creditProp;
    }

    public String getExRateField() {
        return this.exRateProp.toString();
    }

    public Prop getExRateProp() {
        return this.exRateProp;
    }

    public CurrencyField getCurrencyField() {
        return this.currencyField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmountField that = (AmountField)o;
        return Objects.equals(this.debitProp, that.debitProp) && Objects.equals(this.creditProp, that.creditProp) & Objects.equals(this.exRateProp, that.exRateProp) && Objects.equals(this.currencyField, that.currencyField);
    }

    public int hashCode() {
        return Objects.hash(this.debitProp, this.creditProp, this.exRateProp, this.currencyField);
    }
}

