/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.vo.voucher;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.fi.bd.model.Context;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.model.schema.VoucherSchema;

@DataEntityTypeAttribute(tableName="T_GL_VOUCHERENTRY", dbRouteKey="gl")
public class VoucherEntryStore
implements IVoucherEntry,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1L;
    private static final VoucherSchema VOUCHER_SCHEMA = VoucherSchema.instance;
    private Context store = new Context();

    @Override
    @SimplePropertyAttribute(alias="FId", dbType=-5)
    public long getId() {
        return (Long)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.id.toString());
    }

    public void setId(long id) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.id.toString(), (Object)id);
    }

    @Override
    @SimplePropertyAttribute(alias="FEntryId", dbType=-5, isPrimaryKey=true)
    public long getEntryId() {
        return (Long)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.entryId.toString());
    }

    public void setEntryId(long entryId) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.entryId.toString(), (Object)entryId);
    }

    @Override
    public int getSeq() {
        return (Integer)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.entrySeq.toString());
    }

    public void setSeq(int seq) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.entrySeq.toString(), (Object)seq);
    }

    @Override
    @SimplePropertyAttribute(alias="FCurrencyId", dbType=-5)
    public long getCurrencyId() {
        return (Long)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.currency.toStringWithID());
    }

    public void setCurrencyId(long currencyId) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.currency.toStringWithID(), (Object)currencyId);
    }

    @Override
    @SimplePropertyAttribute(alias="FORIGINALDEBIT", dbType=3)
    public BigDecimal getDebitOriAmt() {
        return (BigDecimal)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.debitOri.toString());
    }

    public void setDebitOriAmt(BigDecimal debitOriAmt) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.debitOri.toString(), (Object)debitOriAmt);
    }

    @Override
    @SimplePropertyAttribute(alias="FORIGINALCREDIT", dbType=3)
    public BigDecimal getCreditOriAmt() {
        return (BigDecimal)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.creditOri.toString());
    }

    public void setCreditOriAmt(BigDecimal creditOriAmt) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.creditOri.toString(), (Object)creditOriAmt);
    }

    @Override
    @SimplePropertyAttribute(alias="FLOCALDEBIT", dbType=3)
    public BigDecimal getDebitLocAmt() {
        return (BigDecimal)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.debitLocal.toString());
    }

    public void setDebitLocAmt(BigDecimal debitLocAmt) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.debitLocal.toString(), (Object)debitLocAmt);
    }

    @Override
    @SimplePropertyAttribute(alias="FLOCALCREDIT", dbType=3)
    public BigDecimal getCreditLocAmt() {
        return (BigDecimal)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.creditLocal.toString());
    }

    public void setCreditLocAmt(BigDecimal creditLocAmt) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.creditLocal.toString(), (Object)creditLocAmt);
    }

    @Override
    @SimplePropertyAttribute(alias="FENTRYDC", dbType=-9)
    public String getEntryDC() {
        return (String)this.store.query(VoucherEntryStore.VOUCHER_SCHEMA.dc.toString());
    }

    public void setEntryDC(String entryDC) {
        this.store.registerContext(VoucherEntryStore.VOUCHER_SCHEMA.dc.toString(), (Object)entryDC);
    }

    @Override
    public BigDecimal getDebit(AmountField field) {
        return this.getBigDecimal(field.getDebitField());
    }

    @Override
    public BigDecimal getCredit(AmountField field) {
        return this.getBigDecimal(field.getCreditField());
    }

    @Override
    public Amount getAmount(AmountField field) {
        return new Amount(this.getBigDecimal(field.getDebitField()), this.getBigDecimal(field.getCreditField()));
    }

    @Override
    public BigDecimal getBigDecimal(String prop) {
        BigDecimal val = (BigDecimal)this.store.query(prop);
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        return val;
    }

    @Override
    public Object get(String key) {
        return this.store.query(key);
    }

    @Override
    public void set(String key, Object value) {
        this.store.registerContext(key, value);
    }

    @Override
    public void setBigDecimal(String field, BigDecimal decimal) {
        this.store.registerContext(field, (Object)decimal);
    }

    public VoucherEntryStore clone() {
        try {
            VoucherEntryStore clone = (VoucherEntryStore)super.clone();
            clone.store = this.store.copy();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

