/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.vo.voucher.mc;

import java.math.BigDecimal;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucher;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherEntry;

public class MCVoucherEntry
implements IMCVoucherEntry {
    private final IMCVoucher voucher;
    private final IVoucherEntry entry;

    public MCVoucherEntry(IMCVoucher voucher, IVoucherEntry entry) {
        this.voucher = voucher;
        this.entry = entry;
    }

    @Override
    public long getId() {
        return this.entry.getId();
    }

    @Override
    public long getEntryId() {
        return this.entry.getEntryId();
    }

    @Override
    public int getSeq() {
        return this.entry.getSeq();
    }

    @Override
    public long getCurrencyId() {
        return this.entry.getCurrencyId();
    }

    @Override
    public String getEntryDC() {
        return this.entry.getEntryDC();
    }

    @Override
    public BigDecimal getDebitLocAmt() {
        return this.entry.getDebitLocAmt();
    }

    @Override
    public BigDecimal getDebitOriAmt() {
        return this.entry.getDebitOriAmt();
    }

    @Override
    public BigDecimal getCreditLocAmt() {
        return this.entry.getCreditLocAmt();
    }

    @Override
    public BigDecimal getCreditOriAmt() {
        return this.entry.getCreditOriAmt();
    }

    @Override
    public BigDecimal getDebit(AmountField field) {
        return this.entry.getDebit(field);
    }

    @Override
    public BigDecimal getCredit(AmountField field) {
        return this.entry.getCredit(field);
    }

    @Override
    public Amount getAmount(AmountField field) {
        return this.entry.getAmount(field);
    }

    @Override
    public BigDecimal getBigDecimal(String prop) {
        return this.entry.getBigDecimal(prop);
    }

    @Override
    public Object get(String key) {
        return this.entry.get(key);
    }

    @Override
    public void set(String key, Object value) {
        this.entry.set(key, value);
    }

    @Override
    public void setBigDecimal(String field, BigDecimal decimal) {
        this.entry.setBigDecimal(field, decimal);
    }

    @Override
    public IMCVoucher getVoucher() {
        return this.voucher;
    }

    @Override
    public Long getMCOriCurId(MulLocalConfig config) {
        if (this.getVoucher().isUsingLocalCalcMulLocal(config)) {
            return this.getVoucher().getLocalCurId();
        }
        return this.getCurrencyId();
    }

    @Override
    public BigDecimal getMCOriAmt(MulLocalConfig config) {
        if (this.getVoucher().isUsingLocalCalcMulLocal(config)) {
            return this.getLocAmt();
        }
        return this.getOriAmt();
    }

    @Override
    public BigDecimal getMCExRate(MulLocalConfig config) {
        return this.entry.getBigDecimal(config.getExRateField());
    }

    @Override
    public BigDecimal getMCLocalAmount(MulLocalConfig config) {
        return this.entry.getBigDecimal(config.getLocalAmountField(this.getEntryDC()));
    }

    @Override
    public BigDecimal getMCDebitAmount(MulLocalConfig config) {
        return this.entry.getBigDecimal(config.getDebitField());
    }

    @Override
    public BigDecimal getMCCreditAmount(MulLocalConfig config) {
        return this.entry.getBigDecimal(config.getCreditField());
    }

    @Override
    public void setMCExRateType(MulLocalConfig config, RateType rateType) {
        this.entry.set(config.getExRateTypeField(), rateType.getValue());
    }

    @Override
    public void setMCExRate(MulLocalConfig config, BigDecimal exRate) {
        this.entry.setBigDecimal(config.getExRateField(), exRate);
    }

    @Override
    public void setMCLocalAmount(MulLocalConfig config, BigDecimal amount) {
        this.entry.setBigDecimal(config.getLocalAmountField(this.getEntryDC()), amount);
    }
}

