/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.vo.voucher.mc;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.service.voucher.option.helper.VoucherArgConfigServiceHelper;
import kd.fi.gl.business.service.voucher.option.key.ArgKey;
import kd.fi.gl.business.vo.voucher.IVoucherModel;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.util.ContextUtil;

public class MCVoucherModel
implements IMCVoucherModel {
    private final IVoucherModel voucherModel;

    public MCVoucherModel(IVoucherModel voucherModel) {
        this.voucherModel = voucherModel;
    }

    @Override
    public long getId() {
        return this.voucherModel.getId();
    }

    @Override
    public long getOrgId() {
        return this.voucherModel.getOrgId();
    }

    @Override
    public long getBookTypeId() {
        return this.voucherModel.getBookTypeId();
    }

    @Override
    public Date getBookedDate() {
        return this.voucherModel.getBookedDate();
    }

    @Override
    public Date getBizDate() {
        return this.voucherModel.getBizDate();
    }

    @Override
    public long getLocalCurId() {
        return this.voucherModel.getLocalCurId();
    }

    @Override
    public String getSourceType() {
        return this.voucherModel.getSourceType();
    }

    @Override
    public long getCurrencyId(int rowIndex) {
        return this.voucherModel.getCurrencyId(rowIndex);
    }

    @Override
    public String getEntryDC(int rowIndex) {
        return this.voucherModel.getEntryDC(rowIndex);
    }

    @Override
    public BigDecimal getLocAmt(int rowIndex) {
        return this.voucherModel.getLocAmt(rowIndex);
    }

    @Override
    public BigDecimal getDebitLocAmt(int rowIndex) {
        return this.voucherModel.getDebitLocAmt(rowIndex);
    }

    @Override
    public BigDecimal getCreditLocAmt(int rowIndex) {
        return this.voucherModel.getCreditLocAmt(rowIndex);
    }

    @Override
    public BigDecimal getDebitOriAmt(int rowIndex) {
        return this.voucherModel.getDebitOriAmt(rowIndex);
    }

    @Override
    public BigDecimal getCreditOriAmt(int rowIndex) {
        return this.voucherModel.getCreditOriAmt(rowIndex);
    }

    @Override
    public BigDecimal getOriAmt(int rowIndex) {
        return this.voucherModel.getOriAmt(rowIndex);
    }

    @Override
    public DynamicObject getDynamicObject(String key) {
        return this.voucherModel.getDynamicObject(key);
    }

    @Override
    public Object getEntryValue(String key, int rowIndex) {
        return this.voucherModel.getEntryValue(key, rowIndex);
    }

    @Override
    public BigDecimal getEntryBigDecimalValue(String key, int rowIndex) {
        return this.voucherModel.getEntryBigDecimalValue(key, rowIndex);
    }

    @Override
    public Object getValue(String key) {
        return this.voucherModel.getValue(key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.voucherModel.setValue(key, value);
    }

    @Override
    public void setValue(String key, Object value, int rowIndex) {
        this.voucherModel.setValue(key, value, rowIndex);
    }

    @Override
    public boolean isUsingLocalCalcMulLocal(MulLocalConfig config) {
        return config.isUsingLocalCalcMulLocal(this.getOrgId(), this.getBookTypeId(), this.getSourceType());
    }

    @Override
    public Date getMCExRateDate(MulLocalConfig config) {
        if (((Boolean)VoucherArgConfigServiceHelper.getArgValue(this.getOrgId(), ContextUtil.getUserId(), ArgKey.ratebybizdate)).booleanValue()) {
            return this.getBizDate();
        }
        return this.getBookedDate();
    }

    @Override
    public Long getMCLocalCurId(MulLocalConfig config) {
        DynamicObject currency = this.getDynamicObject(config.getCurrencyField());
        return currency == null ? 0L : currency.getLong("id");
    }

    @Override
    public void setMCLocalCurId(MulLocalConfig config, long curId) {
        if (curId == 0L) {
            this.setValue(config.getCurrencyField() + "_id", 0L);
            this.setValue(config.getCurrencyField(), null);
        } else {
            this.setValue(config.getCurrencyField(), curId);
        }
    }

    @Override
    public int getMCLocalCurAmtPrecision(MulLocalConfig config) {
        DynamicObject currency = this.getDynamicObject(config.getCurrencyField());
        return currency == null ? 0 : currency.getInt("amtprecision");
    }

    @Override
    public Long getMCExRateTableId(MulLocalConfig config) {
        return config.getExRateTableId(this.getOrgId(), this.getBookTypeId());
    }

    @Override
    public Long getMCOriCurId(MulLocalConfig config, int rowIndex) {
        if (this.isUsingLocalCalcMulLocal(config)) {
            return this.getLocalCurId();
        }
        return this.getCurrencyId(rowIndex);
    }

    @Override
    public BigDecimal getMCOriAmt(MulLocalConfig config, int rowIndex) {
        if (this.isUsingLocalCalcMulLocal(config)) {
            return this.getLocAmt(rowIndex);
        }
        return this.getOriAmt(rowIndex);
    }

    @Override
    public BigDecimal getMCExRate(MulLocalConfig config, int rowIndex) {
        return this.getEntryBigDecimalValue(config.getExRateField(), rowIndex);
    }

    @Override
    public int getMCExRatePrecision(MulLocalConfig config, int rowIndex) {
        return RateServiceHelper.getRatePrecision((Long)this.getMCOriCurId(config, rowIndex), (Long)this.getMCLocalCurId(config), (Long)this.getMCExRateTableId(config), (Date)this.getMCExRateDate(config));
    }

    @Override
    public RateType getMCExRateType(MulLocalConfig config, int rowIndex) {
        return RateType.getRateType((String)((String)this.getEntryValue(config.getExRateTypeField(), rowIndex)));
    }

    @Override
    public BigDecimal getMCDebitAmount(MulLocalConfig config, int rowIndex) {
        return this.getEntryBigDecimalValue(config.getDebitField(), rowIndex);
    }

    @Override
    public void setMCDebitAmount(MulLocalConfig config, BigDecimal amount, int rowIndex) {
        this.setValue(config.getDebitField(), amount, rowIndex);
    }

    @Override
    public BigDecimal getMCCreditAmount(MulLocalConfig config, int rowIndex) {
        return this.getEntryBigDecimalValue(config.getCreditField(), rowIndex);
    }

    @Override
    public void setMCCreditAmount(MulLocalConfig config, BigDecimal amount, int rowIndex) {
        this.setValue(config.getCreditField(), amount, rowIndex);
    }
}

