/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.cache.MapCache;

public class IdDynCache
extends MapCache<Long, DynamicObject> {
    private final String entity;
    private final String selectFields;

    public IdDynCache(int initialCapacity, String entity, String selectFields) {
        super(new HashMap(initialCapacity), k -> BusinessDataServiceHelper.loadSingleFromCache((Object)k, (String)entity, (String)selectFields));
        this.entity = entity;
        this.selectFields = selectFields;
    }

    public IdDynCache(Collection<Long> ids, String entity, String selectFields) {
        this(ids.size(), entity, selectFields);
        this.batchFillCache(ids);
    }

    public String getEntity() {
        return this.entity;
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public final void batchFillCache(Collection<Long> ids) {
        ArrayList<Long> idList = new ArrayList<Long>(ids);
        if (!this.getCache().isEmpty()) {
            idList.removeAll(this.getCache().keySet());
        }
        if (!idList.isEmpty()) {
            this.getCache().putAll(BusinessDataServiceHelper.loadFromCache((String)this.getEntity(), (String)this.getSelectFields(), (QFilter[])new QFilter("id", "in", ids).toArray()).entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), Map.Entry::getValue, (oldVal, newVal) -> newVal)));
        }
    }
}

