/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.cache;

import java.util.Objects;
import java.util.function.Supplier;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheServiceHelper;

public class LocalCacheHelper {
    private LocalCacheHelper() {
    }

    public static void put(CacheKey key, Object content) {
        CacheServiceHelper.putToTimeToIdleLocalCache(key, content);
    }

    public static void remove(CacheKey key) {
        CacheServiceHelper.removeFromTimeToIdleLocalCache(key);
    }

    public static <V> V get(CacheKey key, Class<V> clazz) {
        return CacheServiceHelper.getFromTimeToIdleLocalCache(key, clazz);
    }

    public static <V> V getIfAbsent(CacheKey key, Class<V> clazz, Supplier<V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V v = LocalCacheHelper.get(key, clazz);
        if (v == null && (newValue = mappingFunction.get()) != null) {
            LocalCacheHelper.put(key, newValue);
            return newValue;
        }
        return v;
    }
}

