/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checktools;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.util.BalanceCheckHelper;

public class AcctBalanceCheckTask
implements FIDataCheckTask {
    private static final Log logger = LogFactory.getLog((String)"kd.fi.gl.checktools.AcctBalanceCheckTask");
    private static final DBRoute GL = DBRoute.of((String)"gl");
    private static final String CHECKSQL = "select a.faccountid from t_gl_acctbalance a left join (  select fcomassist1id,fcomassist2id,faccounttableid,faccountid,fcurrencyid,fmeasureunitid,fperiodid,sum(fdebitlocal) debitlocal,sum(fcreditlocal) creditlocal   from t_gl_balance where forgid=? and fbooktypeid=? group by fcomassist1id,fcomassist2id,faccounttableid,faccountid,fcurrencyid,fmeasureunitid,fperiodid) b on a.fcomassist1id=b.fcomassist2id and a.fcomassist2id=b.fcomassist2id and a.faccounttableid=b.faccounttableid and a.faccountid=b.faccountid and a.fcurrencyid=b.fcurrencyid and a.fmeasureunitid=b.fmeasureunitid and a.fperiodid=b.fperiodid where a.forgid=? and a.FBOOKTYPEID=? and (debitlocal<> fdebitlocal or creditlocal<>fcreditlocal)";

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        if (tenantId.equals("agilepre") || tenantId.equals("pretest")) {
            return true;
        }
        boolean checkResult = true;
        String err = this.checkBalIsEquals();
        if (err.length() > 0) {
            FIDataCheckUtil.saveResult((String)"acctbalancecheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u548c\u6c47\u603b\u8868\u672c\u671f\u53d1\u751f\u6570\u636e\u4e0d\u5bf9\u3002", (String)"AcctBalanceCheckTask_0", (String)"fi-gl-common", (Object[])new Object[0]), (String)"kd.fi.gl.checktools.AcctBalanceCheckTask");
            checkResult = false;
            logger.info("balanceerrinfo:{}", (Object)err);
        }
        return checkResult;
    }

    private String checkBalIsEquals() {
        try {
            DynamicObjectCollection col = BalanceCheckHelper.getAllBooks(null);
            ArrayList<String> err = new ArrayList<String>(100);
            for (DynamicObject book : col) {
                if (FIDataCheckUtil.isStop()) break;
                long org = book.getLong("org");
                long bt = book.getLong("bookstype");
                DataSet bal = DB.queryDataSet((String)"checkBal", (DBRoute)GL, (String)CHECKSQL, (Object[])new Object[]{org, bt, org, bt});
                if (!bal.hasNext()) continue;
                err.add(org + "-" + bt);
            }
            if (!err.isEmpty()) {
                return err.stream().collect(Collectors.joining(","));
            }
        }
        catch (Exception e) {
            logger.error("###### gl-acct-balance execute error!" + e.getMessage());
        }
        return "";
    }
}

