/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checktools;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.voucher.count.VoucherCount;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class CheckVoucherCountTask
implements FIDataCheckTask {
    public boolean execute() {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype,curperiod", null);
        for (DynamicObject dyn : collection) {
            long org = dyn.getLong("org");
            long booktype = dyn.getLong("bookstype");
            long period = dyn.getLong("curperiod");
            Map<VoucherCount, Tuple<Integer, Integer>> voucherCountTupleMap = VoucherCountHelper.queryVoucherForCount(org, booktype, period);
            for (Map.Entry<VoucherCount, Tuple<Integer, Integer>> entry : voucherCountTupleMap.entrySet()) {
                VoucherCount voucherCount = entry.getKey();
                Tuple<Integer, Integer> count = entry.getValue();
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
                qFilterList.add(new QFilter("org", "=", (Object)voucherCount.getOrg()));
                qFilterList.add(new QFilter("booktype", "=", (Object)voucherCount.getBooktype()));
                qFilterList.add(new QFilter("period", "=", (Object)voucherCount.getPeriod()));
                qFilterList.add(new QFilter("bookeddate", "=", (Object)voucherCount.getBookedDate()));
                qFilterList.add(new QFilter("billstatus", "=", (Object)voucherCount.getBillSatus()));
                qFilterList.add(new QFilter("ischeck", "=", (Object)voucherCount.getIsCheck()));
                qFilterList.add(new QFilter("ispost", "=", (Object)voucherCount.getIsPost()));
                qFilterList.add(new QFilter("sourcetype", "=", (Object)voucherCount.getSourceType()));
                qFilterList.add(new QFilter("mainstatus", "=", (Object)voucherCount.getMainStatus()));
                qFilterList.add(new QFilter("suppstatus", "=", (Object)voucherCount.getSuppStatus()));
                if (Math.abs((Integer)count.item1 - VoucherCountHelper.queryVoucherCount(new ArrayList<QFilter>(qFilterList))) <= 1 && Math.abs((Integer)count.item2 - VoucherCountHelper.queryEntryCount(qFilterList)) <= 1) continue;
                FIDataCheckUtil.saveResult((String)"checkVoucherCount", (String)"gl", (boolean)false, (String)String.format(ResManager.loadKDString((String)"\u6570\u636e\u95ee\u9898\uff1a\u51ed\u8bc1\u8ba1\u6570\u4e0d\u6b63\u786e\uff0c%1$s\u3002", (String)"CheckVoucherCountTask_0", (String)"fi-gl-common", (Object[])new Object[0]), voucherCount.toString()), (String)"kd.fi.gl.task.CheckVoucherCountTask");
                return false;
            }
        }
        return true;
    }
}

