/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checktools;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.gl.util.QFBuilder;

public class VoucherEntryNoHeadCheckTask
implements FIDataCheckTask {
    private static final String CHECK_SQL = "select top 1 ve.fid from t_gl_voucherentry ve left join t_gl_voucher v on v.fid = ve.fid where ve.forgid = ? and ve.fperiodid = ? and v.fid is null";
    private static final String ORG_ID = "org.id";
    private static final String CURPERIOD_ID = "curperiod.id";
    private static final String T_GL_VOUCHER = "t_gl_voucher";
    private static final String FORGID = "forgid";
    private static final String FPERIODID = "fperiodid";

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        if (tenantId.equals("agilepre") || tenantId.equals("pretest")) {
            return true;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("isbizunit", "=", true);
        Collection books = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)String.join((CharSequence)",", ORG_ID, CURPERIOD_ID), (QFilter[])qfBuilder.toArray()).values();
        Map orgIdPeriodIdMap = books.stream().collect(Collectors.groupingBy(x -> x.getLong(ORG_ID), Collectors.mapping(x -> x.getLong(CURPERIOD_ID), Collectors.toSet())));
        Set entries = orgIdPeriodIdMap.entrySet();
        try (QueryTimeout timeout = DB.timeout((int)60);){
            for (Map.Entry orgIdPeriodIdEntry : entries) {
                Set periodIdSet = orgIdPeriodIdEntry.getValue();
                for (Long periodId : periodIdSet) {
                    Long orgId = orgIdPeriodIdEntry.getKey();
                    HintCondition orgIdHint = new HintCondition(FORGID, FilterType.eq, (Object)orgId);
                    HintCondition periodIdHint = new HintCondition(FPERIODID, FilterType.eq, (Object)periodId);
                    ShardingHintContext ignored = ShardingHintContext.createAndSet((String)T_GL_VOUCHER, (HintCondition[])new HintCondition[]{orgIdHint, periodIdHint});
                    Throwable throwable = null;
                    try {
                        boolean pass = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)CHECK_SQL, (Object[])new Object[]{orgId, periodId}, resultSet -> !resultSet.next());
                        if (pass) continue;
                        FIDataCheckUtil.saveResult((String)"VoucherEntryNoHeadCheck", (String)"gl", (boolean)false, (String)ResManager.loadKDString((String)"\u5b58\u5728\u51ed\u8bc1\u5206\u5f55\u7f3a\u5c11\u51ed\u8bc1\u5934\u3002", (String)"VoucherEntryNoHeadCheckTask_0", (String)"fi-gl-common", (Object[])new Object[0]), (String)this.getClass().getName());
                        boolean bl = false;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
    }
}

