/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.balcal.CalculatorCFs;
import kd.fi.gl.closeperiod.AnitCloseCheckResult;
import kd.fi.gl.closeperiod.BizAntiCloseCheckerConfig;
import kd.fi.gl.closeperiod.IAntiCloseChecker;
import kd.fi.gl.closeperiod.breakpoint.OrgBooktypePeriod;
import kd.fi.gl.closing.ClosingErrorCode;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class ClosePeriodUtils {
    private static final String APP_GL = "gl";
    private static final Log LOGGER = LogFactory.getLog(ClosePeriodUtils.class);
    private static final String GL_AUTOCLOSEPERIOD = "gl_autocloseperiod";
    private static final String PERM_CLOSE = "4730fc9f000001ae";
    private static final String VOUCHER_LIST_CUSTOM_PARAM_KEY_FILTER = "filter";
    private static final String VOUCHER_LIST_CUSTOM_PARAM_KEY_SOURCE = "source";
    private static final String BOS_LIST = "bos_list";

    private ClosePeriodUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject getAccountBook(Long orgId, Long bookTypeId, String field) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
        return BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)field, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
    }

    public static DynamicObject getPeriod(Long periodId, String field) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)field, (QFilter[])filter.toArray());
    }

    public static int comparePeriod(Long periodId, Long otherPeriodId) {
        if (periodId == null || periodId <= 100000000L) {
            if (otherPeriodId != null && otherPeriodId > 100000000L) {
                return -1;
            }
            return 0;
        }
        if (otherPeriodId == null || otherPeriodId <= 100000000L) {
            return 1;
        }
        if (periodId.equals(otherPeriodId)) {
            return 0;
        }
        Long periodNumber = periodId % 100000000L;
        Long otherPeriodNumber = otherPeriodId % 100000000L;
        return periodNumber.compareTo(otherPeriodNumber);
    }

    public static boolean isHistoryOpenedPeriod(Long orgId, Long bookTypeId, Long periodId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", orgId);
        qfBuilder.add("booktype", "=", bookTypeId);
        qfBuilder.add("period", "=", periodId);
        return QueryServiceHelper.exists((String)"gl_openedperiod", (QFilter[])qfBuilder.toArray());
    }

    public static long getSelfPeriodIdByPeriodId(long periodId, long bookTypeId, long orgId) {
        return (Long)ThreadCache.get((Object)String.join((CharSequence)"_", "ClosePeriodUtils.getSelfPeriodIdByPeriodId", Long.toString(orgId), Long.toString(bookTypeId), Long.toString(periodId)), () -> {
            AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
            if (accountBook == null) {
                return 0L;
            }
            QFBuilder filters = new QFBuilder();
            filters.add("id", "=", periodId);
            DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters.toArray());
            if (periodDyn == null) {
                return 0L;
            }
            int periodYear = periodDyn.getInt("periodyear");
            int periodNumber = periodDyn.getInt("periodnumber");
            boolean isAdjust = periodDyn.getBoolean("isadjustperiod");
            long periodTypeId = accountBook.getPeriodTypeId();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("periodyear", "=", periodYear);
            qfBuilder.add("periodnumber", "=", periodNumber);
            qfBuilder.add("isadjustperiod", "=", isAdjust);
            qfBuilder.add("periodtype", "=", periodTypeId);
            List periodIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])qfBuilder.toArray(), null, (int)1);
            return periodIds.size() > 0 ? Long.parseLong(periodIds.get(0).toString()) : 0L;
        });
    }

    public static long getSelfPreviousPeriodIdByPeriodId(long periodId, long bookTypeId, long orgId) {
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
        if (accountBook == null) {
            return 0L;
        }
        long selfPeriodId = ClosePeriodUtils.getSelfPeriodIdByPeriodId(periodId, bookTypeId, orgId);
        long periodTypeId = accountBook.getPeriodTypeId();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("periodtype", "=", periodTypeId);
        qfBuilder.add("id", "<", selfPeriodId);
        List periodIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])qfBuilder.toArray(), (String)"periodyear desc, periodnumber desc, id desc", (int)1);
        return periodIds.size() > 0 ? Long.parseLong(periodIds.get(0).toString()) : 0L;
    }

    public static String antiCloseValidateOnGlClosePeriodHome(String bizAppId, String bookEntityName, Long orgId, String orgName, String bookTypeField, Object bookTypeVal, Long periodId) {
        DynamicObjectCollection books;
        StringBuilder errorMsg = new StringBuilder();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", orgId);
        if (StringUtils.isNotBlank((CharSequence)bookTypeField)) {
            qfBuilder.add(bookTypeField, "=", Long.valueOf(bookTypeVal.toString()));
        }
        if ((books = QueryServiceHelper.query((String)bookEntityName, (String)"curperiod", (QFilter[])qfBuilder.toArray())).isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5bf9\u5e94\u7684\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"ClosePeriodUtils_0", (String)"fi-gl-common", (Object[])new Object[0]), orgName));
        } else {
            List<IAntiCloseChecker> antiCheckers = BizAntiCloseCheckerConfig.getCheckers(bizAppId);
            for (IAntiCloseChecker antiChecker : antiCheckers) {
                if (!antiChecker.enable(bizAppId, bookTypeVal.toString(), orgId)) continue;
                long curPeriod = ((DynamicObject)books.get(0)).getLong("curperiod");
                QFilter beginF = new QFilter("id", ">=", (Object)periodId);
                QFilter endF = new QFilter("id", "<", (Object)curPeriod);
                QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{beginF, endF}, null, (int)-1).stream().anyMatch(periodToCheck -> {
                    AnitCloseCheckResult checkResult = antiChecker.check(bookEntityName, bizAppId, bookTypeField, orgId, bookTypeVal.toString(), (Long)periodToCheck);
                    if (!checkResult.isSuccess()) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c%2$s\n", (String)"ClosePeriodUtils_1", (String)"fi-gl-common", (Object[])new Object[0]), orgName, checkResult.getResultMessage()));
                    }
                    return !checkResult.isSuccess();
                });
            }
        }
        return errorMsg.toString();
    }

    public static boolean getCheckItemEnable(String bizAppCode, String subBizAppCode, Long orgId, String checkItemNumber) {
        if (StringUtils.isBlank((CharSequence)checkItemNumber)) {
            return false;
        }
        List checkItemDetails = ClosePeriodCheckExecutor.queryCheckItemList((String)BizAppServiceHelp.getAppIdByAppNumber((String)bizAppCode), (String)subBizAppCode, (Long)orgId, null);
        return checkItemDetails.stream().anyMatch(x -> checkItemNumber.equals(x.getNumber()) && x.getIsEffective());
    }

    public static void createVoucherBreakPoingOnCloseDetail(Long bookId, Long orgId, Long period, IFormView view) {
        if (null == view) {
            return;
        }
        DynamicObject bookDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFBuilder("id", "=", bookId).toArray());
        if (null == bookDyn) {
            return;
        }
        Long bookTypeId = bookDyn.getLong(GLField.id_("bookstype"));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, (long)bookTypeId);
        if (null == bookInfo) {
            return;
        }
        ListShowParameter list = new ListShowParameter();
        list.setBillFormId("gl_vouchernoadjust_layout");
        list.setFormId("gl_vouchernolist");
        list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("booktype", bookInfo.getBookTypeId());
        OrgBooktypePeriod orgBooktypePeriod = new OrgBooktypePeriod(bookInfo.getOrgId(), bookInfo.getBookTypeId(), period);
        orgBooktypePeriod.setChecked(true);
        List<OrgBooktypePeriod> orgBookTypePeriodList = Collections.singletonList(orgBooktypePeriod);
        customParams.put("orgBookTypePeriodList", JSON.toJSONString(orgBookTypePeriodList));
        list.setCustomParams(customParams);
        view.showForm((FormShowParameter)list);
    }

    public static void createVoucherListOnCloseDetail(QFilter filter, Long periodId, IFormView view) {
        DynamicObject periodDyn;
        if (null == view) {
            return;
        }
        ListShowParameter list = new ListShowParameter();
        if (filter != null) {
            Stream.concat(Stream.of(filter), filter.getNests(true).stream().map(QFilter.QFilterNest::getFilter)).forEach(f -> {
                switch (f.getProperty()) {
                    case "booktype": 
                    case "booktype.id": {
                        list.setCustomParam("booktype", (Object)f.getValue().toString());
                        break;
                    }
                    case "org": {
                        list.setCustomParam("org", (Object)f.getValue().toString());
                    }
                }
            });
            QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{filter}, null, (int)-1).forEach(arg_0 -> ((ListShowParameter)list).addLinkQueryPkId(arg_0));
        }
        if (null != (periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFBuilder("id", "=", periodId).toArray()))) {
            JSONArray bookdate = new JSONArray();
            bookdate.add((Object)periodDyn.getDate("begindate"));
            bookdate.add((Object)periodDyn.getDate("enddate"));
            list.setCustomParam("bookeddate", (Object)bookdate);
        }
        list.setCustomParam(VOUCHER_LIST_CUSTOM_PARAM_KEY_SOURCE, (Object)"PeriodCloseDetail");
        list.setBillFormId("gl_voucher");
        list.setFormId(BOS_LIST);
        list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)list);
    }

    public static void createFormOnCloseDetail(String formId, Map<String, Object> customParams, IFormView view) {
        if (null == view) {
            return;
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId(formId);
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setCustomParams(customParams);
        view.showForm(form);
    }

    public static void createJumpInterfaceOnCloseDetail(String formNumber, String queryContitions, IFormView view) {
        if (null == view) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        if (formNumber.startsWith("https://") || formNumber.startsWith("http://")) {
            view.openUrl(formNumber);
        } else {
            QFilter filter = null;
            try {
                filter = QFilter.fromSerializedString((String)queryContitions);
            }
            catch (Exception e) {
                LOGGER.error(ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u8d26\u8df3\u8f6c\u5904\u7406\u9875\u9762\u8f6c\u5316\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClosePeriodUtils_2", (String)"fi-gl-common", (Object[])new Object[0]) + GLUtil.printError(e));
                throw new KDBizException(ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u8d26\u8df3\u8f6c\u5904\u7406\u9875\u9762\u8f6c\u5316\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClosePeriodUtils_2", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            ListShowParameter list = new ListShowParameter();
            list.setBillFormId(formNumber);
            list.setFormId(BOS_LIST);
            list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (null != filter) {
                List<Object> queryPrimaryKeys = ClosePeriodUtils.queryPrimaryKeys(formNumber, filter);
                for (Object pk : queryPrimaryKeys) {
                    list.addLinkQueryPkId(pk);
                }
            }
            view.showForm((FormShowParameter)list);
        }
    }

    private static List<Object> queryPrimaryKeys(String formNumber, QFilter filter) {
        return QueryServiceHelper.queryPrimaryKeys((String)formNumber, (QFilter[])filter.toArray(), null, (int)-1);
    }

    public static void addBatchLog(boolean success, String opKeyWord, String operationKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, long orgId, String ... descParams) {
        String appId = EntityMetadataCache.getDataEntityType((String)GL_AUTOCLOSEPERIOD).getAppId();
        String id = AppMetadataCache.getAppInfo((String)appId).getId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(id);
        appLogInfo.setBizObjID(GL_AUTOCLOSEPERIOD);
        appLogInfo.setKeyWord(opKeyWord);
        appLogInfo.setStatus(success ? "1" : "0");
        appLogInfo.setOpDesc(opDescBridge, descParams);
        appLogInfo.setOpName(operationKey, opNameBridge);
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOrgID(Long.valueOf(orgId));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientType(RequestContext.get().getClient());
        ArrayList<OpLogAppInfo> list = new ArrayList<OpLogAppInfo>();
        list.add(appLogInfo);
        LogServiceHelper.addBatchLog(list);
    }

    public static boolean closeCheck(DynamicObject bookDyn, DynamicObjectCollection entitys, long org, long curperiod, long previousPeriod, long booktype) {
        boolean result = true;
        long period = curperiod;
        int checkPeriod = ClosePeriodUtils.checkPeriod(curperiod, previousPeriod, org, booktype, entitys);
        if (checkPeriod > 0) {
            period = previousPeriod;
        } else if (checkPeriod < 0) {
            result = false;
        }
        StringBuilder logSb = new StringBuilder();
        if ("0".equals(bookDyn.getString("enable"))) {
            ClosePeriodUtils.setCheckInfo(entitys, ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528", (String)"ClosePeriodUtils_3", (String)"fi-gl-common", (Object[])new Object[0]), "0", null, null, ResManager.loadKDString((String)"\u8be5\u516c\u53f8\u5728\u6b64\u8d26\u7c3f\u7c7b\u578b\u4e0b\u7684\u8d26\u7c3f\u5df2\u88ab\u7981\u7528\u3002", (String)"ClosePeriodUtils_4", (String)"fi-gl-common", (Object[])new Object[0]), "");
            return false;
        }
        ClosePeriodUtils.balanceEqual(org, period, booktype);
        CheckItemExecutionParam checkItemExecutionParam = new CheckItemExecutionParam(BizAppServiceHelp.getAppIdByAppNumber((String)APP_GL), String.valueOf(booktype), Long.valueOf(org), Long.valueOf(period), null, "");
        CheckExecutionResult executeResult = ClosePeriodCheckExecutor.instance.execute(checkItemExecutionParam);
        List itemCheckResultList = executeResult.getItemCheckResultList();
        LOGGER.info("ClosePeriodOpLog-size" + itemCheckResultList.size());
        for (CheckExecutionResult.CheckResultWrapper checkResultWrapper : itemCheckResultList) {
            logSb.append(checkResultWrapper.getCheckItem().getName());
            logSb.append("-");
            logSb.append(checkResultWrapper.getExecuteStatus().getCode());
            logSb.append(";");
            ClosePeriodUtils.setCheckInfo(entitys, checkResultWrapper);
        }
        LOGGER.info("ClosePeriodOpLog-checkResult" + logSb);
        return result ? executeResult.isFinalApproval() : result;
    }

    private static void balanceEqual(long org, long period, long booktype) {
        CalculatorCFs.calculator(org, booktype, period, "gl_balance_log", true);
        CalculatorCFs.calculator(org, booktype, period, "gl_cashflow_log", true);
    }

    private static void setCheckInfo(DynamicObjectCollection entitys, CheckExecutionResult.CheckResultWrapper checkResultWrapper) {
        CheckItemDetail checkItem = checkResultWrapper.getCheckItem();
        ExecuteStatus executeStatus = checkResultWrapper.getExecuteStatus();
        String errMsg = checkResultWrapper.getErrMsg();
        if (ExecuteStatus.PASS.equals((Object)executeStatus)) {
            ClosePeriodUtils.setSuccessInfo(entitys, checkItem.getName(), "1", checkItem.getCustomizeIcon());
        } else if (ExecuteStatus.FAIL.equals((Object)executeStatus)) {
            String onlineViewId;
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = checkItem.getName();
            }
            if (StringUtils.isNotBlank((CharSequence)(onlineViewId = checkItem.getOnlineViewId())) && !"gl_balance".equals(onlineViewId)) {
                errMsg = null;
            }
            String filterStr = "";
            QFilter[] billFilters = checkResultWrapper.getBillFilters();
            if (!Objects.isNull(billFilters) && billFilters.length > 0) {
                QFilter filter = null;
                for (QFilter qFilter : billFilters) {
                    filter = null == filter ? qFilter : filter.and(qFilter);
                }
                if (null != filter) {
                    filterStr = filter.toSerializedString();
                }
            }
            ClosePeriodUtils.setCheckInfo(entitys, checkItem.getName(), "0", filterStr, onlineViewId, errMsg, checkItem.getCustomizeIcon());
        } else {
            ClosePeriodUtils.setCheckInfo(entitys, checkItem.getName(), "0", null, null, errMsg, checkItem.getCustomizeIcon());
        }
    }

    private static DynamicObject setCheckInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String formquery, String formnumber, String message, String menuid) {
        DynamicObject entity = ClosePeriodUtils.setSuccessInfo(entitys, checkitem, checkstate, menuid);
        entity.set("formquery", (Object)formquery);
        entity.set("formnumber", (Object)formnumber);
        entity.set("message", (Object)message);
        return entity;
    }

    private static DynamicObject setSuccessInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String menuid) {
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)checkitem);
        entity.set("checkstate", (Object)checkstate);
        if (StringUtils.isBlank((CharSequence)menuid)) {
            menuid = "kingdee/fi/images/pc/icon/menu/7qmjz_48_48.png";
        }
        entity.set("menuid", (Object)menuid);
        entitys.add((Object)entity);
        return entity;
    }

    public static int checkPeriod(Long curPeriodId, Long closePeriodId, Long orgId, Long bookTypeId, DynamicObjectCollection entitys) {
        int reslut = 0;
        String icon = "/icons/pc/entrance/cn_dianzihuidan_48_48.png";
        if (ClosePeriodUtils.isHistoryOpenedPeriod(orgId, bookTypeId, closePeriodId)) {
            ClosePeriodUtils.setSuccessInfo(entitys, ResManager.loadKDString((String)"\u662f\u5386\u53f2\u6253\u5f00\u671f\u95f4", (String)"ClosePeriodUtils_5", (String)"fi-gl-common", (Object[])new Object[0]), "1", icon);
            reslut = 1;
        } else {
            int compareToCurPeriod = ClosePeriodUtils.comparePeriod(closePeriodId, curPeriodId);
            if (compareToCurPeriod < 0) {
                ClosePeriodUtils.setCheckInfo(entitys, ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u4e0d\u7b26", (String)"ClosePeriodUtils_6", (String)"fi-gl-common", (Object[])new Object[0]), "0", null, null, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5927\u4e8e\u6216\u7b49\u4e8e\u5f85\u7ed3\u8d26\u671f\u95f4\u3002", (String)"ClosePeriodUtils_7", (String)"fi-gl-common", (Object[])new Object[0]), icon);
                reslut = -1;
            } else {
                ClosePeriodUtils.setSuccessInfo(entitys, ResManager.loadKDString((String)"\u662f\u5f53\u524d\u671f\u95f4", (String)"ClosePeriodUtils_8", (String)"fi-gl-common", (Object[])new Object[0]), "1", icon);
            }
        }
        return reslut;
    }

    public static boolean doReverseClosing(IFormPlugin formPlugin, IFormView view, List<Long> selectedPeriodIds, boolean isConfirm, boolean isFromNew) {
        boolean isAllSuccess;
        IPageCache pageCache = view.getPageCache();
        IDataModel model = view.getModel();
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)pageCache.get("closeInfo"), ClosePeriodInfo.class);
        String bizAppId = closeInfo.getBizapp();
        String bizFormId = closeInfo.getFormId();
        String formId = "gl_accountbook".equals(bizFormId) ? GL_AUTOCLOSEPERIOD : bizFormId;
        StringBuilder sb = new StringBuilder();
        String bookTypeField = closeInfo.getTypeFieldName();
        ArrayList<DynamicObject> opDatas = new ArrayList<DynamicObject>();
        int index = 0;
        if (isFromNew) {
            ReportList control = (ReportList)view.getControl("reportlistap");
            Object rowIdxs = control.getEntryState().getSelectedRows();
            for (int i = 0; i < ((Object)rowIdxs).length; ++i) {
                DynamicObject rowData = control.getReportModel().getRowData((int)rowIdxs[i]);
                long pid = rowData.getLong("pid");
                if (rowData.getInt("isgroupnode") == 0 && pid > 0L) continue;
                DynamicObject org = rowData.getDynamicObject("org");
                Long bookTypeId = rowData.getLong("bookstype.id");
                String validateErrorMsg = ClosePeriodUtils.antiCloseValidateOnGlClosePeriodHome(bizAppId, bizFormId, org.getLong("id"), org.getString("name"), bookTypeField, bookTypeId, selectedPeriodIds.get(0));
                if (StringUtils.isNotBlank((CharSequence)validateErrorMsg)) {
                    sb.append(validateErrorMsg).append("\n");
                    continue;
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)formId);
                dy.set("id", (Object)index++);
                dy.set("org", (Object)org);
                dy.set("curperiod", (Object)selectedPeriodIds.get(0));
                if (StringUtils.isNotBlank((CharSequence)bookTypeField)) {
                    dy.set(bookTypeField, (Object)bookTypeId);
                }
                opDatas.add(dy);
            }
        } else {
            DynamicObjectCollection selectOrgs = (DynamicObjectCollection)model.getValue("periodcloseorg");
            for (DynamicObject selectOrg : selectOrgs) {
                DynamicObject org = (DynamicObject)selectOrg.get(1);
                Long orgId = Long.valueOf(org.getPkValue().toString());
                String bookscombo = (String)model.getValue("bookscombo");
                Long bookTypeId = StringUtils.isNotBlank((CharSequence)bookscombo) ? Long.parseLong(bookscombo) : 0L;
                String validateErrorMsg = ClosePeriodUtils.antiCloseValidateOnGlClosePeriodHome(bizAppId, bizFormId, orgId, org.getString("name"), bookTypeField, bookTypeId, selectedPeriodIds.get(0));
                if (StringUtils.isNotBlank((CharSequence)validateErrorMsg)) {
                    sb.append(validateErrorMsg).append("\n");
                    continue;
                }
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)formId);
                dy.set("id", (Object)index++);
                dy.set("org", (Object)org);
                dy.set("curperiod", (Object)selectedPeriodIds.get(0));
                if (StringUtils.isNotBlank((CharSequence)bookTypeField)) {
                    dy.set(bookTypeField, (Object)bookTypeId);
                }
                opDatas.add(dy);
            }
        }
        OperateOption option = OperateOption.create();
        String selectedPeriodIdsJson = SerializationUtils.toJsonString(selectedPeriodIds);
        if (APP_GL.equals(bizAppId)) {
            option.setVariableValue("mul_select_period", selectedPeriodIdsJson);
        }
        int successSize = opDatas.size();
        if (isConfirm) {
            pageCache.remove("doReverseClosing.selectedPeriodIds");
            option.setVariableValue(ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode(), "ignore");
        } else {
            pageCache.put("doReverseClosing.selectedPeriodIds", selectedPeriodIdsJson);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"anticloseperiod", (String)formId, (DynamicObject[])opDatas.toArray(new DynamicObject[0]), (OperateOption)option);
        ArrayList<String> currentAccountWarnMsgs = new ArrayList<String>(successSize);
        if (result.isSuccess() && successSize != 0) {
            String appid = ClosePeriodUtils.getAppId(view);
            DynamicObject nextPeriod = !APP_GL.equals(appid) ? GLUtil.getNextPeriod(selectedPeriodIds.get(0), false) : GLUtil.getNextPeriod(selectedPeriodIds.get(0));
            long nextPeriodId = nextPeriod != null ? nextPeriod.getLong("id") : selectedPeriodIds.get(0).longValue();
            model.setValue("periodedit", (Object)nextPeriodId);
        } else {
            List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo r : allErrorOrValidateInfo) {
                OperateErrorInfo info = (OperateErrorInfo)r;
                if (info.getLevel() == ErrorLevel.Warning && ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode().equals(info.getErrorCode())) {
                    currentAccountWarnMsgs.add(info.getMessage());
                    continue;
                }
                sb.append(info.getMessage()).append("\n");
            }
        }
        if (!currentAccountWarnMsgs.isEmpty()) {
            view.showConfirm(ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getMessage(), String.join((CharSequence)"\n", currentAccountWarnMsgs), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode(), formPlugin));
            return false;
        }
        boolean bl = isAllSuccess = successSize == result.getSuccessPkIds().size();
        if (sb.length() == 0 && isAllSuccess) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u6210\u529f\u3002", (String)"PeriodcloseHomePlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        } else {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u53cd\u7ed3\u8d26\u64cd\u4f5c\u5b8c\u6210\uff0c%d\u5bb6\u516c\u53f8\u53cd\u7ed3\u8d26\u6210\u529f\u3002", (String)"PeriodcloseHomePlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), result.getSuccessPkIds().size()), sb.toString(), MessageTypes.Default);
        }
        return true;
    }

    private static String getAppId(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String appId = (String)parameter.getCustomParam("closePeriodApp");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = parameter.getAppId();
        }
        return appId == null ? "" : appId;
    }

    public static Optional<List<Long>> getHasClosePermOrgIds(ClosePeriodInfo closeInfo) {
        String appId = AppMetadataCache.getAppInfo((String)closeInfo.getBizapp()).getId();
        HasPermOrgResult closePermOrgResult = null;
        List hasPermOrgIdList = null;
        closePermOrgResult = APP_GL.equals(closeInfo.getBizapp()) ? PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)AppMetadataCache.getAppInfo((String)APP_GL).getId(), (String)GL_AUTOCLOSEPERIOD, (String)PERM_CLOSE) : PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)closeInfo.getFormId().toLowerCase(), (String)PERM_CLOSE);
        if (!closePermOrgResult.hasAllOrgPerm()) {
            hasPermOrgIdList = closePermOrgResult.getHasPermOrgs();
        }
        return Optional.ofNullable(hasPermOrgIdList);
    }
}

