/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod;

import java.util.ArrayList;
import java.util.List;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.fi.gl.closeperiod.plugin.AcInitializeStatusChecker;
import kd.fi.gl.closeperiod.plugin.AcNoticeCheckStatusCloseChecker;
import kd.fi.gl.closeperiod.plugin.AccountTableExistsChecker;
import kd.fi.gl.closeperiod.plugin.BizSystemCloseChecker;
import kd.fi.gl.closeperiod.plugin.CfNoticeCheckStatusCloseChecker;
import kd.fi.gl.closeperiod.plugin.InitializeCashFlowCloseChecker;
import kd.fi.gl.closeperiod.plugin.InitializeStatusChecker;
import kd.fi.gl.closeperiod.plugin.PLAccountBalanceChecker;
import kd.fi.gl.closeperiod.plugin.StartPeriodExistsChecker;
import kd.fi.gl.closeperiod.plugin.VoucherAmortStatusChecker;
import kd.fi.gl.closeperiod.plugin.VoucherConsistentChecker;
import kd.fi.gl.closeperiod.plugin.VoucherPostChecker;

public class GlCheckerConfig {
    private static int CHECKERS_SIZE = 12;

    private GlCheckerConfig() {
        throw new IllegalStateException("Utility class");
    }

    public static List<IClosePeriodCheckPlugin> getCheckers() {
        ArrayList<IClosePeriodCheckPlugin> checkers = new ArrayList<IClosePeriodCheckPlugin>(CHECKERS_SIZE);
        checkers.add(new VoucherAmortStatusChecker());
        checkers.add(new PLAccountBalanceChecker());
        checkers.add(new BizSystemCloseChecker());
        checkers.add(new AcNoticeCheckStatusCloseChecker());
        checkers.add(new CfNoticeCheckStatusCloseChecker());
        checkers.add(new InitializeCashFlowCloseChecker());
        checkers.add(new InitializeStatusChecker());
        checkers.add(new VoucherPostChecker());
        checkers.add(new StartPeriodExistsChecker());
        checkers.add(new AccountTableExistsChecker());
        checkers.add(new VoucherConsistentChecker());
        checkers.add(new AcInitializeStatusChecker());
        return checkers;
    }

    public static IClosePeriodCheckPlugin getChecker(String number) {
        switch (number) {
            case "VoucherAmortStatusCheck": {
                return new VoucherAmortStatusChecker();
            }
            case "PLAccountBalanceCheck": {
                return new PLAccountBalanceChecker();
            }
            case "BizSystemCloseCheck": {
                return new BizSystemCloseChecker();
            }
            case "AcNoticeStatusCheck": {
                return new AcNoticeCheckStatusCloseChecker();
            }
            case "CfNoticeStatusCheck": {
                return new CfNoticeCheckStatusCloseChecker();
            }
            case "CashFlowInitCheck": {
                return new InitializeCashFlowCloseChecker();
            }
            case "InitializeStatusCheck": {
                return new InitializeStatusChecker();
            }
            case "VoucherPostCheck": {
                return new VoucherPostChecker();
            }
            case "StartPeriodExistsCheck": {
                return new StartPeriodExistsChecker();
            }
            case "AccountTableExistsCheck": {
                return new AccountTableExistsChecker();
            }
            case "VoucherConsistentCheck": {
                return new VoucherConsistentChecker();
            }
            case "AcInitializeStatusCheck": {
                return new AcInitializeStatusChecker();
            }
        }
        return null;
    }
}

